import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  Wave
} from "./chunk.POFWU6ZT.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/audio/audio.ts
import { css, html } from "lit";
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var SdAudio = class extends SolidElement {
  constructor() {
    super();
    this.localize = new LocalizeController(this);
    this.hasSlotController = new HasSlotController(this, "transcript");
    this.reversedLayout = false;
    this.hideTimestamps = false;
    this.animated = false;
    this.inverted = false;
    this.speed = 1;
    this.currentTime = this.formatTime(0);
    this.duration = "";
    this.isPlaying = false;
    this.isMuted = false;
    this.progress = 0;
    this.setAudioProgress = () => {
      this.progressSlider.max = Math.floor(this.audioElement.duration).toString();
    };
    this.updateCurrentTime = this.updateCurrentTime.bind(this);
    this.handleAudioEnd = this.handleAudioEnd.bind(this);
    this.handleAudioProgress = this.handleAudioProgress.bind(this);
    this.handleAudioProgressKeydown = this.handleAudioProgressKeydown.bind(this);
  }
  firstUpdated() {
    if (!this.audioElement) return;
    this.audioElement.addEventListener("timeupdate", this.updateCurrentTime);
    this.audioElement.addEventListener("ended", this.handleAudioEnd);
    this.audioElement.setAttribute("controlsList", "nodownload");
    this.audioElement.playbackRate = this.speed;
    if (this.animated) {
      this.initAnimation();
    }
  }
  updated(changedProperties) {
    if (changedProperties.has("animated")) {
      const oldValue = changedProperties.get("animated");
      if (!oldValue && this.animated) {
        this.initAnimation();
      } else if (oldValue && !this.animated) {
        this.clear();
      }
    }
  }
  get audioElement() {
    const slot = this.shadowRoot.querySelector("slot");
    if ((slot == null ? void 0 : slot.assignedElements().length) > 0) {
      return slot.assignedElements()[0];
    }
    return null;
  }
  updateCurrentTime() {
    if (!this.audioElement) return;
    const currentTime = this.audioElement.currentTime;
    this.currentTime = this.formatTime(currentTime);
    this.progress = Math.floor(currentTime);
    if (this.progressSlider) {
      this.progressSlider.value = this.progress.toString();
    }
  }
  updateAudioDuration() {
    if (!this.audioElement) return;
    if (isNaN(this.audioElement.duration)) {
      setTimeout(() => {
        this.updateAudioDuration();
      }, 100);
      return;
    }
    this.duration = this.formatTime(this.audioElement.duration);
    this.setAudioProgress();
  }
  playAudio() {
    if (!this.audioElement) return;
    this.isPlaying = true;
    this.audioElement.play();
    this.emit("sd-playback-start");
    if (this.animated) {
      this.draw();
    }
  }
  pauseAudio() {
    if (!this.audioElement) return;
    this.isPlaying = false;
    this.audioElement.pause();
    this.emit("sd-playback-pause");
    if (this.animated) {
      this.stopAnimation();
    }
  }
  handleAudioEnd() {
    this.emit("sd-playback-end");
    this.isPlaying = false;
    this.progress = 0;
    this.progressSlider.value = "0";
    this.currentTime = this.formatTime(0);
    if (this.animated) {
      this.stopAnimation();
    }
  }
  toggleMute() {
    if (!this.audioElement) return;
    this.isMuted = !this.isMuted;
    if (this.isMuted) {
      this.emit("sd-playback-mute");
      this.audioElement.muted = true;
    } else {
      this.emit("sd-playback-unmute");
      this.audioElement.muted = false;
    }
  }
  toggleMuteKeydown(event) {
    if (event.key === "Enter") {
      event.preventDefault();
      this.toggleMute();
    }
  }
  togglePlaybackSpeed() {
    if (!this.audioElement) return;
    this.emit("sd-playback-speed");
    this.speed = this.speed === 1.5 ? 1 : this.speed + 0.25;
    this.audioElement.playbackRate = this.speed;
  }
  togglePlaybackSpeedKeydown(event) {
    if (event.key === "Enter") {
      event.preventDefault();
      this.togglePlaybackSpeed();
    }
  }
  formatTime(time) {
    const minutes = Math.floor(time / 60);
    const seconds = Math.floor(time % 60);
    return `${minutes}:${seconds < 10 ? "0" : ""}${seconds}`;
  }
  handleAudioProgress() {
    if (!this.audioElement) return;
    const newTime = Number(this.progressSlider.value);
    this.audioElement.currentTime = newTime;
    this.progress = newTime;
    this.currentTime = this.formatTime(newTime);
  }
  handleAudioProgressKeydown(event) {
    if (event.key === "ArrowRight") {
      this.progressSlider.value = (Number(this.progressSlider.value) + 1).toString();
      this.handleAudioProgress();
    }
    if (event.key === "ArrowLeft") {
      this.progressSlider.value = (Number(this.progressSlider.value) - 1).toString();
      this.handleAudioProgress();
    }
  }
  showTranscript() {
    this.emit("sd-transcript-click");
    this.drawer.open = true;
  }
  showTranscriptKeydown(event) {
    if (event.key === "Enter" || event.key === " ") {
      this.showTranscript();
    }
  }
  rgbToHex(rgbString) {
    const result = rgbString.match(/\d+/g);
    if (result && result.length === 3) {
      const r = parseInt(result[0]);
      const g = parseInt(result[1]);
      const b = parseInt(result[2]);
      const valueToHex = (value) => value.toString(16).padStart(2, "0");
      const hex = `#${valueToHex(r)}${valueToHex(g)}${valueToHex(b)}`.toUpperCase();
      return hex;
    }
    return null;
  }
  initAnimation() {
    this.context = this.canvas.getContext("2d");
    const button = this.audioPlayerContainer.querySelector(".playback-speed");
    const computedStyles = window.getComputedStyle(button);
    const color = computedStyles.color;
    let computedColor;
    if (this.inverted) {
      computedColor = `#FFFFFF33`;
    } else {
      computedColor = this.rgbToHex(color) + "33";
    }
    this.waveList = [
      new Wave({
        canvas: this.canvas,
        color: computedColor,
        phase: 240,
        shift: 1.5,
        amplitude: 230,
        frequency: 0.012,
        damping: 1
      }),
      new Wave({
        canvas: this.canvas,
        color: computedColor,
        phase: 180,
        shift: 2.5,
        amplitude: 250,
        frequency: 5e-3,
        damping: 1
      }),
      new Wave({
        canvas: this.canvas,
        color: computedColor,
        phase: 180,
        shift: -2.5,
        amplitude: 250,
        frequency: 5e-3,
        damping: 1
      }),
      new Wave({
        canvas: this.canvas,
        color: computedColor,
        phase: 180,
        shift: -1,
        amplitude: 200,
        frequency: 0.018,
        damping: 1
      }),
      new Wave({
        canvas: this.canvas,
        color: computedColor,
        phase: 180,
        shift: 1.5,
        amplitude: 150,
        frequency: 0.01,
        damping: 1
      })
    ];
    if (this.animated) {
      this.drawStillWaves();
    }
  }
  drawStillWaves() {
    this.waveList.forEach((wave) => {
      wave.redraw();
    });
  }
  stopAnimation() {
    this.isPlaying = false;
  }
  clear() {
    if (!this.context || !this.canvas) return;
    this.context.clearRect(0, 0, this.canvas.width, this.canvas.height);
  }
  async draw() {
    if (!this.isPlaying || !this.animated) return;
    this.clear();
    this.waveList.forEach((wave) => {
      wave.redraw();
    });
    await new Promise((resolve) => {
      setTimeout(resolve, 1e3 / 30);
    });
    await this.draw();
  }
  render() {
    const progressPercentage = this.audioElement ? this.progress / this.audioElement.duration * 100 : 0;
    const renderAudioControls = html`<div class="${cx(
      "controls grid grid-cols-3 justify-items-center items-center",
      !this.animated && "relative",
      this.animated && !this.reversedLayout && "absolute -top-4 left-0 w-full",
      this.reversedLayout ? "mt-2" : "mb-2"
    )}" part="audio-controls"><button class="${cx(
      "playback-speed justify-self-start text-base font-bold hover:cursor-pointer sd-interactive",
      this.inverted && "sd-interactive--inverted"
    )}" aria-label="${this.localize.term("playbackSpeed")}" tabindex="0" @click="${this.togglePlaybackSpeed}" @keydown="${this.togglePlaybackSpeedKeydown}" part="playback-speed">${this.speed}x</button><sd-4-0-5-button ?inverted="${this.inverted ? true : false}" part="play-button" size="lg" @click="${!this.isPlaying ? this.playAudio : this.pauseAudio}" aria-label="${this.isPlaying ? this.localize.term("pauseAudio") : this.localize.term("playAudio")}" class="text-3xl">${this.isPlaying ? html`<slot name="pause-icon"><sd-4-0-5-icon class="text-3xl" name="pause" library="system"></sd-4-0-5-icon></slot>` : html`<slot name="play-icon"><sd-4-0-5-icon class="text-3xl" name="start" library="system"></sd-4-0-5-icon></slot>`}</sd-4-0-5-button><div class="flex items-center justify-self-end">${this.hasSlotController.test("transcript") ? html`<button class="${cx(
      "mr-6 w-6 h-6 hover:cursor-pointer sd-interactive",
      this.inverted && "sd-interactive--inverted"
    )}" @click="${this.showTranscript}" @keydown="${this.showTranscriptKeydown}" tab-index="0"><sd-4-0-5-icon class="w-6 h-6" name="transcript" library="system" label="${this.isMuted ? this.localize.term("unmute") : this.localize.term("mute")}"></sd-4-0-5-icon></button>` : null} <button class="${cx("w-6 h-6 hover:cursor-pointer sd-interactive", this.inverted && "sd-interactive--inverted")}" part="volume" aria-label="${this.localize.term("mute")}" tabindex="0" @click="${this.toggleMute}" @keydown="${this.toggleMuteKeydown}"><sd-4-0-5-icon class="w-6 h-6" name="${this.isMuted ? "mute" : "volume"}" library="system"></sd-4-0-5-icon></button></div></div>`;
    const renderTimestamps = html`<div class="${cx(
      "w-full flex justify-between",
      this.reversedLayout ? "mb-2" : "mt-2",
      this.animated && this.reversedLayout && "absolute bottom-0 left-0 mb-2",
      this.animated && !this.reversedLayout && "mt-2"
    )}" part="timestamps"><div class="${cx("current-time text-sm", this.inverted ? "text-primary-400" : "text-neutral-700")}">${this.currentTime}</div><div class="${cx("current-time text-sm", this.inverted ? "text-primary-400" : "text-neutral-700")}">${this.duration}</div></div>`;
    return html`<div class="${cx("w-full flex relative", this.reversedLayout ? "flex-col-reverse" : "flex-col")}" aria-label="${this.localize.term("audioPlayer")}" part="audio-player"><slot @slotchange="${this.updateAudioDuration}"></slot>${!this.animated || this.animated && this.reversedLayout ? renderAudioControls : null}<div class="relative">${this.animated && !this.reversedLayout ? html`${renderAudioControls}` : null} ${this.animated ? html`<canvas class="w-full h-16"></canvas>` : null} ${!this.hideTimestamps && this.animated && this.reversedLayout ? renderTimestamps : null} <input class="${cx(
      "progress-slider bg-primary appearance-none w-full cursor-pointer outline-none h-1 flex items-center sd-interactive",
      this.inverted && "sd-interactive--inverted"
    )}" type="range" max="100" step="0.001" value="${this.progress}" tabindex="0" @input="${this.handleAudioProgress}" @keydown="${this.handleAudioProgressKeydown}" part="progress-slider" style="background:linear-gradient(to right,${this.inverted ? "rgb(var(--sd-color-white, 255 255 255) / 1)" : "rgb(var(--sd-color-primary, 0 53 142) / 1)"} ${progressPercentage}%,${this.animated ? "transparent" : this.inverted ? "rgb(var(--sd-color-primary-400, 153 171 208) / 1)" : "rgb(var(--sd-color-grey-400, 195 195 195) / 1)"} ${progressPercentage}%)"></div>${this.hasSlotController.test("transcript") ? html`<sd-4-0-5-drawer><slot name="transcript"></slot></sd-4-0-5-drawer>` : null} ${!this.hideTimestamps && (!this.animated || !this.reversedLayout) ? renderTimestamps : null}</div>`;
  }
};
SdAudio.styles = [
  ...SolidElement.styles,
  css`.progress-slider:focus-visible{outline:2px solid transparent;outline-offset:2px}.progress-slider::-webkit-slider-thumb{-webkit-appearance:none;appearance:none;background-color:currentColor;border-radius:var(--sd-border-radius-full,9999px);border-style:none;height:var(--sd-spacing-4,1rem);transition-duration:.2s;-webkit-transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,-webkit-backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,-webkit-backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter,-webkit-backdrop-filter;transition-timing-function:cubic-bezier(.4,0,.2,1);width:var(--sd-spacing-4,1rem)}.progress-slider:focus-visible::-webkit-slider-thumb{outline-offset:2px;outline-style:solid}.progress-slider::-moz-range-thumb{-moz-appearance:none;appearance:none;background-color:currentColor;border-radius:var(--sd-border-radius-full,9999px);border-style:none;height:var(--sd-spacing-4,1rem);transition-duration:.2s;-moz-transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter;transition-timing-function:cubic-bezier(.4,0,.2,1);width:var(--sd-spacing-4,1rem)}.progress-slider:focus-visible::-moz-range-thumb{outline-offset:2px;outline-style:solid}sd-4-0-5-button::part(base){align-items:center;border-radius:var(--sd-border-radius-full,9999px);display:flex;height:var(--sd-spacing-16,4rem);justify-content:center;width:var(--sd-spacing-16,4rem)}sd-4-0-5-button::part(label){align-items:center;display:flex;flex-grow:0}`
];
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "reversed-layout" })
], SdAudio.prototype, "reversedLayout", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "hide-timestamps" })
], SdAudio.prototype, "hideTimestamps", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdAudio.prototype, "animated", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdAudio.prototype, "inverted", 2);
__decorateClass([
  property({ type: Number })
], SdAudio.prototype, "speed", 2);
__decorateClass([
  state()
], SdAudio.prototype, "currentTime", 2);
__decorateClass([
  state()
], SdAudio.prototype, "duration", 2);
__decorateClass([
  state()
], SdAudio.prototype, "isPlaying", 2);
__decorateClass([
  state()
], SdAudio.prototype, "isMuted", 2);
__decorateClass([
  state()
], SdAudio.prototype, "progress", 2);
__decorateClass([
  query('[part="progress-slider"]')
], SdAudio.prototype, "progressSlider", 2);
__decorateClass([
  query('[part="audio-player"]')
], SdAudio.prototype, "audioPlayerContainer", 2);
__decorateClass([
  query("sd-4-0-5-drawer")
], SdAudio.prototype, "drawer", 2);
__decorateClass([
  query("canvas")
], SdAudio.prototype, "canvas", 2);
SdAudio = __decorateClass([
  customElement("sd-4-0-5-audio")
], SdAudio);

export {
  SdAudio
};
