// src/components/combobox/utils.ts
var getAssignedElementsForSlot = (slot) => Array.from(slot.assignedElements({ flatten: true }));
var getOptionOrNestedOptions = (item) => item.tagName.toLocaleLowerCase() === "sd-4-0-5-option" ? item : Array.from(item.querySelectorAll(":scope > sd-4-0-5-option"));
var isOptgroup = (item) => item.tagName.toLocaleLowerCase() === "sd-4-0-5-optgroup";
var getAllOptions = (items) => items.map(getOptionOrNestedOptions);
var filterOnlyOptgroups = (items) => items.filter(isOptgroup);
var normalizeString = (str) => str.normalize("NFD").replace(/[\u0300-\u036f]/g, "").toLowerCase();

export {
  getAssignedElementsForSlot,
  getOptionOrNestedOptions,
  isOptgroup,
  getAllOptions,
  filterOnlyOptgroups,
  normalizeString
};
