import {
  requestIcon
} from "./chunk.P52GZVKG.js";
import {
  getIconLibrary,
  unwatchIcon,
  watchIcon
} from "./chunk.JCK5DTZN.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/icon/icon.ts
import { css, html } from "lit";
import { property, state } from "lit/decorators.js";
import { unsafeSVG } from "lit/directives/unsafe-svg.js";
var parser;
var SdIcon = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.svg = "";
    this.label = "";
    this.library = "default";
    this.color = "currentColor";
  }
  connectedCallback() {
    super.connectedCallback();
    watchIcon(this);
  }
  firstUpdated() {
    this.setIcon();
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    unwatchIcon(this);
  }
  getUrl() {
    const library = getIconLibrary(this.library);
    if (this.name && library) {
      return library.resolver(this.name);
    }
    return this.src;
  }
  handleLabelChange() {
    const hasLabel = typeof this.label === "string" && this.label.length > 0;
    if (hasLabel) {
      this.setAttribute("role", "img");
      this.setAttribute("aria-label", this.label);
      this.removeAttribute("aria-hidden");
    } else {
      this.removeAttribute("role");
      this.removeAttribute("aria-label");
      this.setAttribute("aria-hidden", "true");
    }
  }
  async setIcon() {
    var _a;
    const library = getIconLibrary(this.library);
    const url = this.getUrl();
    if (!parser) {
      parser = new DOMParser();
    }
    if (url) {
      try {
        const file = await requestIcon(url);
        if (url !== this.getUrl()) {
        } else if (file.ok) {
          const doc = parser.parseFromString(file.svg, "text/html");
          const svgEl = doc.body.querySelector("svg");
          if (svgEl !== null) {
            (_a = library == null ? void 0 : library.mutator) == null ? void 0 : _a.call(library, svgEl);
            this.svg = svgEl.outerHTML;
            this.emit("sd-load");
          } else {
            this.svg = "";
            this.emit("sd-error");
          }
        } else {
          this.svg = "";
          this.emit("sd-error");
        }
      } catch (e) {
        this.emit("sd-error");
      }
    } else if (this.svg.length > 0) {
      this.svg = "";
    }
  }
  render() {
    return html`${unsafeSVG(this.svg)}`;
  }
};
SdIcon.styles = [
  ...SolidElement.styles,
  css`:host{box-sizing:content-box!important;display:inline-block;height:1em;width:1em}svg{display:block;height:100%;width:100%}:host([color=primary]) svg{--tw-text-opacity:1;color:rgb(var(--sd-color-primary,0 53 142)/var(--tw-text-opacity,1))}:host([color=white]) svg{--tw-text-opacity:1;color:rgb(var(--sd-color-white,255 255 255)/var(--tw-text-opacity,1))}`
];
__decorateClass([
  state()
], SdIcon.prototype, "svg", 2);
__decorateClass([
  property({ reflect: true })
], SdIcon.prototype, "name", 2);
__decorateClass([
  property()
], SdIcon.prototype, "src", 2);
__decorateClass([
  property()
], SdIcon.prototype, "label", 2);
__decorateClass([
  property({ reflect: true })
], SdIcon.prototype, "library", 2);
__decorateClass([
  property({ reflect: true })
], SdIcon.prototype, "color", 2);
__decorateClass([
  watch("label")
], SdIcon.prototype, "handleLabelChange", 1);
__decorateClass([
  watch(["name", "src", "library"])
], SdIcon.prototype, "setIcon", 1);
SdIcon = __decorateClass([
  customElement("sd-4-0-5-icon")
], SdIcon);

export {
  SdIcon
};
