import '../icon/icon';
import { LocalizeController } from '../../utilities/localize';
import SolidElement from '../../internal/solid-element';
export default class SdAccordion extends SolidElement {
    localize: LocalizeController;
    accordion: HTMLDetailsElement;
    header: HTMLElement;
    body: HTMLElement;
    accordionObserver: MutationObserver;
    open: boolean;
    summary: string;
    firstUpdated(): void;
    disconnectedCallback(): void;
    protected handleSummaryClick(event: MouseEvent): void;
    protected handleSummaryKeyDown(event: KeyboardEvent): void;
    handleOpenChange(): Promise<void>;
    show(): Promise<void>;
    hide(): Promise<void>;
    render(): import("lit-html").TemplateResult;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-accordion': SdAccordion;
    }
}
