export declare class Wave {
    constructor(config: {
        phase: number;
        canvas: HTMLCanvasElement;
        amplitude: number;
        frequency: number;
        color: string;
        shift: number;
        damping: number;
    });
    canvas: HTMLCanvasElement;
    context: CanvasRenderingContext2D | null;
    color: string;
    origin: {
        x: number;
        y: number;
    };
    damping: number;
    lineWidth: number;
    shift: number;
    amplitude: number;
    phase: number;
    frequency: number;
    fixedEnd: boolean;
    fixedStart: boolean;
    gradient: boolean;
    outline: boolean;
    paused: boolean;
    playbackSpeed: number;
    map: (num: number, inMin: number, inMax: number, outMin: number, outMax: number) => number;
    damp: (end: number, x: number, size: number) => number;
    drawPoint(x: number, y: number, color: string): void;
    buildSine(wavelength: number, phase: number, color: string, amplitude: number, frequency: number): void;
    redraw(): void;
    setPlay(): void;
    setPause(): void;
    setPlaybackSpeed(playbackSpeed: number): void;
}
