import SolidElement from '../../internal/solid-element';
import type { TemplateResult } from 'lit';
type Breakpoints = 0 | 414 | 640;
export default class SdBrandshape extends SolidElement {
    containerElem: HTMLElement;
    variant: 'neutral-100' | 'primary' | 'white' | 'border-primary' | 'border-white' | 'image';
    shapes: ('top' | 'middle' | 'bottom')[];
    componentBreakpoint: Breakpoints;
    private resizeObserver;
    private getSvg;
    private largeSvg;
    private mediumSvg;
    private smallSvg;
    private setBreakpoint;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private renderTopBrandshape;
    private renderMiddleBrandshape;
    private renderBottomBrandshape;
    private renderWhitespaceFix;
    private renderStylizedVariant;
    private renderShapes;
    render(): TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-brandshape': SdBrandshape;
    }
}
export {};
