import SolidElement from '../../internal/solid-element';
import type { SVGTemplateResult } from 'lit';
export default class SdMapMarker extends SolidElement {
    variant: 'cluster' | 'main' | 'place';
    state: 'default' | 'hover' | 'active';
    animated: boolean;
    notInteractive: boolean;
    href: string;
    target: '_blank' | '_parent' | '_self' | '_top';
    private handleBlur;
    private handleFocus;
    private isLink;
    readonly marker: {
        [key in 'cluster' | 'main' | 'place']: SVGTemplateResult;
    };
    render(): import("lit-html").TemplateResult;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-map-marker': SdMapMarker;
    }
}
