import SolidElement from '../../internal/solid-element';
export default class SdNavigationItem extends SolidElement {
    private readonly hasSlotController;
    button: HTMLButtonElement | HTMLLinkElement | null;
    vertical: boolean;
    size: 'md' | 'lg' | 'sm';
    href: string;
    target: '_blank' | '_parent' | '_self' | '_top';
    download?: string;
    current: boolean;
    disabled: boolean;
    chevron: boolean;
    relaxed: boolean;
    divider: boolean;
    indented: boolean;
    open: boolean;
    separated: boolean;
    private get isButton();
    private get isLink();
    private get isAccordion();
    private handleClickButton;
    private handleClickSummary;
    private hideDetails;
    private showDetails;
    private get calculatePaddingX();
    private get tag();
    render(): import("lit-html").TemplateResult;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-navigation-item': SdNavigationItem;
    }
}
