import { FormControlController } from '../../internal/form';
import SdButtonGroup from '../button-group/button-group';
import SolidElement from '../../internal/solid-element';
import type { SolidFormControl } from '../../internal/solid-element';
export default class SdRadioGroup extends SolidElement implements SolidFormControl {
    static dependencies: {
        'sd-4-0-5-button-group': typeof SdButtonGroup;
    };
    protected readonly formControlController: FormControlController;
    private readonly hasSlotController;
    private customValidityMessage;
    private validationTimeout;
    defaultSlot: HTMLSlotElement;
    validationInput: HTMLInputElement;
    invalidMessage: HTMLDivElement;
    hasButtonGroup: boolean;
    defaultValue: string;
    showInvalidStyle: boolean;
    size: 'lg' | 'md' | 'sm';
    required: boolean;
    orientation: 'horizontal' | 'vertical';
    label: string;
    boldLabel: boolean;
    name: string;
    value: string;
    form: string;
    get validity(): ValidityState;
    get validationMessage(): string;
    connectedCallback(): void;
    firstUpdated(): void;
    private getAllRadios;
    private handleRadioClick;
    private handleKeyDown;
    focus(): void;
    private handleInvalid;
    private syncRadioElements;
    private syncRadios;
    private updateCheckedRadio;
    handleSizeChange(): void;
    handleInvalidChange(): void;
    handleValueChange(): void;
    checkValidity(): boolean;
    getForm(): HTMLFormElement | null;
    reportValidity(): boolean;
    setCustomValidity(message?: string): void;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-radio-group': SdRadioGroup;
    }
}
