import { type ReactiveController, type ReactiveControllerHost } from 'lit';
import type { SolidFormControl } from '../internal/solid-element';
import type SdButton from '../components/button/button';
export declare const formCollections: WeakMap<HTMLFormElement, Set<SolidFormControl>>;
export interface FormControlControllerOptions {
    form: (input: SolidFormControl) => HTMLFormElement | null;
    name: (input: SolidFormControl) => string;
    value: (input: SolidFormControl) => unknown;
    defaultValue: (input: SolidFormControl) => unknown;
    disabled: (input: SolidFormControl) => boolean;
    reportValidity: (input: SolidFormControl) => boolean;
    setValue: (input: SolidFormControl, value: unknown) => void;
    assumeInteractionOn: string[];
}
export declare class FormControlController implements ReactiveController {
    host: SolidFormControl & ReactiveControllerHost;
    form?: HTMLFormElement | null;
    options: FormControlControllerOptions;
    constructor(host: ReactiveControllerHost & SolidFormControl, options?: Partial<FormControlControllerOptions>);
    hostConnected(): void;
    hostDisconnected(): void;
    hostUpdated(): void;
    private attachForm;
    private detachForm;
    private handleFormData;
    private handleFormSubmit;
    private handleFormReset;
    private handleInteraction;
    fakeUserInteraction: () => void;
    private reportFormValidity;
    private setUserInteracted;
    private doAction;
    updateValidityStyle(): void;
    getForm(): HTMLFormElement | null;
    renderInvalidMessage(): import("lit-html").TemplateResult<1>;
    reset(invoker?: HTMLInputElement | SdButton): void;
    submit(invoker?: HTMLInputElement | SdButton): void;
    setValidity(isValid: boolean): void;
    updateValidity(): void;
    emitInvalidEvent(originalInvalidEvent?: Event): void;
}
export declare const validValidityState: ValidityState;
export declare const valueMissingValidityState: ValidityState;
export declare const customErrorValidityState: ValidityState;
