var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { customElement } from '../../internal/register-custom-element';
import { html } from 'lit';
import { query } from 'lit/decorators.js';
import SolidElement from '../../internal/solid-element';
import styles from './menu.styles';
let SdMenu = class SdMenu extends SolidElement {
    static { this.styles = [...SolidElement.styles, styles]; }
    connectedCallback() {
        super.connectedCallback();
        this.setAttribute('role', 'menu');
    }
    getAllItems() {
        return [...this.defaultSlot.assignedElements({ flatten: true })].filter((el) => {
            if (el.inert || !this.isMenuItem(el)) {
                return false;
            }
            return true;
        });
    }
    handleClick(event) {
        const target = event.target;
        const item = target.closest('sd-menu-item');
        if (!item || item.disabled || item.inert) {
            return;
        }
        if (item.type === 'checkbox') {
            item.checked = !item.checked;
        }
        this.emit('sd-select', { detail: { item } });
    }
    handleKeyDown(event) {
        if (event.key === 'Enter') {
            const item = this.getCurrentItem();
            event.preventDefault();
            item?.click();
        }
        if (event.key === ' ') {
            event.preventDefault();
        }
        if (['ArrowDown', 'ArrowUp', 'Home', 'End'].includes(event.key)) {
            const items = this.getAllItems();
            const activeItem = this.getCurrentItem();
            let index = activeItem ? items.indexOf(activeItem) : 0;
            if (items.length > 0) {
                event.preventDefault();
                if (event.key === 'ArrowDown') {
                    index++;
                }
                else if (event.key === 'ArrowUp') {
                    index--;
                }
                else if (event.key === 'Home') {
                    index = 0;
                }
                else if (event.key === 'End') {
                    index = items.length - 1;
                }
                if (index < 0) {
                    index = items.length - 1;
                }
                if (index > items.length - 1) {
                    index = 0;
                }
                this.setCurrentItem(items[index]);
                items[index].focus();
            }
        }
    }
    handleMouseDown(event) {
        const target = event.target;
        if (this.isMenuItem(target)) {
            this.setCurrentItem(target);
        }
    }
    handleSlotChange() {
        const items = this.getAllItems();
        if (items.length > 0) {
            this.setCurrentItem(items[0]);
        }
    }
    isMenuItem(item) {
        return (item.tagName.toLowerCase() === 'sd-menu-item' ||
            ['menuitem', 'menuitemcheckbox', 'menuitemradio'].includes(item.getAttribute('role') ?? ''));
    }
    getCurrentItem() {
        return this.getAllItems().find(i => i.getAttribute('tabindex') === '0');
    }
    setCurrentItem(item) {
        const items = this.getAllItems();
        items.forEach(i => {
            i.setAttribute('tabindex', i === item ? '0' : '-1');
        });
    }
    render() {
        return html `
      <slot
        @slotchange=${this.handleSlotChange}
        @click=${this.handleClick}
        @keydown=${this.handleKeyDown}
        @mousedown=${this.handleMouseDown}
      ></slot>
    `;
    }
};
__decorate([
    query('slot')
], SdMenu.prototype, "defaultSlot", void 0);
SdMenu = __decorate([
    customElement('sd-menu')
], SdMenu);
export default SdMenu;
