import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/scrollable/scrollable.ts
import { css, html } from "lit";
import { property, state } from "lit/decorators.js";
import cx from "classix";
var SdScrollable = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.localize = new LocalizeController(this);
    this.orientation = "horizontal";
    this.scrollbars = false;
    this.buttons = false;
    this.shadows = false;
    this.inset = false;
    this.step = 150;
    this.canScroll = {
      left: false,
      right: false,
      up: false,
      down: false
    };
    this.isScrollHorizontalEnabled = false;
    this.isScrollVerticalEnabled = false;
    this.isKeyboardNavigation = false;
    this.scrollContainer = null;
  }
  connectedCallback() {
    super.connectedCallback();
    this.updateScrollEnabledFlags();
    this.resizeObserver = new ResizeObserver(() => {
      this.updateScrollIndicatorVisibility();
    });
    this.updateComplete.then(() => {
      this.scrollContainer = this.renderRoot.querySelector(".scroll-container");
      if (this.scrollContainer) {
        this.resizeObserver.observe(this.scrollContainer);
      }
    });
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    if (this.scrollContainer) {
      this.resizeObserver.unobserve(this.scrollContainer);
    }
  }
  updated(changedProperties) {
    super.updated(changedProperties);
    if (changedProperties.has("orientation") || changedProperties.has("buttons") || changedProperties.has("shadows")) {
      this.updateScrollEnabledFlags();
      this.updateScrollIndicatorVisibility();
    }
  }
  updateScrollEnabledFlags() {
    const dir = this.orientation;
    this.isScrollHorizontalEnabled = dir === "horizontal" || dir === "auto";
    this.isScrollVerticalEnabled = dir === "vertical" || dir === "auto";
  }
  get container() {
    return this.renderRoot.querySelector(".scroll-container");
  }
  updateScrollIndicatorVisibility() {
    const container = this.container;
    if (!container) {
      return;
    }
    const canScrollLeft = this.isScrollHorizontalEnabled && container.scrollLeft > 0;
    const canScrollRight = this.isScrollHorizontalEnabled && container.scrollLeft + container.clientWidth < container.scrollWidth - 1;
    const canScrollUp = this.isScrollVerticalEnabled && container.scrollTop > 0;
    const canScrollDown = this.isScrollVerticalEnabled && container.scrollTop + container.clientHeight < container.scrollHeight - 1;
    const startButton = this.renderRoot.querySelector('[part="button-start"]');
    const endButton = this.renderRoot.querySelector('[part="button-end"]');
    this.canScroll = {
      left: this.isKeyboardNavigation ? this.isScrollHorizontalEnabled : canScrollLeft,
      right: this.isKeyboardNavigation ? this.isScrollHorizontalEnabled : canScrollRight,
      up: this.isKeyboardNavigation ? this.isScrollVerticalEnabled : canScrollUp,
      down: this.isKeyboardNavigation ? this.isScrollVerticalEnabled : canScrollDown
    };
    const startEventTriggered = canScrollLeft || canScrollUp;
    const endEventTriggered = canScrollRight || canScrollDown;
    if (startEventTriggered) {
      this.dispatchEvent(new CustomEvent("start"));
    }
    if (endEventTriggered) {
      this.dispatchEvent(new CustomEvent("end"));
    }
    if (this.isKeyboardNavigation) {
      if (startButton) {
        startButton.hidden = !startEventTriggered;
      }
      if (startButton && startEventTriggered && !(canScrollDown || canScrollRight)) {
        startButton.focus();
      }
      if (endButton) {
        endButton.hidden = !endEventTriggered;
      }
      if (endButton && endEventTriggered && !(canScrollUp || canScrollLeft)) {
        endButton.focus();
      }
    }
  }
  handleScroll(direction, event) {
    var _a;
    const scrollAmount = direction === "left" || direction === "up" ? -this.step : this.step;
    const scrollDirection = direction === "left" || direction === "right" ? "left" : "top";
    this.isKeyboardNavigation = (event == null ? void 0 : event.pointerType) !== "mouse";
    const scrollOptions = {
      behavior: "smooth"
    };
    scrollOptions[scrollDirection] = scrollAmount;
    (_a = this.scrollContainer) == null ? void 0 : _a.scrollBy(scrollOptions);
    const eventName = `button-${direction}`;
    this.dispatchEvent(new CustomEvent(eventName, { bubbles: true, composed: true }));
  }
  render() {
    const scrollButtonClasses = "relative p-0 border-0 bg-transparent cursor-pointer w-5 h-5 flex items-center justify-center sd-interactive rounded-md flex text-lg";
    const scrollShadowClasses = "scroll-shadow absolute z-10 pointer-events-none";
    return html`<div part="base" class="${cx(
      "scroll-container flex overflow-hidden flex-1",
      this.orientation === "horizontal" && "scroll-horizontal flex-row whitespace-nowrap items-center overflow-x-scroll overflow-y-hidden",
      this.orientation === "vertical" && "scroll-vertical justify-items-center overflow-y-scroll overflow-x-hidden",
      this.orientation === "auto" && "scroll-auto overflow-auto",
      this.scrollbars ? "show-scrollbars" : "hide-scrollbars",
      this.inset ? "p-4" : ""
    )}" @scroll="${this.updateScrollIndicatorVisibility}" tabindex="0"><div part="scroll-content" class="flex-1"><slot></slot></div></div>${this.buttons ? html`${this.isScrollHorizontalEnabled ? html`${this.canScroll.left ? html`<div part="button-left" class="absolute z-10 flex items-center justify-center top-0 left-0 h-full w-8"><button part="button-start" class="${cx(scrollButtonClasses)}" @click="${(e) => this.handleScroll("left", e)}"><slot name="icon-start"><sd-icon library="system" name="chevron-up" class="rotate-[-90deg]" label="${this.localize.term("scrollToStart")}"></sd-icon></slot></button></div>` : null} ${this.canScroll.right ? html`<div part="button-right" class="absolute z-10 flex items-center justify-center top-0 right-0 h-full w-8"><button part="button-end" class="${cx(scrollButtonClasses)}" @click="${(e) => this.handleScroll("right", e)}"><slot name="icon-end"><sd-icon library="system" name="chevron-down" class="rotate-[-90deg]" label="${this.localize.term("scrollToEnd")}"></sd-icon></slot></button></div>` : null}` : null} ${this.isScrollVerticalEnabled ? html`${this.canScroll.up ? html`<div part="button-top" class="absolute z-10 flex items-center justify-center top-0 left-0 w-full h-8"><button part="button-start" class="${cx(scrollButtonClasses)}" @click="${(e) => this.handleScroll("up", e)}"><slot name="icon-start"><sd-icon library="system" name="chevron-up" label="${this.localize.term("scrollToStart")}"></sd-icon></slot></button></div>` : null} ${this.canScroll.down ? html`<div part="button-bottom" class="absolute z-10 flex items-center justify-center bottom-0 left-0 w-full h-8"><button part="button-end" class="${cx(scrollButtonClasses)}" @click="${(e) => this.handleScroll("down", e)}"><slot name="icon-end"><sd-icon library="system" name="chevron-down" label="${this.localize.term("scrollToEnd")}"></sd-icon></slot></button></div>` : null}` : null}` : null} ${this.shadows ? html`${this.isScrollHorizontalEnabled ? html`${this.canScroll.left ? html`<div part="shadow-left" class="${scrollShadowClasses} left top-0 left-0 w-[6px] h-full"></div>` : null} ${this.canScroll.right ? html`<div part="shadow-right" class="${scrollShadowClasses} right top-0 right-0 w-[6px] h-full"></div>` : null}` : null} ${this.isScrollVerticalEnabled ? html`${this.canScroll.up ? html`<div part="shadow-top" class="${scrollShadowClasses} top top-0 left-0 w-full h-[6px]"></div>` : null} ${this.canScroll.down ? html`<div part="shadow-bottom" class="${scrollShadowClasses} bottom bottom-0 left-0 w-full h-[6px]"></div>` : null}` : null}` : null}`;
  }
};
SdScrollable.styles = [
  ...SolidElement.styles,
  css`:host{--gradient-color:hsla(0,0%,100%,0);--gradient:var(--gradient-color) 0%,#fff 80%,#fff 100%;display:flex;overflow:hidden;position:relative}.hide-scrollbars{scrollbar-width:none;-ms-overflow-style:none}.hide-scrollbars::-webkit-scrollbar{display:none}.scroll-container::-webkit-scrollbar-thumb{background-color:transparent}.scroll-container:hover::-webkit-scrollbar-thumb{background:var(--background-neutral-400,#c3c3c3);border-radius:var(--sd-border-radius-sm,.125rem)}.scroll-container::-webkit-scrollbar{height:var(--sd-spacing-1,.25rem);width:var(--sd-spacing-1,.25rem)}.scroll-auto{overflow:auto}[part=button-left]{background:linear-gradient(270deg,var(--gradient))}[part=button-right]{background:linear-gradient(90deg,var(--gradient))}[part=button-top]{background:linear-gradient(0deg,var(--gradient))}[part=button-bottom]{background:linear-gradient(180deg,var(--gradient))}[part=shadow-left]{background:linear-gradient(270deg,hsla(0,0%,9%,0) 50%,hsla(0,0%,9%,.4))}[part=shadow-right]{background:linear-gradient(90deg,hsla(0,0%,9%,0) 50%,hsla(0,0%,9%,.4))}[part=shadow-top]{background:linear-gradient(0deg,hsla(0,0%,9%,0) 50%,hsla(0,0%,9%,.4))}[part=shadow-bottom]{background:linear-gradient(180deg,hsla(0,0%,9%,0) 50%,hsla(0,0%,9%,.4))}.sd-icon--top{align-self:flex-start}.sd-icon--down{align-self:flex-end}`
];
__decorateClass([
  property({ type: String, reflect: true })
], SdScrollable.prototype, "orientation", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdScrollable.prototype, "scrollbars", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdScrollable.prototype, "buttons", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdScrollable.prototype, "shadows", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdScrollable.prototype, "inset", 2);
__decorateClass([
  property({ type: Number, reflect: true })
], SdScrollable.prototype, "step", 2);
__decorateClass([
  state()
], SdScrollable.prototype, "canScroll", 2);
__decorateClass([
  state()
], SdScrollable.prototype, "isScrollHorizontalEnabled", 2);
__decorateClass([
  state()
], SdScrollable.prototype, "isScrollVerticalEnabled", 2);
__decorateClass([
  state()
], SdScrollable.prototype, "isKeyboardNavigation", 2);
SdScrollable = __decorateClass([
  customElement("sd-scrollable")
], SdScrollable);

export {
  SdScrollable
};
