import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/video/video.ts
import { css, html } from "lit";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdVideo = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.playing = false;
    this.isBelowBreakpoint = false;
    this.hasSlotController = new HasSlotController(this, "[default]", "play-icon", "poster");
  }
  /** Getter for optional poster slot. */
  get poster() {
    const slot = this.shadowRoot.querySelector("slot[name=poster]");
    if ((slot == null ? void 0 : slot.assignedElements().length) > 0) {
      return slot.assignedElements()[0];
    }
    return null;
  }
  get video() {
    return this.querySelector("video");
  }
  /** Fade out poster after initial play. */
  fadeoutPoster() {
    if (this.poster instanceof HTMLImageElement) {
      this.poster.style.opacity = "0";
    }
  }
  /** Hide poster after initial play & fadeout. */
  hidePoster() {
    if (this.poster instanceof HTMLImageElement) {
      this.poster.style.display = "none";
    }
  }
  setVideoInert(inert) {
    var _a, _b;
    if (inert) {
      (_a = this.video) == null ? void 0 : _a.setAttribute("inert", "");
    } else {
      (_b = this.video) == null ? void 0 : _b.removeAttribute("inert");
    }
  }
  /** Utility function to group play behaviors. */
  play() {
    var _a;
    this.emit("sd-play");
    this.playing = true;
    (_a = this.video) == null ? void 0 : _a.play();
    this.fadeoutPoster();
    this.setVideoInert(false);
  }
  /** Restrict keydown control to enter and space bar to mimic the native video tag behavior. If a KeyboardEvent is used, refocus on the native video element to give the user seamless keyboard control. */
  handleKeydown(e) {
    if (e instanceof KeyboardEvent && (e.key === "Enter" || e.key === " ")) {
      this.play();
      setTimeout(() => {
        var _a;
        (_a = this.video) == null ? void 0 : _a.focus();
      });
    }
  }
  /** Resize the play-button-bg when passing host element width breakpoint 414px. */
  handleButtonResize() {
    if (this.hostEl.clientWidth <= 414 && !this.isBelowBreakpoint) {
      this.isBelowBreakpoint = true;
    }
    if (this.hostEl.clientWidth > 414 && this.isBelowBreakpoint) {
      this.isBelowBreakpoint = false;
    }
  }
  connectedCallback() {
    super.connectedCallback();
    this.setVideoInert(true);
    this.resizeObserver = new ResizeObserver(() => this.handleButtonResize());
    this.updateComplete.then(() => {
      this.resizeObserver.observe(this.hostEl);
    });
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    this.resizeObserver.unobserve(this.hostEl);
  }
  render() {
    return html`<div part="base" aria-label="Video Player" class="cursor-pointer"><button part="play-button" aria-label="Play video" tabindex="0" @click="${this.play}" @keydown="${this.handleKeydown}" class="${cx(
      this.playing && "pointer-events-none",
      "group w-full h-full absolute top-0 left-0 z-30 text-primary hover:text-primary-500 sd-interactive sd-interactive--reset focus-visible:focus-outline"
    )}"><div part="play-button-bg" class="${cx(
      this.playing ? "opacity-0" : "opacity-100",
      this.isBelowBreakpoint ? "w-[48px] h-[48px]" : "w-[96px] h-[96px]",
      "absolute left-1/2 top-1/2 -translate-x-1/2 -translate-y-1/2 p-4 bg-white bg-opacity-75 rounded-full play-pause-transition outline-2 outline-offset-2 group-focus-visible:outline"
    )}"><slot name="play-icon" part="play-icon" class="${cx(this.isBelowBreakpoint ? "text-[2rem]" : "text-[4rem]")}"><sd-icon id="default-play-icon" library="system" name="start"></sd-icon></slot></div></button> ${this.hasSlotController.test("poster") ? html`<slot name="poster" role="presentation" @transitionend="${this.hidePoster}"></slot>` : null}<slot></slot></div>`;
  }
};
SdVideo.styles = [
  ...SolidElement.styles,
  css`:host{display:inline-block;overflow:hidden;position:relative}.play-pause-transition,::slotted([slot=poster]){transition-duration:.3s;transition-property:opacity;transition-timing-function:cubic-bezier(.4,0,.2,1)}::slotted([slot=poster]){left:var(--sd-spacing-0,0);position:absolute;top:var(--sd-spacing-0,0);width:100%;z-index:10}#default-play-icon,::slotted([slot=play-icon]){left:50%;position:absolute;top:50%;--tw-translate-x:-50%!important;--tw-translate-y:-50%!important;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}`
];
__decorateClass([
  query("[part=base]")
], SdVideo.prototype, "hostEl", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdVideo.prototype, "playing", 2);
__decorateClass([
  property({ type: Boolean })
], SdVideo.prototype, "isBelowBreakpoint", 2);
SdVideo = __decorateClass([
  customElement("sd-video")
], SdVideo);

export {
  SdVideo
};
