import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/navigation-item/navigation-item.ts
import { css } from "lit";
import { html, literal } from "lit/static-html.js";
import { ifDefined } from "lit/directives/if-defined.js";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdNavigationItem = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.hasSlotController = new HasSlotController(this, "[default]", "description", "children");
    this.vertical = false;
    this.size = "md";
    this.current = false;
    this.disabled = false;
    this.chevron = false;
    this.relaxed = false;
    this.divider = false;
    this.indented = false;
    this.open = false;
    this.separated = false;
  }
  get isButton() {
    return !this.href && !this.hasSlotController.test("children");
  }
  get isLink() {
    return !!this.href;
  }
  get isAccordion() {
    return !this.href && this.hasSlotController.test("children");
  }
  handleClickButton(event) {
    if (this.disabled) {
      event.preventDefault();
      event.stopPropagation();
    }
  }
  handleClickSummary(event) {
    event.preventDefault();
    event.stopPropagation();
    if (!this.disabled) {
      if (this.open) {
        this.hideDetails();
      } else {
        this.showDetails();
      }
    }
  }
  hideDetails() {
    this.open = false;
    this.emit("sd-hide", { cancelable: true });
  }
  showDetails() {
    this.open = true;
    this.emit("sd-show", { cancelable: true });
  }
  get calculatePaddingX() {
    if (this.relaxed && this.indented) return "pl-8 pr-4";
    if (this.relaxed) return "px-4";
    if (this.indented) return "pl-4";
    return "";
  }
  get tag() {
    if (this.isAccordion && !this.isLink) {
      return literal`summary`;
    }
    if (this.separated) {
      return literal`div`;
    }
    if (this.isLink) {
      return literal`a`;
    }
    return literal`button`;
  }
  render() {
    const tag = this.tag;
    const isLink = this.isLink;
    const isButton = this.isButton;
    const isAccordion = this.isAccordion;
    const slots = {
      label: this.hasSlotController.test("[default]"),
      main: this.hasSlotController.test("main"),
      description: this.hasSlotController.test("description"),
      children: this.hasSlotController.test("children")
    };
    const horizontalPaddingBottom = this.vertical ? "pb-3" : "pb-2";
    const root = html`<${tag} part="base" class="${cx(
      "cursor-pointer relative focus-visible:focus-outline",
      { md: "text-base", lg: "text-lg", sm: "text-[14px]" }[this.size],
      this.disabled ? "text-neutral-500 pointer-events-none" : "text-primary",
      isAccordion ? "flex flex-col" : "inline-block w-full",
      this.divider && this.vertical && "mt-0.25",
      !this.vertical && "inline-flex items-center",
      !this.separated && "hover:bg-neutral-200 group transition-all min-h-[48px] px-4"
    )}" aria-controls="${ifDefined(isAccordion ? "navigation-item-details" : void 0)}" aria-current="${ifDefined(this.current ? "page" : void 0)}" aria-disabled="${this.disabled}" ?disabled="${ifDefined(isButton ? this.disabled : void 0)}" href="${ifDefined(isLink ? this.href : void 0)}" target="${ifDefined(isLink ? this.target : void 0)}" download="${ifDefined(isLink ? this.download : void 0)}" rel="${ifDefined(isLink && this.target ? "noreferrer noopener" : void 0)}" role="${isLink ? "link" : "button"}" tabindex="${this.disabled || this.separated ? "-1" : "0"}" @click="${this.separated ? void 0 : isAccordion ? this.handleClickSummary : isButton ? this.handleClickButton : void 0}"><div part="current-indicator" class="${cx(
      "absolute left-0 pointer-events-none transition-all duration-150",
      this.vertical ? "w-1 h-[calc(100%-16px)] top-2 group-hover:h-full group-hover:top-0" : "h-1 w-full bottom-0",
      this.current ? "bg-accent" : "bg-transparent",
      this.disabled && "bg-neutral-500"
    )}"></div><span part="content-area" class="${cx(
      "relative pt-3 inline-flex justify-between items-center",
      isAccordion ? "grow" : "w-full",
      slots["description"] || this.separated ? "pb-1" : horizontalPaddingBottom,
      this.calculatePaddingX
    )}">${this.divider && this.vertical ? html`<sd-divider part="divider" class="${cx("w-full transition-all absolute -top-0.25 left-0", this.calculatePaddingX)}"></sd-divider>` : ""} <span part="content-container" class="inline-flex items-center flex-auto">${this.separated ? html`<a class="${cx(
      "mr-4 w-full inline-flex items-center pl-4 cursor-pointer relative focus-visible:focus-outline hover:bg-neutral-200 group transition-all min-h-[48px]",
      !slots["description"] && "py-4"
    )}" href="${ifDefined(isLink ? this.href : void 0)}" target="${ifDefined(isLink ? this.target : void 0)}" download="${ifDefined(isLink ? this.download : void 0)}"><slot part="content" class="inline"></slot></a>` : html`<slot part="content" class="inline"></slot>`} </span>${(this.chevron || slots["children"]) && this.vertical ? this.separated ? html`<button type="button" title="toggle-details" class="sd-interactive sd-interactive--reset" @click="${this.handleClickSummary}"><sd-icon name="chevron-down" part="chevron" library="system" color="currentColor" class="${cx(
      "mr-4 h-6 w-6 transition-all",
      isAccordion || this.separated ? this.open ? "rotate-180" : "rotate-0" : "rotate-[270deg]"
    )}"></sd-icon></button>` : html`<sd-icon name="chevron-down" part="chevron" library="system" color="currentColor" class="${cx(
      "h-6 w-6 ml-2 transition-all",
      isAccordion ? this.open ? "rotate-180" : "rotate-0" : "rotate-[270deg]"
    )}"></sd-icon>` : ""} </span>${slots["description"] && this.vertical ? html`<slot name="description" part="description" class="${cx(
      "inline-block text-sm text-left text-black",
      isAccordion || this.separated ? "grow" : "w-full",
      this.separated ? "px-4" : this.calculatePaddingX,
      horizontalPaddingBottom
    )}"></slot>` : ""}</${tag}>`;
    if (isAccordion) {
      return html`<details aria-expanded="${this.open}" part="details" id="navigation-item-details" ?open="${this.open}" class="relative flex">${root}<slot name="children"></slot></details>`;
    }
    if (this.separated) {
      return html`<div part="details" id="navigation-item-details" class="relative flex flex-col">${root}${this.open ? html`<slot name="children"></slot>` : ""}</div>`;
    }
    return html`${root}`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdNavigationItem.styles = [
  ...SolidElement.styles,
  css`:host{box-sizing:border-box;display:inline-block;position:relative}:host([vertical]){display:block}details summary::-webkit-details-marker{display:none}`
];
__decorateClass([
  query('a[part="base"], button[part="base"]')
], SdNavigationItem.prototype, "button", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNavigationItem.prototype, "vertical", 2);
__decorateClass([
  property({ reflect: true })
], SdNavigationItem.prototype, "size", 2);
__decorateClass([
  property({ reflect: true })
], SdNavigationItem.prototype, "href", 2);
__decorateClass([
  property()
], SdNavigationItem.prototype, "target", 2);
__decorateClass([
  property()
], SdNavigationItem.prototype, "download", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNavigationItem.prototype, "current", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNavigationItem.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNavigationItem.prototype, "chevron", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNavigationItem.prototype, "relaxed", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNavigationItem.prototype, "divider", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNavigationItem.prototype, "indented", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNavigationItem.prototype, "open", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNavigationItem.prototype, "separated", 2);
SdNavigationItem = __decorateClass([
  customElement("sd-navigation-item")
], SdNavigationItem);

export {
  SdNavigationItem
};
