import {
  getAnimation,
  setDefaultAnimation
} from "./chunk.N4LHE3QK.js";
import {
  animateTo,
  parseDuration,
  stopAnimations
} from "./chunk.EY4JPJJQ.js";
import {
  waitForEvent
} from "./chunk.B4BZKR24.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/tooltip/tooltip.ts
import { css, html } from "lit";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdTooltip = class extends SolidElement {
  constructor() {
    super(...arguments);
    // Flag to handle the case where a click event is triggered after a focus event
    this.isFocusTriggered = false;
    this.localize = new LocalizeController(this);
    this.size = "lg";
    this.content = "";
    this.placement = "top";
    this.disabled = false;
    this.open = false;
    this.trigger = "click focus";
    this.hoist = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.handleBlur = this.handleBlur.bind(this);
    this.handleClick = this.handleClick.bind(this);
    this.handleFocus = this.handleFocus.bind(this);
    this.handleKeyDown = this.handleKeyDown.bind(this);
    this.handleMouseOver = this.handleMouseOver.bind(this);
    this.handleMouseOut = this.handleMouseOut.bind(this);
    this.updateComplete.then(() => {
      this.addEventListener("blur", this.handleBlur, true);
      this.addEventListener("focus", this.handleFocus, true);
      this.addEventListener("click", this.handleClick);
      this.addEventListener("keydown", this.handleKeyDown);
      this.addEventListener("mouseover", this.handleMouseOver);
      this.addEventListener("mouseout", this.handleMouseOut);
    });
  }
  firstUpdated() {
    this.body.hidden = !this.open;
    if (this.open) {
      this.popup.active = true;
      this.popup.reposition();
    }
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    this.removeEventListener("blur", this.handleBlur, true);
    this.removeEventListener("focus", this.handleFocus, true);
    this.removeEventListener("click", this.handleClick);
    this.removeEventListener("keydown", this.handleKeyDown);
    this.removeEventListener("mouseover", this.handleMouseOver);
    this.removeEventListener("mouseout", this.handleMouseOut);
  }
  handleBlur() {
    if (this.hasTrigger("focus")) {
      this.hide();
    }
  }
  handleClick() {
    if (this.hasTrigger("click")) {
      if (this.isFocusTriggered) {
        this.isFocusTriggered = false;
        return;
      }
      if (this.open) {
        this.hide();
      } else {
        this.show();
      }
    }
  }
  handleFocus() {
    if (this.hasTrigger("focus")) {
      this.isFocusTriggered = true;
      this.show();
    }
  }
  handleKeyDown(event) {
    if (this.open && event.key === "Escape") {
      event.stopPropagation();
      this.hide();
    }
  }
  handleMouseOver() {
    if (this.hasTrigger("hover")) {
      const delay = parseDuration(getComputedStyle(this).getPropertyValue("--show-delay"));
      clearTimeout(this.hoverTimeout);
      this.hoverTimeout = window.setTimeout(() => this.show(), delay);
    }
  }
  handleMouseOut() {
    if (this.hasTrigger("hover")) {
      const delay = parseDuration(getComputedStyle(this).getPropertyValue("--hide-delay"));
      clearTimeout(this.hoverTimeout);
      this.hoverTimeout = window.setTimeout(() => this.hide(), delay);
    }
  }
  hasTrigger(triggerType) {
    const triggers = this.trigger.split(" ");
    return triggers.includes(triggerType);
  }
  async handleOpenChange() {
    if (this.open) {
      if (this.disabled) {
        return;
      }
      this.emit("sd-show");
      await stopAnimations(this.body);
      this.body.hidden = false;
      this.popup.active = true;
      const { keyframes, options } = getAnimation(this, "tooltip.show", { dir: this.localize.dir() });
      await animateTo(this.popup.popup, keyframes, options);
      this.emit("sd-after-show");
    } else {
      this.emit("sd-hide");
      await stopAnimations(this.body);
      const { keyframes, options } = getAnimation(this, "tooltip.hide", { dir: this.localize.dir() });
      await animateTo(this.popup.popup, keyframes, options);
      this.popup.active = false;
      this.body.hidden = true;
      this.emit("sd-after-hide");
    }
  }
  async handleOptionsChange() {
    if (this.hasUpdated) {
      await this.updateComplete;
      this.popup.reposition();
    }
  }
  handleDisabledChange() {
    if (this.disabled && this.open) {
      this.hide();
    }
  }
  /** Shows the tooltip. */
  async show() {
    if (this.open) {
      return void 0;
    }
    this.open = true;
    return waitForEvent(this, "sd-after-show");
  }
  /** Hides the tooltip */
  async hide() {
    if (!this.open) {
      return void 0;
    }
    this.open = false;
    return waitForEvent(this, "sd-after-hide");
  }
  render() {
    const isStart = this.placement.endsWith("-start");
    const isEnd = this.placement.endsWith("-end");
    return html`<sd-popup part="base" exportparts="
          popup:base__popup,
          arrow:base__arrow
        " class="${cx(this.open && "tooltip--open")}" placement="${this.placement}" distance="10" skidding="${{ start: 2, end: -2, default: 0 }[isStart ? "start" : isEnd ? "end" : "default"] * (this.size === "sm" ? -1 : 1)}" strategy="${this.hoist ? "fixed" : "absolute"}" flip shift arrow auto-size="vertical" arrow-padding="0"><slot slot="anchor" aria-describedby="tooltip" class="${cx(this.size === "lg" ? "text-xl" : "text-base")}"><button class="flex sd-interactive rounded-full"><sd-icon library="system" name="info-circle" class="${cx(this.disabled && "sd-interactive--disabled")}"></sd-icon></button></slot><slot name="content" part="body" id="tooltip" class="bg-primary text-white py-3 px-4 block rounded-none text-sm text-left" role="tooltip" aria-label="Tooltip" aria-live="${this.open ? "polite" : "off"}">${this.content}</slot></sd-popup>`;
  }
};
SdTooltip.styles = [
  ...SolidElement.styles,
  css`:host{--hide-delay:0ms;--show-delay:150ms;display:contents}sd-popup{--arrow-color:rgb(var(--sd-color-primary,0 53 142)/1);--arrow-size:10px}sd-popup::part(popup){pointer-events:none;z-index:10;--tw-shadow:var(--sd-shadow,0px 1px 3px 0px rgba(81,81,81,.75));--tw-shadow-colored:0px 1px 3px 0px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow,0 0 #0000),var(--tw-ring-shadow,0 0 #0000),var(--tw-shadow)}sd-popup::part(arrow){--tw-shadow:var(--sd-shadow,0px 1px 3px 0px rgba(81,81,81,.75));--tw-shadow-colored:0px 1px 3px 0px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow,0 0 #0000),var(--tw-ring-shadow,0 0 #0000),var(--tw-shadow)}sd-popup[placement^=top]::part(popup){transform-origin:bottom}sd-popup[placement^=bottom]::part(popup){transform-origin:top}#tooltip{max-width:var(--max-width)}::slotted([slot=content]){max-height:var(--auto-size-available-height)!important;max-width:var(--auto-size-available-width)!important;overflow:auto}`
];
__decorateClass([
  query("slot:not([name])")
], SdTooltip.prototype, "defaultSlot", 2);
__decorateClass([
  query("#tooltip")
], SdTooltip.prototype, "body", 2);
__decorateClass([
  query("sd-popup")
], SdTooltip.prototype, "popup", 2);
__decorateClass([
  property()
], SdTooltip.prototype, "size", 2);
__decorateClass([
  property()
], SdTooltip.prototype, "content", 2);
__decorateClass([
  property({ reflect: true })
], SdTooltip.prototype, "placement", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTooltip.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTooltip.prototype, "open", 2);
__decorateClass([
  property()
], SdTooltip.prototype, "trigger", 2);
__decorateClass([
  property({ type: Boolean })
], SdTooltip.prototype, "hoist", 2);
__decorateClass([
  watch("open", { waitUntilFirstUpdate: true })
], SdTooltip.prototype, "handleOpenChange", 1);
__decorateClass([
  watch(["content", "hoist", "placement"])
], SdTooltip.prototype, "handleOptionsChange", 1);
__decorateClass([
  watch("disabled")
], SdTooltip.prototype, "handleDisabledChange", 1);
SdTooltip = __decorateClass([
  customElement("sd-tooltip")
], SdTooltip);
setDefaultAnimation("tooltip.show", {
  keyframes: [
    { opacity: 0, scale: 0.8 },
    { opacity: 1, scale: 1 }
  ],
  options: { duration: 150, easing: "ease" }
});
setDefaultAnimation("tooltip.hide", {
  keyframes: [
    { opacity: 1, scale: 1 },
    { opacity: 0, scale: 0.8 }
  ],
  options: { duration: 150, easing: "ease" }
});

export {
  SdTooltip
};
