import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/tab-panel/tab-panel.ts
import { css, html } from "lit";
import { property } from "lit/decorators.js";
import cx from "classix";
var id = 0;
var SdTabPanel = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.attrId = ++id;
    this.componentId = `sd-tab-panel-${this.attrId}`;
    this.name = "";
    this.active = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.id = this.id.length > 0 ? this.id : this.componentId;
    this.setAttribute("role", "tabpanel");
  }
  handleActiveChange() {
    this.setAttribute("aria-hidden", this.active ? "false" : "true");
  }
  render() {
    return html`<slot part="base" class="${cx("block", this.active && "tab-panel--active")}"></slot>`;
  }
};
SdTabPanel.styles = [
  ...SolidElement.styles,
  css`:host{--padding:0;display:none}:host([active]){display:block}::part(base){padding:var(--padding)}`
];
__decorateClass([
  property({ reflect: true })
], SdTabPanel.prototype, "name", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTabPanel.prototype, "active", 2);
__decorateClass([
  watch("active")
], SdTabPanel.prototype, "handleActiveChange", 1);
SdTabPanel = __decorateClass([
  customElement("sd-tab-panel")
], SdTabPanel);

export {
  SdTabPanel
};
