import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/teaser-media/teaser-media.ts
import { css, html } from "lit";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdTeaserMedia = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.variant = "white";
    this.hasSlotController = new HasSlotController(
      this,
      "[default]",
      "media",
      "meta",
      "headline",
      "expandable"
    );
  }
  render() {
    const slots = {
      "teaser-has-default": this.hasSlotController.test("[default]"),
      "teaser-has-media": this.hasSlotController.test("media"),
      "teaser-has-meta": this.hasSlotController.test("meta"),
      "teaser-has-headline": this.hasSlotController.test("headline"),
      "teaser-has-expandable": this.hasSlotController.test("expandable")
    };
    return html`<div class="relative flex flex-col group" part="base"><div class="${cx("mb-4", !slots["teaser-has-media"] && "hidden")}" part="media"><slot name="media"></slot></div><div class="absolute flex flex-col justify-end h-full w-full pb-4"><div class="${cx(
      "flex-1",
      this.variant === "gradient-light" && "bg-gradient-to-t from-white/[.8] to-60%",
      this.variant === "gradient-dark" && "bg-gradient-to-t from-primary-800/[.6] to-60%"
    )}"></div><div class="${cx(
      {
        white: "bg-white/[.8] group-hover:bg-white/90",
        "neutral-100": "bg-neutral-100/[.8] group-hover:bg-neutral-100/90",
        primary: "bg-primary/[.8] text-white group-hover:bg-primary/90",
        "primary-100": "bg-primary-100/[.8] group-hover:bg-primary-100/90",
        "gradient-light": "bg-gradient-to-t from-white/90 to-white/[.8]",
        "gradient-dark": "bg-gradient-to-t from-primary-800/75 to-primary-800/[.6]  text-white"
      }[this.variant]
    )}"><div class="flex-col text-left p-4" part="content"><div part="meta" class="${cx("gap-2 mb-4", !slots["teaser-has-meta"] && "hidden")}"><slot name="meta"></slot></div><div part="headline" class="text-lg font-bold m-0"><slot name="headline">Always insert one semantically correct heading element here (e. g. &lt;h2>)</slot></div><div class="${cx(
      "hidden",
      slots["teaser-has-expandable"] && "h-[0px] invisible opacity-0 md:[transition:_height_0.2s_linear,opacity_0.1s_linear_0.1s] md:block md:group-hover:h-auto md:group-hover:my-4 md:group-hover:opacity-[100%] md:group-hover:visible"
    )}" part="expandable" aria-hidden="true"><slot name="expandable"></slot></div><div part="main" class="${cx(!slots["teaser-has-default"] && "hidden")}"><slot></slot></div></div></div></div></div>`;
  }
};
SdTeaserMedia.styles = [
  ...SolidElement.styles,
  css`:host{display:block}::slotted(*){margin:var(--sd-spacing-0,0)}::slotted([slot=headline]){font-size:var(--sd-font-size-lg,1.25rem)!important;font-weight:700;margin:var(--sd-spacing-0,0)!important}`
];
__decorateClass([
  property({ reflect: true })
], SdTeaserMedia.prototype, "variant", 2);
__decorateClass([
  query('[part="base"]')
], SdTeaserMedia.prototype, "teaserMedia", 2);
SdTeaserMedia = __decorateClass([
  customElement("sd-teaser-media")
], SdTeaserMedia);

export {
  SdTeaserMedia
};
