// src/utilities/autocomplete-config.ts
function setupAutocomplete(selector, { setValueOnSelection, scrollSelectionIntoView } = {
  setValueOnSelection: true,
  scrollSelectionIntoView: true
}) {
  const sdInput = !selector ? document.querySelector("#autoComplete") : typeof selector === "string" ? document.querySelector(selector) : selector;
  const input = sdInput.shadowRoot.querySelector("input");
  const css = (string) => string[0];
  input.addEventListener("init", () => {
    var _a, _b;
    const ul = (_a = sdInput.shadowRoot) == null ? void 0 : _a.querySelector("ul");
    ul == null ? void 0 : ul.setAttribute("part", "listbox");
    const popup = document.createElement("sd-popup");
    popup.appendChild(ul);
    (_b = sdInput.shadowRoot) == null ? void 0 : _b.appendChild(popup);
    popup == null ? void 0 : popup.setAttribute("exportparts", "popup__content");
    if (popup) {
      popup.active = false;
      popup.autoSize = "vertical";
      popup.autoSizePadding = 16;
      popup.placement = "bottom-start";
      popup.anchor = sdInput;
      popup.sync = "width";
    }
    const styles = css`sd-popup::part(popup){border-bottom-left-radius:var(--sd-border-radius-default,.25rem);border-bottom-right-radius:var(--sd-border-radius-default,.25rem);border-width:0 2px 2px;overflow-y:scroll;z-index:var(--sd-z-index-dropdown,900);--tw-border-opacity:1;border-color:rgb(var(--sd-color-primary,0 53 142)/var(--tw-border-opacity,1));--tw-bg-opacity:1;background-color:rgb(var(--sd-color-white,255 255 255)/var(--tw-bg-opacity,1));padding:var(--sd-spacing-3,.75rem) var(--sd-spacing-2,.5rem);--tw-shadow:var(--sd-shadow,0px 1px 3px 0px rgba(81,81,81,.75));--tw-shadow-colored:0px 1px 3px 0px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow,0 0 #0000),var(--tw-ring-shadow,0 0 #0000),var(--tw-shadow)}sd-popup li{transition-duration:.15s;transition-property:all;transition-timing-function:cubic-bezier(.4,0,.2,1)}sd-popup li:hover:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-100,246 246 246)/var(--tw-bg-opacity,1))}sd-popup li{list-style-type:""}sd-popup li mark{background-color:transparent;font-weight:700}sd-popup li:not(:has(sd-option)){cursor:pointer;font-size:var(--sd-font-size-base,1rem);padding:var(--sd-spacing-3,.75rem) var(--sd-spacing-4,1rem);--tw-text-opacity:1;color:rgb(var(--sd-color-black,24 24 24)/var(--tw-text-opacity,1))}sd-popup li:not(:has(sd-option)):hover{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-200,233 233 233)/var(--tw-bg-opacity,1))}sd-popup li[aria-selected=true]{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-200,233 233 233)/var(--tw-bg-opacity,1))}`;
    const styleSheet = new CSSStyleSheet();
    styleSheet.replaceSync(styles);
    sdInput.shadowRoot.adoptedStyleSheets = [...sdInput.shadowRoot.adoptedStyleSheets, styleSheet];
  });
  if (setValueOnSelection) {
    input.addEventListener("selection", (event) => {
      var _a;
      sdInput.value = (_a = event == null ? void 0 : event.detail) == null ? void 0 : _a.selection.value;
    });
  }
  input.addEventListener("open", () => {
    var _a, _b, _c, _d, _e, _f;
    (_b = (_a = sdInput.shadowRoot) == null ? void 0 : _a.querySelector("sd-popup")) == null ? void 0 : _b.setAttribute("active", "true");
    (_d = (_c = sdInput.shadowRoot) == null ? void 0 : _c.querySelector('[part="border"]')) == null ? void 0 : _d.classList.add("rounded-b-none");
    (_f = (_e = sdInput.shadowRoot) == null ? void 0 : _e.querySelector('[part="form-control"]')) == null ? void 0 : _f.classList.add("z-50");
  });
  input.addEventListener("close", () => {
    var _a, _b, _c, _d, _e, _f;
    (_b = (_a = sdInput.shadowRoot) == null ? void 0 : _a.querySelector("sd-popup")) == null ? void 0 : _b.removeAttribute("active");
    (_d = (_c = sdInput.shadowRoot) == null ? void 0 : _c.querySelector('[part="border"]')) == null ? void 0 : _d.classList.remove("rounded-b-none");
    (_f = (_e = sdInput.shadowRoot) == null ? void 0 : _e.querySelector('[part="form-control"]')) == null ? void 0 : _f.classList.remove("z-50");
  });
  if (scrollSelectionIntoView) {
    input.addEventListener("navigate", () => {
      const selected = sdInput.shadowRoot.querySelector('[aria-selected="true"]');
      selected == null ? void 0 : selected.scrollIntoView({ block: "nearest" });
    });
  }
  return {
    config: {
      selector: () => {
        return input;
      },
      resultsList: {
        tag: "ul"
      },
      wrapper: false
    }
  };
}

export {
  setupAutocomplete
};
