import {
  SdAccordion
} from "./chunk.FFKZQXJ2.js";
import {
  setDefaultAnimation
} from "./chunk.N4LHE3QK.js";
import {
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/quickfact/quickfact.ts
import { css } from "lit";
import { html, literal } from "lit/static-html.js";
import { ifDefined } from "lit/directives/if-defined.js";
import { property } from "lit/decorators.js";
import cx from "classix";
var SdQuickfact = class extends SdAccordion {
  constructor() {
    super(...arguments);
    this.expandable = false;
  }
  render() {
    const base = this.expandable ? literal`details` : literal`div`;
    const header = this.expandable ? literal`summary` : literal`div`;
    return html`
      <${base} part="base" class="sm:p-6">
        <${header}
          part="header"
          id="header"
          class=${cx(
      "text-base font-bold items-center focus-visible:focus-outline text-primary relative group flex flex-row hover:bg-transparent gap-3 pb-3 pt-0 px-0 sm:flex-col sm:gap-4 sm:pb-8",
      this.expandable && "cursor-pointer select-none"
    )}
          role=${ifDefined(this.expandable ? "button" : void 0)}
          aria-expanded=${ifDefined(this.expandable ? this.open ? "true" : "false" : void 0)}
          aria-controls=${ifDefined(this.expandable ? "content" : void 0)}
          tabindex=${this.expandable ? "0" : "-1"}
          @click=${this.expandable ? this.handleSummaryClick : null}
          @keydown=${this.expandable ? this.handleSummaryKeyDown : null}
        >
          <div
            part="icon"
            class=${cx("flex flex-grow-0 flex-shrink-0 flex-auto items-center", !this.expandable && "cursor-default")}
          >
            <slot name="icon"></slot>
          </div>
          <slot
            name="summary"
            part="summary"
            class=${cx(
      "flex flex-auto items-start text-left text-base leading-normal font-normal sm:leading-tight sm:text-3xl sm:text-center",
      this.expandable ? "text-primary" : "text-black cursor-default"
    )}>
            ${this.summary}
            </slot>
          <span
            part="summary-icon"
            class=${cx(
      "flex flex-grow-0 flex-shrink-0 flex-auto self-start sm:self-center transition-all ease-in-out duration-300 text-xl sm:text-4xl sm:mt-2",
      this.open && "rotate-180",
      !this.expandable && "hidden"
    )}
            ><slot name="expand-icon" class=${cx(this.open && "hidden")}>
              <sd-icon library="system" name="chevron-down"></sd-icon>
            </slot>
            <slot name="collapse-icon" class=${cx(!this.open && "hidden")}>
              <sd-icon library="system" name="chevron-down"></sd-icon> </slot
          ></span>
        </${header}>
        <div part="content" id="content" class=${cx("overflow-hidden", !this.expandable && "hidden")}>
          <slot part="content__slot" class="block" role="region" aria-labelledby="header"></slot>
        </div>
      </${base}>
    `;
  }
};
SdQuickfact.styles = [
  ...SdAccordion.styles,
  css`:host{display:block}@media (min-width:640px){[part=summary-icon]{font-size:var(--sd-spacing-12,3rem)}}[part=icon]{font-size:var(--sd-spacing-12,3rem)}@media (min-width:640px){[part=icon]{font-size:var(--sd-spacing-24,6rem)}}`
];
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdQuickfact.prototype, "expandable", 2);
SdQuickfact = __decorateClass([
  customElement("sd-quickfact")
], SdQuickfact);
setDefaultAnimation("quickfact.show", {
  keyframes: [
    { height: "0", opacity: "0" },
    { height: "auto", opacity: "1" }
  ],
  options: { duration: 300, easing: "ease" }
});
setDefaultAnimation("quickfact.hide", {
  keyframes: [
    { height: "auto", opacity: "1" },
    { height: "0", opacity: "0" }
  ],
  options: { duration: 300, easing: "ease" }
});

export {
  SdQuickfact
};
