import {
  defaultValue
} from "./chunk.GI7VDIWX.js";
import {
  FormControlController
} from "./chunk.KVKRZJS7.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/checkbox/checkbox.ts
import { css, html } from "lit";
import { ifDefined } from "lit/directives/if-defined.js";
import { live } from "lit/directives/live.js";
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var SdCheckbox = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.formControlController = new FormControlController(this, {
      value: (control) => control.checked ? control.value || "on" : void 0,
      defaultValue: (control) => control.defaultChecked,
      setValue: (control, checked) => control.checked = checked
    });
    this.title = "";
    this.name = "";
    this.size = "lg";
    this.disabled = false;
    this.checked = false;
    this.indeterminate = false;
    this.defaultChecked = false;
    this.form = "";
    this.required = false;
    this.showInvalidStyle = false;
  }
  /** Gets the validity state object */
  get validity() {
    return this.input.validity;
  }
  firstUpdated() {
    this.formControlController.updateValidity();
  }
  handleClick() {
    this.checked = !this.checked;
    this.indeterminate = false;
    this.emit("sd-change");
  }
  handleBlur() {
    this.emit("sd-blur");
  }
  handleInput() {
    this.emit("sd-input");
  }
  handleInvalid(event) {
    this.formControlController.setValidity(false);
    this.formControlController.emitInvalidEvent(event);
    this.invalidMessage.textContent = event.target.validationMessage;
  }
  handleFocus() {
    this.emit("sd-focus");
  }
  handleDisabledChange() {
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
    this.formControlController.setValidity(this.disabled);
  }
  handleStateChange() {
    this.input.checked = this.checked;
    this.input.indeterminate = this.indeterminate;
    this.formControlController.updateValidity();
  }
  /** Simulates a click on the checkbox. */
  click() {
    this.input.click();
  }
  /** Sets focus on the checkbox. */
  focus(options) {
    this.input.focus(options);
  }
  /** Removes focus from the checkbox. */
  blur() {
    this.input.blur();
  }
  /** Checks for validity but does not show a validation message. Returns true when valid and false when invalid. */
  checkValidity() {
    return this.input.checkValidity();
  }
  /** Gets the associated form, if one exists. */
  getForm() {
    return this.formControlController.getForm();
  }
  /** Checks for validity and shows a validation message if the control is invalid. */
  reportValidity() {
    this.formControlController.fakeUserInteraction();
    return this.input.reportValidity();
  }
  /**
   * Sets a custom validation message. The value provided will be shown to the user when the form is submitted. To clear
   * the custom validation message, call this method with an empty string.
   */
  setCustomValidity(message) {
    this.input.setCustomValidity(message);
    this.formControlController.updateValidity();
  }
  render() {
    const checkboxState = this.disabled && this.indeterminate ? "disabledIndeterminate" : this.disabled && this.checked ? "disabledChecked" : this.disabled ? "disabled" : this.showInvalidStyle && this.indeterminate ? "invalidIndeterminate" : this.showInvalidStyle ? "invalid" : this.checked || this.indeterminate ? "filled" : "default";
    return html`<label part="base" class="${cx(
      "sd-checkbox group flex items-start text-base leading-normal text-black cursor-pointer",
      this.disabled && "hover:cursor-not-allowed",
      {
        /* sizes, fonts */
        sm: "text-sm",
        md: "text-base",
        lg: "text-base"
      }[this.size]
    )}"><input class="peer absolute opacity-0 p-0 m-0 pointer-events-none" type="checkbox" title="${this.title}" name="${this.name}" value="${ifDefined(this.value)}" .indeterminate="${live(this.indeterminate)}" .checked="${live(this.checked)}" .disabled="${this.disabled}" .required="${this.required}" aria-checked="${this.checked ? "true" : "false"}" aria-describedby="invalid-message" aria-invalid="${this.showInvalidStyle}" @click="${this.handleClick}" @input="${this.handleInput}" @invalid="${this.handleInvalid}" @blur="${this.handleBlur}" @focus="${this.handleFocus}"> <span id="control" part="control ${this.checked ? " control--checked" : "control--unchecked"} ${this.indeterminate ? " control--indeterminate" : ""}" class="${cx(
      `relative flex flex-shrink-0 items-center justify-center border rounded-sm h-4 w-4
            peer-focus-visible:outline peer-focus-visible:outline-2 peer-focus-visible:outline-offset-2
            peer-focus-visible:outline-primary`,
      {
        sm: "mt-[2px]",
        md: "mt-[3px]",
        lg: "mt-[3px]"
      }[this.size],
      {
        disabledIndeterminate: "border-neutral-500 bg-neutral-500",
        disabledChecked: "border-neutral-500 bg-neutral-500",
        disabled: "border-neutral-500",
        invalidIndeterminate: "border-error bg-error group-hover:bg-error-400",
        invalid: "border-error group-hover:bg-neutral-200",
        filled: "border-accent hover:border-accent-550 group-hover:border-accent-550 bg-accent group-hover:bg-accent-550",
        default: "border-neutral-800 hover:bg-neutral-200 group-hover:bg-neutral-200 bg-white"
      }[checkboxState]
    )}">${this.checked ? html`<sd-icon part="checked-icon" class="text-white w-3 h-3" library="system" name="status-check"></sd-icon>` : ""} ${!this.checked && this.indeterminate ? html`<sd-icon part="indeterminate-icon" class="text-white w-3 h-3" library="system" name="status-minus"></sd-icon>` : ""} </span><span part="label" id="label" class="${cx(
      "select-none inline-block ml-2",
      this.disabled ? "text-neutral-500" : this.showInvalidStyle ? "text-error" : "text-black"
    )}"><slot></slot></span></label> ${this.formControlController.renderInvalidMessage()}`;
  }
};
/**
 * Inherits Tailwind classes and includes additional styling.
 */
SdCheckbox.styles = [
  ...SolidElement.styles,
  css`:host{display:block;width:-moz-max-content;width:max-content}:host(:focus-visible){outline-width:0}:host([required]) #label:after{content:" *"}`
];
__decorateClass([
  query('input[type="checkbox"]')
], SdCheckbox.prototype, "input", 2);
__decorateClass([
  query("#invalid-message")
], SdCheckbox.prototype, "invalidMessage", 2);
__decorateClass([
  property()
], SdCheckbox.prototype, "title", 2);
__decorateClass([
  property()
], SdCheckbox.prototype, "name", 2);
__decorateClass([
  property()
], SdCheckbox.prototype, "value", 2);
__decorateClass([
  property({ reflect: true })
], SdCheckbox.prototype, "size", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdCheckbox.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdCheckbox.prototype, "checked", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdCheckbox.prototype, "indeterminate", 2);
__decorateClass([
  defaultValue("checked")
], SdCheckbox.prototype, "defaultChecked", 2);
__decorateClass([
  property({ reflect: true })
], SdCheckbox.prototype, "form", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdCheckbox.prototype, "required", 2);
__decorateClass([
  state()
], SdCheckbox.prototype, "showInvalidStyle", 2);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdCheckbox.prototype, "handleDisabledChange", 1);
__decorateClass([
  watch(["checked", "indeterminate"], { waitUntilFirstUpdate: true })
], SdCheckbox.prototype, "handleStateChange", 1);
SdCheckbox = __decorateClass([
  customElement("sd-checkbox")
], SdCheckbox);

export {
  SdCheckbox
};
