import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/teaser/teaser.ts
import { css, html } from "lit";
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var SdTeaser = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.variant = "white";
    this.breakpoint = 448;
    this.inset = false;
    this.hasSlotController = new HasSlotController(this, "[default]", "media", "meta", "headline");
  }
  connectedCallback() {
    super.connectedCallback();
    if (this.breakpoint === 0) {
      this._orientation = "horizontal";
    } else if (this.breakpoint === 9999) {
      this._orientation = "vertical";
    } else if (window.ResizeObserver) {
      this.resizeObserver = new ResizeObserver(() => this.updateOrientation());
      this.resizeObserver.observe(this);
    }
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    if (this.resizeObserver) {
      this.resizeObserver.disconnect();
    }
  }
  updated(changedProperties) {
    super.updated(changedProperties);
    if (changedProperties.has("breakpoint")) {
      this.updateOrientation();
    }
  }
  updateOrientation() {
    this._orientation = this.offsetWidth >= this.breakpoint ? "horizontal" : "vertical";
  }
  render() {
    const inset = this.variant === "white border-neutral-400" || this.inset;
    const slots = {
      "teaser-has-default": this.hasSlotController.test("[default]"),
      "teaser-has-media": this.hasSlotController.test("media"),
      "teaser-has-meta": this.hasSlotController.test("meta"),
      "teaser-has-headline": this.hasSlotController.test("headline")
    };
    return html`<div class="${cx(
      "flex",
      {
        white: "bg-white",
        "white border-neutral-400": "bg-white border border-neutral-400",
        "neutral-100": "bg-neutral-100",
        primary: "bg-primary text-white",
        "primary-100": "bg-primary-100"
      }[this.variant],
      this._orientation === "vertical" && "flex-col",
      this._orientation === "horizontal" && "flex-row gap-8",
      this._orientation === "horizontal" && inset && "py-8 px-10"
    )}" part="base"><div part="media" id="media" aria-hidden="true" style="${this._orientation === "horizontal" ? `width: var(--distribution-media, 100%);` : ""}" class="${cx(
      !inset && this._orientation === "vertical" && "mb-4",
      !slots["teaser-has-media"] && "hidden",
      this.variant === "white border-neutral-400" && this._orientation === "vertical" && "mx-[-1px] mt-[-1px]"
    )}"><slot name="media"></slot></div><div style="${this._orientation === "horizontal" ? `width: var(--distribution-content, 100%); ${inset ? "width: var(--distribution-content, calc(100% - 2rem));" : ""}` : ""}" class="${cx(
      "flex flex-col text-left",
      this._orientation === "horizontal" && `flex flex-col`,
      this._orientation === "vertical" && inset && "m-4"
    )}" part="content"><div class="flex flex-col-reverse"><div part="headline" class="${cx("text-lg font-bold m-0", this.variant === "primary" ? "text-white" : "text-black")}"><slot name="headline">Always insert one semantically correct heading element here (e. g. &lt;h2>)</slot></div><div part="meta" class="${cx("gap-2 mb-4", !slots["teaser-has-meta"] && "hidden")}"><slot name="meta"></slot></div></div><div part="main" class="${cx(!slots["teaser-has-default"] && "hidden")}" aria-labelledby="media"><slot></slot></div></div></div>`;
  }
};
SdTeaser.styles = [
  ...SolidElement.styles,
  css`:host{display:block}::slotted(*){margin:var(--sd-spacing-0,0)}::slotted([slot=headline]){font-size:var(--sd-font-size-lg,1.25rem)!important;font-weight:700;margin:var(--sd-spacing-0,0)!important}`
];
__decorateClass([
  property({ reflect: true })
], SdTeaser.prototype, "variant", 2);
__decorateClass([
  property({ reflect: true, type: Number })
], SdTeaser.prototype, "breakpoint", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTeaser.prototype, "inset", 2);
__decorateClass([
  query('[part="base"]')
], SdTeaser.prototype, "teaser", 2);
__decorateClass([
  state()
], SdTeaser.prototype, "_orientation", 2);
SdTeaser = __decorateClass([
  customElement("sd-teaser")
], SdTeaser);

export {
  SdTeaser
};
