import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/checkbox-group/checkbox-group.ts
import { css, html } from "lit";
import { property } from "lit/decorators.js";
import cx from "classix";
var SdCheckboxGroup = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.hasSlotController = new HasSlotController(this, "label");
    this.size = "lg";
    this.orientation = "vertical";
    this.label = "";
  }
  getAllCheckboxes() {
    return [...this.querySelectorAll("sd-checkbox")];
  }
  async syncCheckboxElements() {
    const checkboxes = this.getAllCheckboxes();
    await Promise.all(
      // Sync the checked state and size
      checkboxes.map(async (checkbox) => {
        await checkbox.updateComplete;
        checkbox.size = this.size;
      })
    );
  }
  syncCheckboxes() {
    if (customElements.get("sd-checkbox")) {
      this.syncCheckboxElements();
    } else {
      customElements.whenDefined("sd-checkbox").then(() => this.syncCheckboxes());
    }
  }
  handleSizeChange() {
    this.syncCheckboxes();
  }
  handleInvalid() {
    this.syncCheckboxes();
  }
  render() {
    const hasLabelSlot = this.hasSlotController.test("label");
    const hasLabel = this.label ? true : hasLabelSlot;
    const defaultSlot = html`<slot @slotchange="${this.syncCheckboxes}"></slot>`;
    return html`<fieldset part="form-control" class="${cx(
      "border-0 p-0 m-0",
      {
        /* sizes, fonts */
        sm: "text-sm",
        md: "text-base",
        lg: "text-base"
      }[this.size]
    )}" role="group" aria-labelledby="label"><div class="flex items-center gap-1 mb-2"><label part="form-control-label" id="label" class="${cx("p-0 font-bold leading-normal text-black", hasLabel ? "flex" : "hidden")}" aria-hidden="${hasLabel ? "false" : "true"}"><slot name="label">${this.label}</slot></label><slot name="tooltip"></slot></div><div part="form-control-input" class="${cx(
      {
        vertical: "flex flex-col",
        horizontal: "flex flex-row"
      }[this.orientation]
    )}">${defaultSlot}</div></fieldset>`;
  }
};
/**
 * Inherits Tailwind classes and includes additional styling.
 */
SdCheckboxGroup.styles = [
  ...SolidElement.styles,
  css`:host{display:block}:host([orientation=vertical]) ::slotted(sd-checkbox){display:flex;margin-bottom:var(--sd-spacing-2,.5rem)}:host([orientation=vertical]) ::slotted(sd-checkbox:last-of-type){margin-bottom:var(--sd-spacing-0,0)}:host([orientation=horizontal]) ::slotted(sd-checkbox){margin-right:var(--sd-spacing-6,1.5rem)}:host([orientation=horizontal]) ::slotted(sd-checkbox:last-of-type){margin-right:var(--sd-spacing-0,0)}:host([orientation=horizontal]):host([size=sm]) ::slotted(sd-checkbox){margin-right:var(--sd-spacing-4,1rem)}:host([orientation=horizontal]):host([size=sm]) ::slotted(sd-checkbox:last-of-type){margin-right:var(--sd-spacing-0,0)}`
];
__decorateClass([
  property({ reflect: true })
], SdCheckboxGroup.prototype, "size", 2);
__decorateClass([
  property({ reflect: true })
], SdCheckboxGroup.prototype, "orientation", 2);
__decorateClass([
  property()
], SdCheckboxGroup.prototype, "label", 2);
__decorateClass([
  watch("size", { waitUntilFirstUpdate: true })
], SdCheckboxGroup.prototype, "handleSizeChange", 1);
__decorateClass([
  watch("invalid", { waitUntilFirstUpdate: true })
], SdCheckboxGroup.prototype, "handleInvalid", 1);
SdCheckboxGroup = __decorateClass([
  customElement("sd-checkbox-group")
], SdCheckboxGroup);

export {
  SdCheckboxGroup
};
