import {
  Modal
} from "./chunk.VBQLCQSN.js";
import {
  lockBodyScrolling,
  unlockBodyScrolling
} from "./chunk.WDWV53JP.js";
import {
  getAnimation,
  setDefaultAnimation
} from "./chunk.N4LHE3QK.js";
import {
  animateTo,
  stopAnimations
} from "./chunk.EY4JPJJQ.js";
import {
  waitForEvent
} from "./chunk.B4BZKR24.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/dialog/dialog.ts
import { css, html } from "lit";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdDialog = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.hasSlotController = new HasSlotController(this, "footer");
    this.localize = new LocalizeController(this);
    this.open = false;
    this.headline = "";
    this.noCloseButton = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.handleDocumentKeyDown = this.handleDocumentKeyDown.bind(this);
    this.modal = new Modal(this);
  }
  firstUpdated() {
    this.dialog.hidden = !this.open;
    if (this.open) {
      this.addOpenListeners();
      this.modal.activate();
      lockBodyScrolling(this);
    }
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    unlockBodyScrolling(this);
  }
  requestClose(source) {
    const sdRequestClose = this.emit("sd-request-close", {
      cancelable: true,
      detail: { source }
    });
    if (sdRequestClose.defaultPrevented) {
      const animation = getAnimation(this, "dialog.denyClose", { dir: this.localize.dir() });
      animateTo(this.panel, animation.keyframes, animation.options);
      return;
    }
    this.hide();
  }
  addOpenListeners() {
    document.addEventListener("keydown", this.handleDocumentKeyDown);
  }
  removeOpenListeners() {
    document.removeEventListener("keydown", this.handleDocumentKeyDown);
  }
  handleDocumentKeyDown(event) {
    if (this.open && event.key === "Escape") {
      event.stopPropagation();
      this.requestClose("keyboard");
    }
  }
  async handleOpenChange() {
    if (this.open) {
      this.emit("sd-show");
      this.addOpenListeners();
      this.originalTrigger = document.activeElement;
      this.modal.activate();
      lockBodyScrolling(this);
      const autoFocusTarget = this.querySelector("[autofocus]");
      if (autoFocusTarget) {
        autoFocusTarget.removeAttribute("autofocus");
      }
      await Promise.all([stopAnimations(this.dialog), stopAnimations(this.overlay)]);
      this.dialog.hidden = false;
      requestAnimationFrame(() => {
        const slInitialFocus = this.emit("sd-initial-focus", { cancelable: true });
        if (!slInitialFocus.defaultPrevented) {
          if (autoFocusTarget) {
            autoFocusTarget.focus({ preventScroll: true });
          } else {
            this.panel.focus({ preventScroll: true });
          }
        }
        if (autoFocusTarget) {
          autoFocusTarget.setAttribute("autofocus", "");
        }
      });
      const panelAnimation = getAnimation(this, "dialog.show", { dir: this.localize.dir() });
      const overlayAnimation = getAnimation(this, "dialog.overlay.show", { dir: this.localize.dir() });
      await Promise.all([
        animateTo(this.panel, panelAnimation.keyframes, panelAnimation.options),
        animateTo(this.overlay, overlayAnimation.keyframes, overlayAnimation.options)
      ]);
      this.emit("sd-after-show");
    } else {
      this.emit("sd-hide");
      this.removeOpenListeners();
      this.modal.deactivate();
      await Promise.all([stopAnimations(this.dialog), stopAnimations(this.overlay)]);
      const panelAnimation = getAnimation(this, "dialog.hide", { dir: this.localize.dir() });
      const overlayAnimation = getAnimation(this, "dialog.overlay.hide", { dir: this.localize.dir() });
      await Promise.all([
        animateTo(this.overlay, overlayAnimation.keyframes, overlayAnimation.options).then(() => {
          this.overlay.hidden = true;
        }),
        animateTo(this.panel, panelAnimation.keyframes, panelAnimation.options).then(() => {
          this.panel.hidden = true;
        })
      ]);
      this.dialog.hidden = true;
      this.overlay.hidden = false;
      this.panel.hidden = false;
      unlockBodyScrolling(this);
      const trigger = this.originalTrigger;
      if (typeof (trigger == null ? void 0 : trigger.focus) === "function") {
        setTimeout(() => trigger.focus());
      }
      this.emit("sd-after-hide");
    }
  }
  /** Shows the dialog. */
  async show() {
    if (this.open) {
      return void 0;
    }
    this.open = true;
    return waitForEvent(this, "sd-after-show");
  }
  /** Hides the dialog */
  async hide() {
    if (!this.open) {
      return void 0;
    }
    this.open = false;
    return waitForEvent(this, "sd-after-hide");
  }
  render() {
    return html`<div part="base" class="${cx(
      "flex items-center justify-center fixed inset-0 z-dialog",
      this.hasSlotController.test("footer") && "dialog--has-footer"
    )}"><div part="overlay" class="fixed inset-0 bg-primary-800 opacity-90" @click="${() => this.requestClose("overlay")}" tabindex="-1"></div><div part="panel" class="${cx(
      "flex flex-col z-20 bg-white py-4 sm:py-8 relative gap-6 focus-visible:focus-outline-inverted",
      this.open && "flex opacity-100"
    )}" role="dialog" aria-modal="true" aria-hidden="${this.open ? "false" : "true"}" aria-label="${this.headline}" aria-labelledby="title" tabindex="0"><header part="header" class="flex flex-grow-0 flex-shrink-0 basis-auto px-6 sm:px-10"><h2 part="title" class="flex-auto m-0" id="title">${this.headline.length > 0 ? html`<span class="sd-headline sd-headline--size-3xl leading-tight">${this.headline}</span>` : html`<slot name="headline"></slot>`}</h2>${!this.noCloseButton ? html`<sd-button part="close-button" variant="tertiary" exportparts="base:close-button__base" class="${cx("absolute top-2 right-2")}" name="x-lg" @click="${() => this.requestClose("close-button")}" type="button"><sd-icon label="${this.localize.term("close")}" name="close" library="system" color="currentColor"></sd-icon></sd-button>` : ""}</header><main part="body" class="flex flex-auto overflow-auto w-full px-6 sm:px-10"><slot></slot></main><footer part="footer" class="flex flex-grow-0 flex-shrink-0 basis-auto ml-auto gap-4 px-6 sm:px-10"><slot name="footer"></slot></footer></div></div>`;
  }
};
SdDialog.styles = [
  ...SolidElement.styles,
  css`:host{--width:662px}[part=panel]{width:var(--width)}[part=body]{-webkit-overflow-scrolling:touch}@media (max-width:414px){:host{--width:335px}[part=footer]{width:100%}}`
];
__decorateClass([
  query('[part="base"]')
], SdDialog.prototype, "dialog", 2);
__decorateClass([
  query('[part="panel"]')
], SdDialog.prototype, "panel", 2);
__decorateClass([
  query('[part="overlay"]')
], SdDialog.prototype, "overlay", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdDialog.prototype, "open", 2);
__decorateClass([
  property({ reflect: true })
], SdDialog.prototype, "headline", 2);
__decorateClass([
  property({ attribute: "no-close-button", type: Boolean, reflect: true })
], SdDialog.prototype, "noCloseButton", 2);
__decorateClass([
  watch("open", { waitUntilFirstUpdate: true })
], SdDialog.prototype, "handleOpenChange", 1);
SdDialog = __decorateClass([
  customElement("sd-dialog")
], SdDialog);
setDefaultAnimation("dialog.show", {
  keyframes: [
    { opacity: 0, scale: 0.8 },
    { opacity: 1, scale: 1 }
  ],
  options: { duration: 250, easing: "ease" }
});
setDefaultAnimation("dialog.hide", {
  keyframes: [
    { opacity: 1, scale: 1 },
    { opacity: 0, scale: 0.8 }
  ],
  options: { duration: 250, easing: "ease" }
});
setDefaultAnimation("dialog.denyClose", {
  keyframes: [{ scale: 1 }, { scale: 1.02 }, { scale: 1 }],
  options: { duration: 250 }
});
setDefaultAnimation("dialog.overlay.show", {
  keyframes: [{ opacity: 0 }, { opacity: 1 }],
  options: { duration: 250 }
});
setDefaultAnimation("dialog.overlay.hide", {
  keyframes: [{ opacity: 1 }, { opacity: 0 }],
  options: { duration: 250 }
});

export {
  SdDialog
};
