import {
  getTabbableBoundary
} from "./chunk.XHCTCU2Q.js";
import {
  scrollIntoView
} from "./chunk.WDWV53JP.js";
import {
  getAnimation,
  setDefaultAnimation
} from "./chunk.N4LHE3QK.js";
import {
  animateTo,
  stopAnimations
} from "./chunk.EY4JPJJQ.js";
import {
  waitForEvent
} from "./chunk.B4BZKR24.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/dropdown/dropdown.ts
import { css, html } from "lit";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdDropdown = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.localize = new LocalizeController(this);
    this.open = false;
    this.rounded = false;
    this.placement = "bottom-start";
    this.disabled = false;
    this.stayOpenOnSelect = false;
    this.distance = 0;
    this.skidding = 0;
    this.noAutoSize = false;
    this.noFlip = false;
    this.hoist = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.handleMenuItemActivate = this.handleMenuItemActivate.bind(this);
    this.handlePanelSelect = this.handlePanelSelect.bind(this);
    this.handleKeyDown = this.handleKeyDown.bind(this);
    this.handleDocumentKeyDown = this.handleDocumentKeyDown.bind(this);
    this.handleDocumentMouseDown = this.handleDocumentMouseDown.bind(this);
    if (!this.containingElement) {
      this.containingElement = this;
    }
  }
  firstUpdated() {
    this.panel.hidden = !this.open;
    if (this.open) {
      this.addOpenListeners();
      this.popup.active = true;
    }
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    this.removeOpenListeners();
    this.hide();
  }
  /**
   * Slotted triggers can be arbitrary content. The accessible trigger is the tabbable element
   * within the slotted trigger. This could be the slotted element itself, a child of the slotted element,
   * or an element within the slotted elements shadow root.
   *
   * e.g. the accessible trigger of an <sd-button> is a <button> located inside its shadow root.
   *
   * To determine this, we assume the first tabbable element in the trigger slot is the "accessible trigger."
   * */
  getAccessibleTrigger() {
    const assignedElements = this.trigger.assignedElements({ flatten: true });
    const accessibleTrigger = assignedElements.find((el) => getTabbableBoundary(el).start);
    let target = null;
    if (accessibleTrigger) {
      switch (accessibleTrigger.tagName.toLowerCase()) {
        // Solid buttons have to update the internal button so it's announced correctly by screen readers
        case "sd-button":
        case "sd-icon-button":
          target = accessibleTrigger.button;
          break;
        case "sd-navigation-item":
          target = accessibleTrigger.button;
          break;
        default:
          target = accessibleTrigger;
      }
    }
    return target;
  }
  // Slotted triggers can be arbitrary content, but we need to connect them to the dropdown panel with `aria-haspopup` and
  // `aria-expanded`. These must be applied to the `accessible trigger`.
  updateAccessibleTrigger() {
    const target = this.getAccessibleTrigger();
    if (!target) return;
    target.setAttribute("aria-haspopup", "true");
    target.setAttribute("aria-expanded", this.open ? "true" : "false");
  }
  focusOnTrigger() {
    const trigger = this.getAccessibleTrigger();
    if (typeof (trigger == null ? void 0 : trigger.focus) === "function") {
      trigger.focus();
    }
  }
  getMenu() {
    return this.panel.assignedElements({ flatten: true }).find((el) => el.tagName.toLowerCase() === "sd-menu");
  }
  handleKeyDown(event) {
    if (this.open && event.key === "Escape") {
      event.stopPropagation();
      this.hide();
      this.focusOnTrigger();
    }
  }
  handleDocumentKeyDown(event) {
    var _a;
    if (event.key === "Tab") {
      if (this.open && ((_a = document.activeElement) == null ? void 0 : _a.tagName.toLowerCase()) === "sd-menu-item") {
        event.preventDefault();
        this.hide();
        this.focusOnTrigger();
        return;
      }
      setTimeout(() => {
        var _a2, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l;
        const activeElement = ((_e = (_d = (_c = (_b = (_a2 = document.activeElement) == null ? void 0 : _a2.shadowRoot) == null ? void 0 : _b.activeElement) == null ? void 0 : _c.shadowRoot) == null ? void 0 : _d.activeElement) == null ? void 0 : _e.getRootNode()) instanceof ShadowRoot ? (_i = (_h = (_g = (_f = document.activeElement) == null ? void 0 : _f.shadowRoot) == null ? void 0 : _g.activeElement) == null ? void 0 : _h.shadowRoot) == null ? void 0 : _i.activeElement : ((_j = this.containingElement) == null ? void 0 : _j.getRootNode()) instanceof ShadowRoot ? (_l = (_k = document.activeElement) == null ? void 0 : _k.shadowRoot) == null ? void 0 : _l.activeElement : document.activeElement;
        if (!this.containingElement || (activeElement == null ? void 0 : activeElement.closest(this.containingElement.tagName.toLowerCase())) !== this.containingElement) {
          this.hide();
        }
      });
    }
  }
  handleDocumentMouseDown(event) {
    const path = event.composedPath();
    if (this.containingElement && !path.includes(this.containingElement)) {
      this.hide();
    }
  }
  handleMenuItemActivate(event) {
    const item = event.target;
    scrollIntoView(item, this.panel);
  }
  handlePanelSelect(event) {
    const target = event.target;
    if (!this.stayOpenOnSelect && target.tagName.toLowerCase() === "sd-menu") {
      this.hide();
      this.focusOnTrigger();
    }
  }
  handleTriggerClick() {
    if (this.open) {
      this.hide();
    } else {
      this.show();
    }
  }
  handleTriggerKeyDown(event) {
    if (event.key === "Escape" && this.open) {
      event.stopPropagation();
      this.focusOnTrigger();
      this.hide();
      return;
    }
    if ([" ", "Enter"].includes(event.key)) {
      event.preventDefault();
      this.handleTriggerClick();
      return;
    }
    const menu = this.getMenu();
    if (menu) {
      const menuItems = menu.defaultSlot.assignedElements({ flatten: true });
      const firstMenuItem = menuItems[0];
      const lastMenuItem = menuItems[menuItems.length - 1];
      if (["ArrowDown", "ArrowUp", "Home", "End"].includes(event.key)) {
        event.preventDefault();
        if (!this.open) {
          this.show();
        }
        if (menuItems.length > 0) {
          requestAnimationFrame(() => {
            if (event.key === "ArrowDown" || event.key === "Home") {
              menu.setCurrentItem(firstMenuItem);
              firstMenuItem.focus();
            }
            if (event.key === "ArrowUp" || event.key === "End") {
              menu.setCurrentItem(lastMenuItem);
              lastMenuItem.focus();
            }
          });
        }
      }
    }
  }
  handleTriggerKeyUp(event) {
    if (event.key === " ") {
      event.preventDefault();
    }
  }
  handleTriggerSlotChange() {
    this.updateAccessibleTrigger();
  }
  /** Shows the dropdown panel. */
  async show() {
    if (this.open) {
      return void 0;
    }
    this.open = true;
    return waitForEvent(this, "sd-after-show");
  }
  /** Hides the dropdown panel */
  async hide() {
    if (!this.open) {
      return void 0;
    }
    this.open = false;
    return waitForEvent(this, "sd-after-hide");
  }
  /**
   * Instructs the dropdown menu to reposition. Useful when the position or size of the trigger changes when the menu
   * is activated.
   */
  reposition() {
    this.popup.reposition();
  }
  addOpenListeners() {
    this.panel.addEventListener("sd-activate", this.handleMenuItemActivate);
    this.panel.addEventListener("sd-select", this.handlePanelSelect);
    this.panel.addEventListener("keydown", this.handleKeyDown);
    document.addEventListener("keydown", this.handleDocumentKeyDown);
    document.addEventListener("mousedown", this.handleDocumentMouseDown);
  }
  removeOpenListeners() {
    if (this.panel) {
      this.panel.removeEventListener("sd-activate", this.handleMenuItemActivate);
      this.panel.removeEventListener("sd-select", this.handlePanelSelect);
      this.panel.removeEventListener("keydown", this.handleKeyDown);
    }
    document.removeEventListener("keydown", this.handleDocumentKeyDown);
    document.removeEventListener("mousedown", this.handleDocumentMouseDown);
  }
  async handleOpenChange() {
    if (this.disabled) {
      this.open = false;
      return;
    }
    this.updateAccessibleTrigger();
    if (this.open) {
      this.emit("sd-show");
      this.addOpenListeners();
      await stopAnimations(this);
      this.panel.hidden = false;
      this.popup.active = true;
      const { keyframes, options } = getAnimation(this, "dropdown.show", { dir: this.localize.dir() });
      await animateTo(this.popup.popup, keyframes, options);
      this.emit("sd-after-show");
    } else {
      this.emit("sd-hide");
      this.removeOpenListeners();
      await stopAnimations(this);
      const { keyframes, options } = getAnimation(this, "dropdown.hide", { dir: this.localize.dir() });
      await animateTo(this.popup.popup, keyframes, options);
      this.panel.hidden = true;
      this.popup.active = false;
      this.emit("sd-after-hide");
    }
  }
  render() {
    return html`<sd-popup part="base" id="dropdown" placement="${this.placement}" distance="${this.rounded && this.distance < 1 ? 1 : this.distance}" skidding="${this.skidding}" strategy="${this.hoist ? "fixed" : "absolute"}" ?flip="${!this.noFlip}" shift auto-size="vertical" auto-size-padding="10" ?active="${this.open}"><slot name="trigger" slot="anchor" part="trigger" class="block" @click="${this.handleTriggerClick}" @keydown="${this.handleTriggerKeyDown}" @keyup="${this.handleTriggerKeyUp}" @slotchange="${this.handleTriggerSlotChange}"></slot><slot part="panel" class="${cx(
      "shadow bg-white",
      this.open ? "block pointer-events-auto" : "pointer-events-none",
      this.rounded && "rounded-md"
    )}" aria-hidden="${this.open ? "false" : "true"}" aria-labelledby="dropdown"></slot></sd-popup>`;
  }
};
SdDropdown.styles = [
  ...SolidElement.styles,
  css`:host{display:inline-block}#dropdown::part(popup){z-index:var(--sd-z-index-dropdown,900)}#dropdown[data-current-placement^=top]::part(popup){transform-origin:bottom}#dropdown[data-current-placement^=bottom]::part(popup){transform-origin:top}#dropdown[data-current-placement^=left]::part(popup){transform-origin:right}#dropdown[data-current-placement^=right]::part(popup){transform-origin:left}:host(:not([no-auto-size])) ::slotted(:not([slot=trigger])){max-height:var(--auto-size-available-height)!important;max-width:var(--auto-size-available-width)!important;overflow:auto}`
];
__decorateClass([
  query("#dropdown")
], SdDropdown.prototype, "popup", 2);
__decorateClass([
  query("[part=trigger]")
], SdDropdown.prototype, "trigger", 2);
__decorateClass([
  query("[part=panel]")
], SdDropdown.prototype, "panel", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdDropdown.prototype, "open", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdDropdown.prototype, "rounded", 2);
__decorateClass([
  property({ reflect: true })
], SdDropdown.prototype, "placement", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdDropdown.prototype, "disabled", 2);
__decorateClass([
  property({ attribute: "stay-open-on-select", type: Boolean, reflect: true })
], SdDropdown.prototype, "stayOpenOnSelect", 2);
__decorateClass([
  property({ attribute: false })
], SdDropdown.prototype, "containingElement", 2);
__decorateClass([
  property({ type: Number })
], SdDropdown.prototype, "distance", 2);
__decorateClass([
  property({ type: Number })
], SdDropdown.prototype, "skidding", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "no-auto-size" })
], SdDropdown.prototype, "noAutoSize", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "no-flip" })
], SdDropdown.prototype, "noFlip", 2);
__decorateClass([
  property({ type: Boolean })
], SdDropdown.prototype, "hoist", 2);
__decorateClass([
  watch("open", { waitUntilFirstUpdate: true })
], SdDropdown.prototype, "handleOpenChange", 1);
SdDropdown = __decorateClass([
  customElement("sd-dropdown")
], SdDropdown);
setDefaultAnimation("dropdown.show", {
  keyframes: [
    { opacity: 0, scale: 0.9 },
    { opacity: 1, scale: 1 }
  ],
  options: { duration: 100, easing: "ease" }
});
setDefaultAnimation("dropdown.hide", {
  keyframes: [
    { opacity: 1, scale: 1 },
    { opacity: 0, scale: 0.9 }
  ],
  options: { duration: 100, easing: "ease" }
});

export {
  SdDropdown
};
