import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/accordion-group/accordion-group.ts
import { css, html } from "lit";
import { property, queryAssignedElements } from "lit/decorators.js";
var SdAccordionGroup = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.closeOthers = false;
    this.handleAccordionShow = (event) => {
      if (this.closeOthers) {
        this._accordionsInDefaultSlot.forEach((accordionElement) => {
          if (accordionElement === event.target) {
            return;
          }
          if (accordionElement.parentNode !== event.target.parentNode) {
            return;
          }
          accordionElement.removeAttribute("open");
        });
      }
    };
  }
  connectedCallback() {
    super.connectedCallback();
    this.addEventListener("sd-show", this.handleAccordionShow);
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    this.removeEventListener("sd-show", this.handleAccordionShow);
  }
  render() {
    return html`<div part="base"><slot></slot></div>`;
  }
};
SdAccordionGroup.styles = [
  ...SolidElement.styles,
  css`:host{display:block}::slotted(sd-accordion:not(:first-of-type)){margin-top:-1px}`
];
__decorateClass([
  queryAssignedElements({ selector: "sd-accordion" })
], SdAccordionGroup.prototype, "_accordionsInDefaultSlot", 2);
__decorateClass([
  property({ attribute: "close-others", type: Boolean })
], SdAccordionGroup.prototype, "closeOthers", 2);
SdAccordionGroup = __decorateClass([
  customElement("sd-accordion-group")
], SdAccordionGroup);

export {
  SdAccordionGroup
};
