import {
  getAnimation,
  setDefaultAnimation
} from "./chunk.N4LHE3QK.js";
import {
  animateTo,
  shimKeyframesHeightAuto,
  stopAnimations
} from "./chunk.EY4JPJJQ.js";
import {
  waitForEvent
} from "./chunk.B4BZKR24.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/accordion/accordion.ts
import { css } from "lit";
import { html } from "lit/static-html.js";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdAccordion = class extends SolidElement {
  constructor() {
    super(...arguments);
    // static styles: CSSResultGroup = styles;
    this.localize = new LocalizeController(this);
    this.open = false;
  }
  firstUpdated() {
    this.body.hidden = !this.open;
    this.body.style.height = this.open ? "auto" : "0";
    if (this.open) {
      this.accordion.open = true;
    }
    this.accordionObserver = new MutationObserver((changes) => {
      for (const change of changes) {
        if (change.type === "attributes" && change.attributeName === "open") {
          if (this.accordion.open) {
            this.show();
          } else {
            this.hide();
          }
        }
      }
    });
    this.accordionObserver.observe(this.accordion, { attributes: true });
  }
  disconnectedCallback() {
    var _a;
    super.disconnectedCallback();
    (_a = this.accordionObserver) == null ? void 0 : _a.disconnect();
  }
  handleSummaryClick(event) {
    event.preventDefault();
    if (this.open) {
      this.hide();
    } else {
      this.show();
    }
  }
  handleSummaryKeyDown(event) {
    if (event.key === "Enter" || event.key === " ") {
      event.preventDefault();
      if (this.open) {
        this.hide();
      } else {
        this.show();
      }
    }
    if (event.key === "ArrowUp" || event.key === "ArrowLeft") {
      event.preventDefault();
      this.hide();
    }
    if (event.key === "ArrowDown" || event.key === "ArrowRight") {
      event.preventDefault();
      this.show();
    }
  }
  async handleOpenChange() {
    if (this.open) {
      this.accordion.open = true;
      const slShow = this.emit("sd-show", { cancelable: true });
      if (slShow.defaultPrevented) {
        this.open = false;
        this.accordion.open = false;
        return;
      }
      await stopAnimations(this.body);
      this.body.hidden = false;
      const { keyframes, options } = getAnimation(this, "accordion.show", { dir: this.localize.dir() });
      await animateTo(this.body, shimKeyframesHeightAuto(keyframes, this.body.scrollHeight), options);
      this.body.style.height = "auto";
      this.emit("sd-after-show");
    } else {
      const slHide = this.emit("sd-hide", { cancelable: true });
      if (slHide.defaultPrevented) {
        this.accordion.open = true;
        this.open = true;
        return;
      }
      await stopAnimations(this.body);
      const { keyframes, options } = getAnimation(this, "accordion.hide", { dir: this.localize.dir() });
      await animateTo(this.body, shimKeyframesHeightAuto(keyframes, this.body.scrollHeight), options);
      this.body.hidden = true;
      this.body.style.height = "auto";
      this.accordion.open = false;
      this.emit("sd-after-hide");
    }
  }
  /** Shows the accordion. */
  async show() {
    if (this.open) {
      return void 0;
    }
    this.open = true;
    return waitForEvent(this, "sd-after-show");
  }
  /** Hides the accordion */
  async hide() {
    if (!this.open) {
      return void 0;
    }
    this.open = false;
    return waitForEvent(this, "sd-after-hide");
  }
  render() {
    return html`<details part="base" class="border-y border-neutral-400"><summary part="header" id="header" class="${cx(
      "flex text-base gap-4 font-bold items-center cursor-pointer select-none px-4 py-3 focus-visible:focus-outline text-primary hover:bg-neutral-200 relative group"
    )}" aria-expanded="${this.open ? "true" : "false"}" aria-controls="content" tabindex="0" @click="${this.handleSummaryClick}" @keydown="${this.handleSummaryKeyDown}"><div part="summary-border" class="${cx(
      !this.open && "opacity-0",
      "w-1 bg-accent absolute left-0 transition-all h-[calc(100%-16px)] group-hover:h-full"
    )}"></div><slot name="summary" part="summary" class="flex flex-auto items-center text-left">${this.summary}</slot><span part="summary-icon" class="${cx(
      "flex flex-grow-0 flex-shrink-0 flex-auto items-center transition-all ease-in-out duration-300 text-xl",
      this.open && "rotate-180"
    )}"><slot name="expand-icon" class="${cx(this.open && "hidden")}"><sd-icon library="system" name="chevron-down"></sd-icon></slot><slot name="collapse-icon" class="${cx(!this.open && "hidden")}"><sd-icon library="system" name="chevron-down"></sd-icon></slot></span></summary><div part="content" id="content" class="overflow-hidden"><slot part="content__slot" class="block px-4 py-6" role="region" aria-labelledby="header"></slot></div></details>`;
  }
};
SdAccordion.styles = [
  ...SolidElement.styles,
  css`:host{display:block}`
];
__decorateClass([
  query('[part="base"]')
], SdAccordion.prototype, "accordion", 2);
__decorateClass([
  query('[part="header"]')
], SdAccordion.prototype, "header", 2);
__decorateClass([
  query('[part="content"]')
], SdAccordion.prototype, "body", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdAccordion.prototype, "open", 2);
__decorateClass([
  property()
], SdAccordion.prototype, "summary", 2);
__decorateClass([
  watch("open", { waitUntilFirstUpdate: true })
], SdAccordion.prototype, "handleOpenChange", 1);
SdAccordion = __decorateClass([
  customElement("sd-accordion")
], SdAccordion);
setDefaultAnimation("accordion.show", {
  keyframes: [
    { height: "0", opacity: "0" },
    { height: "auto", opacity: "1" }
  ],
  options: { duration: 300, easing: "ease" }
});
setDefaultAnimation("accordion.hide", {
  keyframes: [
    { height: "auto", opacity: "1" },
    { height: "0", opacity: "0" }
  ],
  options: { duration: 300, easing: "ease" }
});

export {
  SdAccordion
};
