import {
  waitForEvent
} from "./chunk.B4BZKR24.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/expandable/expandable.ts
import { css, html } from "lit";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdExpandable = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.open = false;
    this.inverted = false;
    this.localize = new LocalizeController(this);
  }
  updateMaxHeight() {
    var _a;
    const scrollHeight = (_a = this.contentPreview) == null ? void 0 : _a.scrollHeight.toString();
    this.style.setProperty("--max-height-pixel", `${scrollHeight}px`);
    this.style.setProperty("--max-height", scrollHeight);
  }
  onToggleClick() {
    this.updateMaxHeight();
    this.open = !this.open;
  }
  onOpenChange() {
    if (this.open) {
      this.emit("sd-show");
      this.updateComplete.then(() => {
        this.emit("sd-after-show");
      });
    } else {
      this.emit("sd-hide");
      this.updateComplete.then(() => {
        this.emit("sd-after-hide");
      });
    }
    this.details.setAttribute("open", this.open.toString());
  }
  /** Opens the expandable */
  async show() {
    if (this.open) {
      return void 0;
    }
    this.onToggleClick();
    return waitForEvent(this, "sd-after-show");
  }
  /** Closes the expandable */
  async hide() {
    if (!this.open) {
      return void 0;
    }
    this.onToggleClick();
    return waitForEvent(this, "sd-after-hide");
  }
  render() {
    return html`<div part="base" class="flex flex-col-reverse gap-4"><button part="toggle" class="${cx(
      "sd-interactive sd-interactive--reset",
      this.inverted && "sd-interactive--inverted",
      !this.inverted ? "!focus-visible:focus-outline" : "!focus-visible:focus-outline-inverted"
    )}" @click="${this.onToggleClick}" aria-expanded="${this.open}"><div class="${cx("h-full justify-center w-full text-base flex items-center toggle")}">${this.open ? html`<slot name="toggle-open"><sd-icon class="mr-2 text-xl" library="system" name="chevron-up"></sd-icon>${this.localize.term("showLess")}</slot>` : html`<slot name="toggle-closed"><sd-icon class="mr-2 text-xl" library="system" name="chevron-down"></sd-icon>${this.localize.term("showMore")}</slot>`}</div></button><details part="details" aria-hidden="${!this.open}"><summary part="summary" aria-hidden="true" class="cursor-pointer overflow-hidden list-none"><slot name="clone"></slot></summary><div part="content" class="content content-preview overflow-hidden relative"><slot></slot></div></details></div>`;
  }
  firstUpdated() {
    this.cloneContentToLightDOM();
    this.details.setAttribute("open", this.open.toString());
  }
  cloneContentToLightDOM() {
    const slot = document.createElement("div");
    slot.setAttribute("slot", "clone");
    const nodes = Array.from(this.childNodes);
    nodes.forEach((node) => {
      const clone = node.cloneNode(true);
      slot.appendChild(clone);
    });
    this.appendChild(slot);
  }
};
SdExpandable.styles = [
  ...SolidElement.styles,
  css`:host{--gradient-color-start:hsla(0,0%,100%,0);--gradient-color-end:#fff;--component-expandable-max-block-size:90px;--gradient-height:24px;--gradient:var(--gradient-color-start) 0%,var(--gradient-color-end) 80%,var(--gradient-color-end) 100%;display:inline-block;position:relative;width:100%}.toggle::-moz-focus-inner{border-style:none;padding:var(--sd-spacing-0,0)}details>summary::-webkit-details-marker,details[open] summary{display:none}summary{max-block-size:var(--component-expandable-max-block-size)}:host([open]) summary{max-block-size:var(--max-height-pixel,1000vh)}.content{max-block-size:var(--component-expandable-max-block-size)}:host([open]) .content{max-block-size:var(--max-height-pixel,1000vh)}:host(:not([open])) .content:after{background:linear-gradient(180deg,var(--gradient));bottom:var(--sd-spacing-0,0);content:" ";display:block;height:var(--gradient-height);left:var(--sd-spacing-0,0);position:absolute;width:100%}:host([inverted]:not([open])) .content:after{background:var(--gradient-vertical-transparent-primary,linear-gradient(180deg,rgba(0,53,142,0) 0,#00358e 80%,#00358e 100%))}`
];
__decorateClass([
  query(".content-preview")
], SdExpandable.prototype, "contentPreview", 2);
__decorateClass([
  query("details")
], SdExpandable.prototype, "details", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdExpandable.prototype, "open", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdExpandable.prototype, "inverted", 2);
__decorateClass([
  watch("open", { waitUntilFirstUpdate: true })
], SdExpandable.prototype, "onOpenChange", 1);
SdExpandable = __decorateClass([
  customElement("sd-expandable")
], SdExpandable);

export {
  SdExpandable
};
