import {
  __decorateClass,
  __spreadValues
} from "./chunk.S3NI7NKU.js";

// src/internal/register-custom-element.ts
var legacyCustomElement = (tagName, clazz) => {
  if (window.customElements.get(tagName)) {
    console.warn(`Custom element ${tagName} already defined. Registration skipped.`);
    return clazz;
  }
  window.customElements.define(tagName, clazz);
  return clazz;
};
var standardCustomElement = (tagName, descriptor) => {
  const { kind, elements } = descriptor;
  return {
    kind,
    elements,
    // This callback is called once the class is otherwise fully defined
    finisher(clazz) {
      if (window.customElements.get(tagName)) {
        console.warn(`Custom element ${tagName} already defined. Registration skipped.`);
        return;
      }
      window.customElements.define(tagName, clazz);
    }
  };
};
var customElement = (tagName) => (classOrDescriptor) => (
  // eslint-disable-next-line @typescript-eslint/no-unsafe-return
  typeof classOrDescriptor === "function" ? legacyCustomElement(tagName, classOrDescriptor) : standardCustomElement(tagName, classOrDescriptor)
);

// src/internal/solid-element.ts
import { LitElement, unsafeCSS } from "lit";
import { property } from "lit/decorators.js";
var css = unsafeCSS;
var SolidElement = class extends LitElement {
  /** Emits a custom event with more convenient defaults. */
  emit(name, options) {
    const event = new CustomEvent(name, __spreadValues({
      bubbles: true,
      cancelable: false,
      composed: true,
      detail: {}
    }, options));
    this.dispatchEvent(event);
    return event;
  }
};
SolidElement.styles = [
  css`.sd-interactive--reset,.sd-prose a--reset{all:unset;outline:revert}.sd-interactive,.sd-prose a{cursor:pointer;--tw-text-opacity:1;color:rgb(var(--sd-color-primary,0 53 142)/var(--tw-text-opacity,1));text-decoration-line:underline;transition-duration:.15s;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke;transition-timing-function:cubic-bezier(.4,0,.2,1)}.sd-interactive:hover:not([disabled]),.sd-prose a:hover:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-500,70 109 175)/var(--tw-text-opacity,1))}.sd-interactive:active:not([disabled]),.sd-prose a:active:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-800,5 21 48)/var(--tw-text-opacity,1))}.sd-interactive:is(.sd-interactive),.sd-prose a:is(.sd-interactive){text-decoration-line:none}.sd-interactive:focus-visible,.sd-prose a:focus-visible{outline-color:rgb(var(--sd-color-primary,0 53 142)/1);outline-offset:2px;outline-style:solid;outline-width:2px}.sd-interactive--disabled,.sd-interactive[disabled],.sd-interactive[href=""],.sd-prose a--disabled,.sd-prose a[disabled],.sd-prose a[href=""]{cursor:not-allowed;--tw-text-opacity:1;color:rgb(var(--sd-color-neutral-600,136 136 136)/var(--tw-text-opacity,1))}.sd-interactive--disabled:active:not([disabled]),.sd-interactive--disabled:hover:not([disabled]),.sd-interactive[disabled]:active:not([disabled]),.sd-interactive[disabled]:hover:not([disabled]),.sd-interactive[href=""]:active:not([disabled]),.sd-interactive[href=""]:hover:not([disabled]),.sd-prose a--disabled:active:not([disabled]),.sd-prose a--disabled:hover:not([disabled]),.sd-prose a[disabled]:active:not([disabled]),.sd-prose a[disabled]:hover:not([disabled]),.sd-prose a[href=""]:active:not([disabled]),.sd-prose a[href=""]:hover:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-neutral-600,136 136 136)/var(--tw-text-opacity,1))}.sd-interactive--inverted,.sd-prose--inverted a{--tw-text-opacity:1;color:rgb(var(--sd-color-white,255 255 255)/var(--tw-text-opacity,1))}.sd-interactive--inverted:hover:not([disabled]),.sd-prose--inverted a:hover:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-200,224 233 243)/var(--tw-text-opacity,1))}.sd-interactive--inverted:active:not([disabled]),.sd-prose--inverted a:active:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-400,153 171 208)/var(--tw-text-opacity,1))}.sd-interactive--inverted:focus-visible,.sd-prose--inverted a:focus-visible{outline-color:rgb(var(--sd-color-white,255 255 255)/1);outline-offset:2px;outline-style:solid;outline-width:2px}.sd-paragraph,.sd-prose p{font-size:var(--sd-font-size-base,1rem)}.sd-paragraph,.sd-paragraph--size-sm,.sd-prose p,.sd-prose p--size-sm{font-weight:400;line-height:var(--sd-line-height-normal,150%);--tw-text-opacity:1;color:rgb(var(--sd-color-black,24 24 24)/var(--tw-text-opacity,1))}.sd-paragraph--size-sm,.sd-prose p--size-sm{font-size:var(--sd-font-size-sm,.875rem)}.sd-paragraph--inverted,.sd-prose--inverted p{--tw-text-opacity:1;color:rgb(var(--sd-color-white,255 255 255)/var(--tw-text-opacity,1))}.sd-headline,.sd-prose :is(h1,h2,h3,h4,h5){display:flex;font-weight:700;--tw-text-opacity:1;color:rgb(var(--sd-color-primary,0 53 142)/var(--tw-text-opacity,1))}.sd-headline sd-icon,.sd-prose :is(h1,h2,h3,h4,h5) sd-icon{flex-shrink:0;font-size:3rem;--tw-text-opacity:1;color:rgb(var(--sd-color-primary,0 53 142)/var(--tw-text-opacity,1))}@media (min-width:640px){.sd-headline sd-icon,.sd-prose :is(h1,h2,h3,h4,h5) sd-icon{margin-top:var(--sd-spacing-2,.5rem)}}.sd-headline.sd-headline,.sd-headline:is(h1):not(.sd-headline),.sd-prose :is(h1,h2,h3,h4,h5).sd-headline,.sd-prose :is(h1,h2,h3,h4,h5):is(h1):not(.sd-headline){font-size:var(--sd-font-size-3xl,2rem);gap:var(--sd-spacing-4,1rem);line-height:var(--sd-line-height-tight,120%)}@media (min-width:640px){.sd-headline.sd-headline,.sd-headline:is(h1):not(.sd-headline),.sd-prose :is(h1,h2,h3,h4,h5).sd-headline,.sd-prose :is(h1,h2,h3,h4,h5):is(h1):not(.sd-headline){font-size:var(--sd-font-size-4xl,2.5rem)}}.sd-headline.sd-headline sd-icon,.sd-headline:is(h1):not(.sd-headline) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h1):not(.sd-headline) sd-icon{margin-top:calc(var(--sd-spacing-1,.25rem)*-1)}@media (min-width:640px){.sd-headline.sd-headline sd-icon,.sd-headline:is(h1):not(.sd-headline) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h1):not(.sd-headline) sd-icon{margin-top:var(--sd-spacing-0,0)}}.sd-headline.sd-headline--size-3xl,.sd-headline:is(h2):not(.sd-headline),.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-3xl,.sd-prose :is(h1,h2,h3,h4,h5):is(h2):not(.sd-headline){font-size:var(--sd-font-size-2xl,1.75rem);gap:var(--sd-spacing-4,1rem);line-height:var(--sd-line-height-tight,120%)}@media (min-width:640px){.sd-headline.sd-headline--size-3xl,.sd-headline:is(h2):not(.sd-headline),.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-3xl,.sd-prose :is(h1,h2,h3,h4,h5):is(h2):not(.sd-headline){font-size:var(--sd-font-size-3xl,2rem)}}.sd-headline.sd-headline--size-3xl sd-icon,.sd-headline:is(h2):not(.sd-headline) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-3xl sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h2):not(.sd-headline) sd-icon{margin-top:calc(var(--sd-spacing-1,.25rem)*-1)}@media (min-width:640px){.sd-headline.sd-headline--size-3xl sd-icon,.sd-headline:is(h2):not(.sd-headline) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-3xl sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h2):not(.sd-headline) sd-icon{margin-top:var(--sd-spacing-0,0)}}.sd-headline.sd-headline--size-base,.sd-headline.sd-headline--size-lg,.sd-headline.sd-headline--size-xl,.sd-headline:is(h3,h4,h5):not(.sd-headline),.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-base,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-lg,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-xl,.sd-prose :is(h1,h2,h3,h4,h5):is(h3,h4,h5):not(.sd-headline){gap:var(--sd-spacing-2,.5rem);--tw-text-opacity:1;color:rgb(var(--sd-color-black,24 24 24)/var(--tw-text-opacity,1))}.sd-headline.sd-headline--size-base sd-icon,.sd-headline.sd-headline--size-lg sd-icon,.sd-headline.sd-headline--size-xl sd-icon,.sd-headline:is(h3,h4,h5):not(.sd-headline) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-base sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-lg sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-xl sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h3,h4,h5):not(.sd-headline) sd-icon{font-size:2rem}.sd-headline.sd-headline--size-xl,.sd-headline:is(h3):not(.sd-headline),.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-xl,.sd-prose :is(h1,h2,h3,h4,h5):is(h3):not(.sd-headline){font-size:var(--sd-font-size-xl,1.5rem)}.sd-headline.sd-headline--size-xl sd-icon,.sd-headline:is(h3):not(.sd-headline) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-xl sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h3):not(.sd-headline) sd-icon{margin-top:var(--sd-spacing-0-5,.125rem)}@media (min-width:640px){.sd-headline.sd-headline--size-xl sd-icon,.sd-headline:is(h3):not(.sd-headline) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-xl sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h3):not(.sd-headline) sd-icon{margin-top:var(--sd-spacing-0-5,.125rem)}}.sd-headline.sd-headline--size-base,.sd-headline.sd-headline--size-lg,.sd-headline:is(h4,h5):not(.sd-headline),.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-base,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-lg,.sd-prose :is(h1,h2,h3,h4,h5):is(h4,h5):not(.sd-headline){line-height:var(--sd-line-height-normal,150%)}.sd-headline.sd-headline--size-lg,.sd-headline:is(h4),.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-lg,.sd-prose :is(h1,h2,h3,h4,h5):is(h4){font-size:var(--sd-font-size-lg,1.25rem)}.sd-headline.sd-headline--size-lg sd-icon,.sd-headline:is(h4) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-lg sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h4) sd-icon{margin-top:var(--sd-spacing-0,0)}@media (min-width:640px){.sd-headline.sd-headline--size-lg sd-icon,.sd-headline:is(h4) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-lg sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h4) sd-icon{margin-top:var(--sd-spacing-0,0)}}.sd-headline.sd-headline--size-base,.sd-headline:is(h5):not(.sd-headline),.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-base,.sd-prose :is(h1,h2,h3,h4,h5):is(h5):not(.sd-headline){font-size:var(--sd-font-size-base,1rem)}.sd-headline.sd-headline--size-base sd-icon,.sd-headline:is(h5):not(.sd-headline) sd-icon,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-base sd-icon,.sd-prose :is(h1,h2,h3,h4,h5):is(h5):not(.sd-headline) sd-icon{margin-top:calc(var(--sd-spacing-1,.25rem)*-1)}.sd-headline.sd-headline--size-base mark,.sd-headline:is(h5):not(.sd-headline) mark,.sd-prose :is(h1,h2,h3,h4,h5).sd-headline--size-base mark,.sd-prose :is(h1,h2,h3,h4,h5):is(h5):not(.sd-headline) mark{color:inherit}.sd-headline--inline{display:inline-block}.sd-headline--inline sd-icon{margin-right:var(--sd-spacing-2,.5rem);margin-top:calc(var(--sd-spacing-1,.25rem)*-1);vertical-align:middle}.sd-headline--inline:is(.sd-headline--size-xl,.sd-headline--size-lg,.sd-headline--size-base) sd-icon{margin-right:var(--sd-spacing-0-5,.125rem)}.sd-headline--inverted:not(#_),.sd-prose--inverted :is(h1,h2,h3,h4,h5):not(.sd-headline):not(#_){--tw-text-opacity:1;color:rgb(var(--sd-color-white,255 255 255)/var(--tw-text-opacity,1))}.sd-headline--inverted:not(#_) sd-icon,.sd-prose--inverted :is(h1,h2,h3,h4,h5):not(.sd-headline):not(#_) sd-icon{--tw-text-opacity:1;color:rgb(var(--sd-color-white,255 255 255)/var(--tw-text-opacity,1))}*,:after,:before{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-scroll-snap-strictness:proximity;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgba(147,197,253,.5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000}::backdrop{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-scroll-snap-strictness:proximity;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgba(147,197,253,.5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000}/*! tailwindcss v3.4.17 | MIT License | https://tailwindcss.com*/*,:after,:before{border:0 solid;box-sizing:border-box}:after,:before{--tw-content:""}:host,html{line-height:1.5;-webkit-text-size-adjust:100%;-moz-tab-size:4;-o-tab-size:4;tab-size:4;-webkit-tap-highlight-color:transparent}body{line-height:inherit;margin:0}hr{border-top-width:1px;color:inherit;height:0}abbr:where([title]){-webkit-text-decoration:underline dotted;text-decoration:underline dotted}h1,h2,h3,h4,h5,h6{font-size:inherit;font-weight:inherit}a{color:inherit;text-decoration:inherit}b,strong{font-weight:bolder}code,kbd,pre,samp{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-feature-settings:normal;font-size:1em;font-variation-settings:normal}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}table{border-collapse:collapse;border-color:inherit;text-indent:0}button,input,optgroup,select,textarea{color:inherit;font-family:inherit;font-feature-settings:inherit;font-size:100%;font-variation-settings:inherit;font-weight:inherit;letter-spacing:inherit;line-height:inherit;margin:0;padding:0}button,select{text-transform:none}button,input:where([type=button]),input:where([type=reset]),input:where([type=submit]){-webkit-appearance:button;background-color:transparent;background-image:none}:-moz-focusring{outline:auto}:-moz-ui-invalid{box-shadow:none}progress{vertical-align:baseline}::-webkit-inner-spin-button,::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}summary{display:list-item}blockquote,dd,dl,figure,h1,h2,h3,h4,h5,h6,hr,p,pre{margin:0}fieldset{margin:0}fieldset,legend{padding:0}menu,ol,ul{list-style:none;margin:0;padding:0}dialog{padding:0}textarea{resize:vertical}input::-moz-placeholder,textarea::-moz-placeholder{color:#9ca3af;opacity:1}input::placeholder,textarea::placeholder{color:#9ca3af;opacity:1}[role=button],button{cursor:pointer}:disabled{cursor:default}audio,canvas,embed,iframe,img,object,svg,video{display:block;vertical-align:middle}img,video{height:auto;max-width:100%}[hidden]:where(:not([hidden=until-found])){display:none}.\\!container{width:100%!important}.container{width:100%}@media (min-width:640px){.\\!container{max-width:640px!important}.container{max-width:640px}}@media (min-width:768px){.\\!container{max-width:768px!important}.container{max-width:768px}}@media (min-width:1024px){.\\!container{max-width:1024px!important}.container{max-width:1024px}}@media (min-width:1280px){.\\!container{max-width:1280px!important}.container{max-width:1280px}}@media (min-width:1536px){.\\!container{max-width:1536px!important}.container{max-width:1536px}}.sr-only{height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px;clip:rect(0,0,0,0);border-width:0;white-space:nowrap}.pointer-events-none{pointer-events:none}.pointer-events-auto{pointer-events:auto}.visible{visibility:visible}.invisible{visibility:hidden}.collapse{visibility:collapse}.static{position:static}.fixed{position:fixed}.\\!absolute{position:absolute!important}.absolute{position:absolute}.relative{position:relative}.inset-0{inset:var(--sd-spacing-0,0)}.\\!right-0{right:var(--sd-spacing-0,0)!important}.-top-0\\.25{top:calc(var(--sd-spacing-0-25,1px)*-1)}.-top-4{top:calc(var(--sd-spacing-4,1rem)*-1)}.bottom-0{bottom:var(--sd-spacing-0,0)}.bottom-auto{bottom:var(--sd-spacing-auto,auto)}.end-0{inset-inline-end:var(--sd-spacing-0,0)}.end-auto{inset-inline-end:var(--sd-spacing-auto,auto)}.left-0{left:var(--sd-spacing-0,0)}.left-1\\/2{left:50%}.left-auto{left:var(--sd-spacing-auto,auto)}.right-0{right:var(--sd-spacing-0,0)}.right-2{right:var(--sd-spacing-2,.5rem)}.right-4{right:var(--sd-spacing-4,1rem)}.right-auto{right:var(--sd-spacing-auto,auto)}.start-0{inset-inline-start:var(--sd-spacing-0,0)}.start-auto{inset-inline-start:var(--sd-spacing-auto,auto)}.top-0{top:var(--sd-spacing-0,0)}.top-1{top:var(--sd-spacing-1,.25rem)}.top-1\\/2{top:50%}.top-2{top:var(--sd-spacing-2,.5rem)}.top-full{top:100%}.isolate{isolation:isolate}.-z-10{z-index:-10}.-z-20{z-index:-20}.z-10{z-index:10}.z-20{z-index:20}.z-30{z-index:30}.z-50{z-index:50}.z-dialog{z-index:var(--sd-z-index-dialog,800)}.z-dropdown{z-index:var(--sd-z-index-dropdown,900)}.\\!m-0{margin:var(--sd-spacing-0,0)!important}.m-0{margin:var(--sd-spacing-0,0)}.m-2{margin:var(--sd-spacing-2,.5rem)}.m-4{margin:var(--sd-spacing-4,1rem)}.mx-\\[-1px\\]{margin-left:-1px;margin-right:-1px}.mx-auto{margin-left:var(--sd-spacing-auto,auto);margin-right:var(--sd-spacing-auto,auto)}.my-0{margin-bottom:var(--sd-spacing-0,0);margin-top:var(--sd-spacing-0,0)}.my-auto{margin-bottom:var(--sd-spacing-auto,auto);margin-top:var(--sd-spacing-auto,auto)}.\\!ml-6{margin-left:var(--sd-spacing-6,1.5rem)!important}.\\!mr-6{margin-right:var(--sd-spacing-6,1.5rem)!important}.mb-2{margin-bottom:var(--sd-spacing-2,.5rem)}.mb-4{margin-bottom:var(--sd-spacing-4,1rem)}.mb-6{margin-bottom:var(--sd-spacing-6,1.5rem)}.mb-auto{margin-bottom:var(--sd-spacing-auto,auto)}.ml-1{margin-left:var(--sd-spacing-1,.25rem)}.ml-2{margin-left:var(--sd-spacing-2,.5rem)}.ml-3{margin-left:var(--sd-spacing-3,.75rem)}.ml-4{margin-left:var(--sd-spacing-4,1rem)}.ml-6{margin-left:var(--sd-spacing-6,1.5rem)}.ml-\\[0\\.25em\\]{margin-left:.25em}.ml-\\[0\\.5em\\]{margin-left:.5em}.ml-auto{margin-left:var(--sd-spacing-auto,auto)}.mr-1{margin-right:var(--sd-spacing-1,.25rem)}.mr-2{margin-right:var(--sd-spacing-2,.5rem)}.mr-4{margin-right:var(--sd-spacing-4,1rem)}.mr-6{margin-right:var(--sd-spacing-6,1.5rem)}.mr-\\[0\\.25em\\]{margin-right:.25em}.mr-\\[0\\.5em\\]{margin-right:.5em}.mt-0\\.25{margin-top:var(--sd-spacing-0-25,1px)}.mt-1{margin-top:var(--sd-spacing-1,.25rem)}.mt-2{margin-top:var(--sd-spacing-2,.5rem)}.mt-3{margin-top:var(--sd-spacing-3,.75rem)}.mt-4{margin-top:var(--sd-spacing-4,1rem)}.mt-\\[-1px\\]{margin-top:-1px}.mt-\\[2px\\]{margin-top:2px}.mt-\\[3px\\]{margin-top:3px}.mt-auto{margin-top:var(--sd-spacing-auto,auto)}.box-border{box-sizing:border-box}.block{display:block}.inline-block{display:inline-block}.inline{display:inline}.flex{display:flex}.inline-flex{display:inline-flex}.grid{display:grid}.contents{display:contents}.\\!hidden{display:none!important}.hidden{display:none}.aspect-square{aspect-ratio:1/1}.h-0\\.25{height:var(--sd-spacing-0-25,1px)}.h-1{height:var(--sd-spacing-1,.25rem)}.h-10{height:var(--sd-spacing-10,2.5rem)}.h-12{height:var(--sd-spacing-12,3rem)}.h-16{height:var(--sd-spacing-16,4rem)}.h-2{height:var(--sd-spacing-2,.5rem)}.h-2\\.5{height:var(--sd-spacing-2-5,.625rem)}.h-3{height:var(--sd-spacing-3,.75rem)}.h-4{height:var(--sd-spacing-4,1rem)}.h-5{height:var(--sd-spacing-5,1.25rem)}.h-6{height:var(--sd-spacing-6,1.5rem)}.h-8{height:var(--sd-spacing-8,2rem)}.h-\\[0px\\]{height:0}.h-\\[1px\\]{height:1px}.h-\\[2px\\]{height:2px}.h-\\[48px\\]{height:48px}.h-\\[6px\\]{height:6px}.h-\\[96px\\]{height:96px}.h-\\[calc\\(100\\%-16px\\)\\]{height:calc(100% - 16px)}.h-\\[calc\\(100\\%-8px\\)\\]{height:calc(100% - 8px)}.h-full{height:100%}.h-varspacing{height:var(--tw-varspacing)}.max-h-full{max-height:100%}.min-h-\\[32px\\]{min-height:32px}.min-h-\\[40px\\]{min-height:40px}.min-h-\\[48px\\]{min-height:48px}.w-0{width:var(--sd-spacing-0,0)}.w-1{width:var(--sd-spacing-1,.25rem)}.w-12{width:var(--sd-spacing-12,3rem)}.w-16{width:var(--sd-spacing-16,4rem)}.w-2\\.5{width:var(--sd-spacing-2-5,.625rem)}.w-3{width:var(--sd-spacing-3,.75rem)}.w-3\\/4{width:75%}.w-4{width:var(--sd-spacing-4,1rem)}.w-40{width:var(--sd-spacing-40,10rem)}.w-5{width:var(--sd-spacing-5,1.25rem)}.w-6{width:var(--sd-spacing-6,1.5rem)}.w-8{width:var(--sd-spacing-8,2rem)}.w-\\[--width\\]{width:var(--width)}.w-\\[1px\\]{width:1px}.w-\\[48px\\]{width:48px}.w-\\[6px\\]{width:6px}.w-\\[72px\\]{width:72px}.w-\\[96px\\]{width:96px}.w-auto{width:var(--sd-spacing-auto,auto)}.w-full{width:100%}.w-max{width:-moz-max-content;width:max-content}.w-min{width:-moz-min-content;width:min-content}.w-varspacing{width:var(--tw-varspacing)}.min-w-0{min-width:var(--sd-spacing-0,0)}.min-w-2{min-width:var(--sd-spacing-2,.5rem)}.min-w-4{min-width:var(--sd-spacing-4,1rem)}.min-w-5{min-width:var(--sd-spacing-5,1.25rem)}.min-w-max{min-width:-moz-max-content;min-width:max-content}.min-w-min{min-width:-moz-min-content;min-width:min-content}.max-w-full{max-width:100%}.flex-1{flex:1 1 0%}.flex-\\[0_0_auto\\]{flex:0 0 auto}.flex-auto{flex:1 1 auto}.flex-initial{flex:0 1 auto}.flex-shrink-0{flex-shrink:0}.shrink{flex-shrink:1}.shrink-0{flex-shrink:0}.flex-grow{flex-grow:1}.flex-grow-0{flex-grow:0}.grow{flex-grow:1}.basis-auto{flex-basis:var(--sd-spacing-auto,auto)}.origin-bottom{transform-origin:bottom}.origin-top{transform-origin:top}.\\!-translate-x-1\\/2{--tw-translate-x:-50%!important}.\\!-translate-x-1\\/2,.\\!-translate-y-1\\/2{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))!important}.\\!-translate-y-1\\/2{--tw-translate-y:-50%!important}.\\!translate-x-1\\/2{--tw-translate-x:50%!important;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))!important}.-translate-x-1\\/2{--tw-translate-x:-50%}.-translate-x-1\\/2,.-translate-x-2{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.-translate-x-2{--tw-translate-x:calc(var(--sd-spacing-2, 0.5rem)*-1)}.-translate-y-1\\/2{--tw-translate-y:-50%}.-translate-y-1\\/2,.translate-x-2{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.translate-x-2{--tw-translate-x:var(--sd-spacing-2,0.5rem)}.rotate-0{--tw-rotate:0deg}.rotate-0,.rotate-180{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.rotate-180{--tw-rotate:180deg}.rotate-45{--tw-rotate:45deg}.rotate-45,.rotate-90{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.rotate-90{--tw-rotate:90deg}.rotate-\\[-90deg\\]{--tw-rotate:-90deg}.rotate-\\[-90deg\\],.rotate-\\[270deg\\]{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.rotate-\\[270deg\\]{--tw-rotate:270deg}.scale-110{--tw-scale-x:1.1;--tw-scale-y:1.1}.scale-110,.scale-y-\\[1\\.5\\]{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scale-y-\\[1\\.5\\]{--tw-scale-y:1.5}.transform{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}@keyframes bounce-once{0%{transform:translateY(0)}15%{transform:translateY(-9px)}25%{transform:translateY(-12px)}40%{transform:translateY(-4px)}50%{transform:translateY(0)}65%{transform:translateY(-4px)}75%{transform:translateY(-6px)}90%{transform:translateY(-2px)}to{transform:translateY(0)}}.animate-bounce-once{animation:bounce-once .6s ease-in-out}@keyframes grow{0%{width:0}to{width:100%}}.animate-grow{animation:grow linear}@keyframes spin{to{transform:rotate(1turn)}}.animate-spin{animation:spin 1s linear infinite}.\\!cursor-not-allowed{cursor:not-allowed!important}.cursor-\\[inherit\\]{cursor:inherit}.cursor-default{cursor:default}.cursor-not-allowed{cursor:not-allowed}.cursor-pointer{cursor:pointer}.cursor-wait{cursor:wait}.select-none{-webkit-user-select:none;-moz-user-select:none;user-select:none}.resize-none{resize:none}.resize{resize:both}.snap-x{scroll-snap-type:x var(--tw-scroll-snap-strictness)}.snap-mandatory{--tw-scroll-snap-strictness:mandatory}.list-none{list-style-type:none}.appearance-none{-webkit-appearance:none;-moz-appearance:none;appearance:none}.grid-flow-col{grid-auto-flow:column}.auto-rows-\\[100\\%\\]{grid-auto-rows:100%}.grid-cols-3{grid-template-columns:repeat(3,minmax(0,1fr))}.flex-row{flex-direction:row}.flex-col{flex-direction:column}.flex-col-reverse{flex-direction:column-reverse}.flex-wrap{flex-wrap:wrap}.place-items-center{place-items:center}.items-start{align-items:flex-start}.items-center{align-items:center}.items-stretch{align-items:stretch}.justify-end{justify-content:flex-end}.justify-center{justify-content:center}.justify-between{justify-content:space-between}.justify-stretch{justify-content:stretch}.justify-items-center{justify-items:center}.gap-0\\.5{gap:var(--sd-spacing-0-5,.125rem)}.gap-1{gap:var(--sd-spacing-1,.25rem)}.gap-2{gap:var(--sd-spacing-2,.5rem)}.gap-3{gap:var(--sd-spacing-3,.75rem)}.gap-4{gap:var(--sd-spacing-4,1rem)}.gap-6{gap:var(--sd-spacing-6,1.5rem)}.gap-8{gap:var(--sd-spacing-8,2rem)}.gap-x-\\[1px\\]{-moz-column-gap:1px;column-gap:1px}.self-start{align-self:flex-start}.self-center{align-self:center}.justify-self-start{justify-self:start}.justify-self-end{justify-self:end}.overflow-auto{overflow:auto}.overflow-hidden{overflow:hidden}.overflow-x-auto{overflow-x:auto}.overflow-y-auto{overflow-y:auto}.overflow-x-hidden{overflow-x:hidden}.overflow-y-hidden{overflow-y:hidden}.overflow-x-scroll{overflow-x:scroll}.overflow-y-scroll{overflow-y:scroll}.overscroll-x-contain{overscroll-behavior-x:contain}.scroll-auto{scroll-behavior:auto}.whitespace-nowrap{white-space:nowrap}.break-words{overflow-wrap:break-word}.\\!rounded-sm{border-radius:var(--sd-border-radius-sm,.125rem)!important}.rounded-\\[4px_4px_0_0\\]{border-radius:4px 4px 0 0}.rounded-default{border-radius:var(--sd-border-radius-default,.25rem)}.rounded-full{border-radius:var(--sd-border-radius-full,9999px)}.rounded-md{border-radius:var(--sd-border-radius-md,.375rem)}.rounded-none{border-radius:var(--sd-border-radius-none,0)}.rounded-sm{border-radius:var(--sd-border-radius-sm,.125rem)}.rounded-b-default{border-bottom-left-radius:var(--sd-border-radius-default,.25rem);border-bottom-right-radius:var(--sd-border-radius-default,.25rem)}.rounded-b-none{border-bottom-left-radius:var(--sd-border-radius-none,0);border-bottom-right-radius:var(--sd-border-radius-none,0)}.rounded-bl-default{border-bottom-left-radius:var(--sd-border-radius-default,.25rem)}.rounded-bl-none{border-bottom-left-radius:var(--sd-border-radius-none,0)}.rounded-br-default{border-bottom-right-radius:var(--sd-border-radius-default,.25rem)}.rounded-br-none{border-bottom-right-radius:var(--sd-border-radius-none,0)}.rounded-tl-default{border-top-left-radius:var(--sd-border-radius-default,.25rem)}.rounded-tl-none{border-top-left-radius:var(--sd-border-radius-none,0)}.rounded-tr-default{border-top-right-radius:var(--sd-border-radius-default,.25rem)}.rounded-tr-none{border-top-right-radius:var(--sd-border-radius-none,0)}.border{border-width:1px}.border-0{border-width:0}.border-2{border-width:2px}.border-\\[0\\.25px\\]{border-width:.25px}.border-\\[1px\\]{border-width:1px}.border-y{border-top-width:1px}.border-b,.border-y{border-bottom-width:1px}.border-b-2{border-bottom-width:2px}.border-l{border-left-width:1px}.border-l-0{border-left-width:0}.border-l-2{border-left-width:2px}.border-l-4{border-left-width:4px}.border-r-2{border-right-width:2px}.border-t{border-top-width:1px}.border-t-0{border-top-width:0}.border-t-2{border-top-width:2px}.border-solid{border-style:solid}.border-none{border-style:none}.border-accent{--tw-border-opacity:1;border-color:rgb(var(--sd-color-accent,45 157 0)/var(--tw-border-opacity,1))}.border-error{--tw-border-opacity:1;border-color:rgb(var(--sd-color-error,204 25 55)/var(--tw-border-opacity,1))}.border-neutral-400{--tw-border-opacity:1;border-color:rgb(var(--sd-color-neutral-400,195 195 195)/var(--tw-border-opacity,1))}.border-neutral-500{--tw-border-opacity:1;border-color:rgb(var(--sd-color-neutral-500,174 174 174)/var(--tw-border-opacity,1))}.border-neutral-800{--tw-border-opacity:1;border-color:rgb(var(--sd-color-neutral-800,81 81 81)/var(--tw-border-opacity,1))}.border-primary{--tw-border-opacity:1;border-color:rgb(var(--sd-color-primary,0 53 142)/var(--tw-border-opacity,1))}.border-primary-400{--tw-border-opacity:1;border-color:rgb(var(--sd-color-primary-400,153 171 208)/var(--tw-border-opacity,1))}.border-success{--tw-border-opacity:1;border-color:rgb(var(--sd-color-success,37 136 14)/var(--tw-border-opacity,1))}.border-transparent{border-color:transparent}.border-white{--tw-border-opacity:1;border-color:rgb(var(--sd-color-white,255 255 255)/var(--tw-border-opacity,1))}.bg-accent{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-accent,45 157 0)/var(--tw-bg-opacity,1))}.bg-accent-500{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-accent-500,37 136 14)/var(--tw-bg-opacity,1))}.bg-error{background-color:rgb(var(--sd-color-error,204 25 55)/var(--tw-bg-opacity,1))}.bg-error,.bg-info{--tw-bg-opacity:1}.bg-info{background-color:rgb(var(--sd-color-info,21 130 213)/var(--tw-bg-opacity,1))}.bg-neutral-100{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-100,246 246 246)/var(--tw-bg-opacity,1))}.bg-neutral-100\\/\\[\\.8\\]{background-color:rgb(var(--sd-color-neutral-100,246 246 246)/.8)}.bg-neutral-200{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-200,233 233 233)/var(--tw-bg-opacity,1))}.bg-neutral-500{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-500,174 174 174)/var(--tw-bg-opacity,1))}.bg-neutral-800{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-800,81 81 81)/var(--tw-bg-opacity,1))}.bg-neutral-800\\/75{background-color:rgb(var(--sd-color-neutral-800,81 81 81)/var(--sd-opacity-75,.75))}.bg-primary{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary,0 53 142)/var(--tw-bg-opacity,1))}.bg-primary-100{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-100,236 240 249)/var(--tw-bg-opacity,1))}.bg-primary-100\\/\\[\\.8\\]{background-color:rgb(var(--sd-color-primary-100,236 240 249)/.8)}.bg-primary-500{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-500,70 109 175)/var(--tw-bg-opacity,1))}.bg-primary-800{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-800,5 21 48)/var(--tw-bg-opacity,1))}.bg-primary\\/\\[\\.8\\]{background-color:rgb(var(--sd-color-primary,0 53 142)/.8)}.bg-success{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-success,37 136 14)/var(--tw-bg-opacity,1))}.bg-transparent{background-color:transparent}.bg-warning{background-color:rgb(var(--sd-color-warning,187 141 32)/var(--tw-bg-opacity,1))}.bg-warning,.bg-white{--tw-bg-opacity:1}.bg-white{background-color:rgb(var(--sd-color-white,255 255 255)/var(--tw-bg-opacity,1))}.bg-white\\/\\[\\.8\\]{background-color:rgb(var(--sd-color-white,255 255 255)/.8)}.bg-opacity-75{--tw-bg-opacity:var(--sd-opacity-75,0.75)}.bg-gradient-to-b{background-image:linear-gradient(to bottom,var(--tw-gradient-stops))}.bg-gradient-to-t{background-image:linear-gradient(to top,var(--tw-gradient-stops))}.bg-none{background-image:none}.from-primary-800\\/60{--tw-gradient-from:rgb(var(--sd-color-primary-800,5 21 48)/var(--sd-opacity-60,0.6)) var(--tw-gradient-from-position);--tw-gradient-to:hsla(0,0%,100%,0) var(--tw-gradient-to-position);--tw-gradient-stops:var(--tw-gradient-from),var(--tw-gradient-to)}.from-primary-800\\/75{--tw-gradient-from:rgb(var(--sd-color-primary-800,5 21 48)/var(--sd-opacity-75,0.75)) var(--tw-gradient-from-position);--tw-gradient-to:hsla(0,0%,100%,0) var(--tw-gradient-to-position);--tw-gradient-stops:var(--tw-gradient-from),var(--tw-gradient-to)}.from-primary-800\\/\\[\\.6\\]{--tw-gradient-from:rgb(var(--sd-color-primary-800,5 21 48)/.6) var(--tw-gradient-from-position);--tw-gradient-to:hsla(0,0%,100%,0) var(--tw-gradient-to-position);--tw-gradient-stops:var(--tw-gradient-from),var(--tw-gradient-to)}.from-white\\/60{--tw-gradient-from:rgb(var(--sd-color-white,255 255 255)/var(--sd-opacity-60,0.6)) var(--tw-gradient-from-position);--tw-gradient-to:hsla(0,0%,100%,0) var(--tw-gradient-to-position);--tw-gradient-stops:var(--tw-gradient-from),var(--tw-gradient-to)}.from-white\\/75{--tw-gradient-from:rgb(var(--sd-color-white,255 255 255)/var(--sd-opacity-75,0.75)) var(--tw-gradient-from-position);--tw-gradient-to:hsla(0,0%,100%,0) var(--tw-gradient-to-position);--tw-gradient-stops:var(--tw-gradient-from),var(--tw-gradient-to)}.from-white\\/90{--tw-gradient-from:rgb(var(--sd-color-white,255 255 255)/var(--sd-opacity-90,0.9)) var(--tw-gradient-from-position);--tw-gradient-to:hsla(0,0%,100%,0) var(--tw-gradient-to-position);--tw-gradient-stops:var(--tw-gradient-from),var(--tw-gradient-to)}.from-white\\/\\[\\.8\\]{--tw-gradient-from:rgb(var(--sd-color-white,255 255 255)/.8) var(--tw-gradient-from-position);--tw-gradient-to:hsla(0,0%,100%,0) var(--tw-gradient-to-position);--tw-gradient-stops:var(--tw-gradient-from),var(--tw-gradient-to)}.to-primary-800\\/0{--tw-gradient-to:rgb(var(--sd-color-primary-800,5 21 48)/var(--sd-opacity-0,0)) var(--tw-gradient-to-position)}.to-primary-800\\/60{--tw-gradient-to:rgb(var(--sd-color-primary-800,5 21 48)/var(--sd-opacity-60,0.6)) var(--tw-gradient-to-position)}.to-primary-800\\/\\[\\.6\\]{--tw-gradient-to:rgb(var(--sd-color-primary-800,5 21 48)/.6) var(--tw-gradient-to-position)}.to-white\\/0{--tw-gradient-to:rgb(var(--sd-color-white,255 255 255)/var(--sd-opacity-0,0)) var(--tw-gradient-to-position)}.to-white\\/60{--tw-gradient-to:rgb(var(--sd-color-white,255 255 255)/var(--sd-opacity-60,0.6)) var(--tw-gradient-to-position)}.to-white\\/\\[\\.8\\]{--tw-gradient-to:rgb(var(--sd-color-white,255 255 255)/.8) var(--tw-gradient-to-position)}.to-60\\%{--tw-gradient-to-position:60%}.fill-accent{fill:rgb(var(--sd-color-accent,45 157 0)/1)}.fill-accent-550{fill:rgb(var(--sd-color-accent-550,54 123 40)/1)}.fill-accent-700{fill:rgb(var(--sd-color-accent-700,33 87 37)/1)}.fill-neutral-100{fill:rgb(var(--sd-color-neutral-100,246 246 246)/1)}.fill-primary{fill:rgb(var(--sd-color-primary,0 53 142)/1)}.fill-primary-100{fill:rgb(var(--sd-color-primary-100,236 240 249)/1)}.fill-primary-200{fill:rgb(var(--sd-color-primary-200,224 233 243)/1)}.fill-primary-500{fill:rgb(var(--sd-color-primary-500,70 109 175)/1)}.fill-transparent{fill:transparent}.fill-white{fill:rgb(var(--sd-color-white,255 255 255)/1)}.p-0{padding:var(--sd-spacing-0,0)}.p-1{padding:var(--sd-spacing-1,.25rem)}.p-2{padding:var(--sd-spacing-2,.5rem)}.p-4{padding:var(--sd-spacing-4,1rem)}.px-0{padding-left:var(--sd-spacing-0,0);padding-right:var(--sd-spacing-0,0)}.px-1{padding-left:var(--sd-spacing-1,.25rem);padding-right:var(--sd-spacing-1,.25rem)}.px-10{padding-left:var(--sd-spacing-10,2.5rem);padding-right:var(--sd-spacing-10,2.5rem)}.px-12{padding-left:var(--sd-spacing-12,3rem);padding-right:var(--sd-spacing-12,3rem)}.px-2{padding-left:var(--sd-spacing-2,.5rem);padding-right:var(--sd-spacing-2,.5rem)}.px-3{padding-left:var(--sd-spacing-3,.75rem);padding-right:var(--sd-spacing-3,.75rem)}.px-4{padding-left:var(--sd-spacing-4,1rem);padding-right:var(--sd-spacing-4,1rem)}.px-6{padding-left:var(--sd-spacing-6,1.5rem);padding-right:var(--sd-spacing-6,1.5rem)}.py-0{padding-bottom:var(--sd-spacing-0,0);padding-top:var(--sd-spacing-0,0)}.py-1{padding-bottom:var(--sd-spacing-1,.25rem);padding-top:var(--sd-spacing-1,.25rem)}.py-2{padding-bottom:var(--sd-spacing-2,.5rem);padding-top:var(--sd-spacing-2,.5rem)}.py-3{padding-bottom:var(--sd-spacing-3,.75rem);padding-top:var(--sd-spacing-3,.75rem)}.py-4{padding-bottom:var(--sd-spacing-4,1rem);padding-top:var(--sd-spacing-4,1rem)}.py-6{padding-bottom:var(--sd-spacing-6,1.5rem);padding-top:var(--sd-spacing-6,1.5rem)}.py-8{padding-bottom:var(--sd-spacing-8,2rem);padding-top:var(--sd-spacing-8,2rem)}.py-\\[5px\\]{padding-bottom:5px;padding-top:5px}.pb-1{padding-bottom:var(--sd-spacing-1,.25rem)}.pb-2{padding-bottom:var(--sd-spacing-2,.5rem)}.pb-3{padding-bottom:var(--sd-spacing-3,.75rem)}.pb-4{padding-bottom:var(--sd-spacing-4,1rem)}.pl-3{padding-left:var(--sd-spacing-3,.75rem)}.pl-4{padding-left:var(--sd-spacing-4,1rem)}.pl-8{padding-left:var(--sd-spacing-8,2rem)}.pr-2{padding-right:var(--sd-spacing-2,.5rem)}.pr-3{padding-right:var(--sd-spacing-3,.75rem)}.pr-4{padding-right:var(--sd-spacing-4,1rem)}.pt-0{padding-top:var(--sd-spacing-0,0)}.pt-1{padding-top:var(--sd-spacing-1,.25rem)}.pt-2{padding-top:var(--sd-spacing-2,.5rem)}.pt-3{padding-top:var(--sd-spacing-3,.75rem)}.text-left{text-align:left}.text-center{text-align:center}.align-middle{vertical-align:middle}.text-3xl{font-size:var(--sd-font-size-3xl,2rem)}.text-\\[12px\\]{font-size:12px}.text-\\[14px\\]{font-size:14px}.text-\\[2rem\\]{font-size:2rem}.text-\\[4rem\\]{font-size:4rem}.text-base{font-size:var(--sd-font-size-base,1rem)}.text-lg{font-size:var(--sd-font-size-lg,1.25rem)}.text-sm{font-size:var(--sd-font-size-sm,.875rem)}.text-xl{font-size:var(--sd-font-size-xl,1.5rem)}.\\!font-bold{font-weight:700!important}.font-bold{font-weight:700}.font-normal{font-weight:400}.lowercase{text-transform:lowercase}.leading-\\[0\\]{line-height:0}.leading-\\[calc\\(var\\(--tw-varspacing\\)-2px\\)\\]{line-height:calc(var(--tw-varspacing) - 2px)}.leading-none{line-height:var(--sd-line-height-none,100%)}.leading-normal{line-height:var(--sd-line-height-normal,150%)}.leading-tight{line-height:var(--sd-line-height-tight,120%)}.\\!text-neutral-700{--tw-text-opacity:1!important;color:rgb(var(--sd-color-neutral-700,104 104 104)/var(--tw-text-opacity,1))!important}.\\!text-primary{--tw-text-opacity:1!important;color:rgb(var(--sd-color-primary,0 53 142)/var(--tw-text-opacity,1))!important}.text-black{color:rgb(var(--sd-color-black,24 24 24)/var(--tw-text-opacity,1))}.text-black,.text-error{--tw-text-opacity:1}.text-error{color:rgb(var(--sd-color-error,204 25 55)/var(--tw-text-opacity,1))}.text-inherit{color:inherit}.text-neutral-500{--tw-text-opacity:1;color:rgb(var(--sd-color-neutral-500,174 174 174)/var(--tw-text-opacity,1))}.text-neutral-600{--tw-text-opacity:1;color:rgb(var(--sd-color-neutral-600,136 136 136)/var(--tw-text-opacity,1))}.text-neutral-700{--tw-text-opacity:1;color:rgb(var(--sd-color-neutral-700,104 104 104)/var(--tw-text-opacity,1))}.text-primary{--tw-text-opacity:1;color:rgb(var(--sd-color-primary,0 53 142)/var(--tw-text-opacity,1))}.text-primary-400{--tw-text-opacity:1;color:rgb(var(--sd-color-primary-400,153 171 208)/var(--tw-text-opacity,1))}.text-success{--tw-text-opacity:1;color:rgb(var(--sd-color-success,37 136 14)/var(--tw-text-opacity,1))}.text-white{--tw-text-opacity:1;color:rgb(var(--sd-color-white,255 255 255)/var(--tw-text-opacity,1))}.underline{text-decoration-line:underline}.no-underline{text-decoration-line:none}.underline-offset-2{text-underline-offset:2px}.placeholder-black::-moz-placeholder{--tw-placeholder-opacity:1;color:rgb(var(--sd-color-black,24 24 24)/var(--tw-placeholder-opacity,1))}.placeholder-black::placeholder{--tw-placeholder-opacity:1;color:rgb(var(--sd-color-black,24 24 24)/var(--tw-placeholder-opacity,1))}.placeholder-neutral-700::-moz-placeholder{--tw-placeholder-opacity:1;color:rgb(var(--sd-color-neutral-700,104 104 104)/var(--tw-placeholder-opacity,1))}.placeholder-neutral-700::placeholder{--tw-placeholder-opacity:1;color:rgb(var(--sd-color-neutral-700,104 104 104)/var(--tw-placeholder-opacity,1))}.opacity-0{opacity:var(--sd-opacity-0,0)}.opacity-100{opacity:var(--sd-opacity-100,1)}.opacity-20{opacity:var(--sd-opacity-20,.2)}.opacity-50{opacity:var(--sd-opacity-50,.5)}.opacity-90{opacity:var(--sd-opacity-90,.9)}.shadow{--tw-shadow:var(--sd-shadow,0px 1px 3px 0px rgba(81,81,81,.75));--tw-shadow-colored:0px 1px 3px 0px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow,0 0 #0000),var(--tw-ring-shadow,0 0 #0000),var(--tw-shadow)}.outline-none{outline:2px solid transparent;outline-offset:2px}.outline{outline-style:solid}.outline-dotted{outline-style:dotted}.outline-1{outline-width:1px}.outline-2{outline-width:2px}.\\!-outline-offset-2{outline-offset:-2px!important}.\\!outline-offset-0{outline-offset:0!important}.outline-offset-2{outline-offset:2px}.outline-error{outline-color:rgb(var(--sd-color-error,204 25 55)/1)}.outline-primary{outline-color:rgb(var(--sd-color-primary,0 53 142)/1)}.ring{--tw-ring-offset-shadow:var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);--tw-ring-shadow:var(--tw-ring-inset) 0 0 0 calc(3px + var(--tw-ring-offset-width)) var(--tw-ring-color);box-shadow:var(--tw-ring-offset-shadow),var(--tw-ring-shadow),var(--tw-shadow,0 0 #0000)}.blur{--tw-blur:blur(8px)}.blur,.filter{filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}.transition{transition-duration:.15s;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,-webkit-backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter,-webkit-backdrop-filter;transition-timing-function:cubic-bezier(.4,0,.2,1)}.transition-all{transition-duration:.15s;transition-property:all;transition-timing-function:cubic-bezier(.4,0,.2,1)}.transition-colors{transition-duration:.15s;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke;transition-timing-function:cubic-bezier(.4,0,.2,1)}.transition-opacity{transition-duration:.15s;transition-property:opacity;transition-timing-function:cubic-bezier(.4,0,.2,1)}.transition-transform{transition-duration:.15s;transition-property:transform;transition-timing-function:cubic-bezier(.4,0,.2,1)}.duration-100{transition-duration:.1s}.duration-1000{transition-duration:1s}.duration-150{transition-duration:.15s}.duration-200{transition-duration:.2s}.duration-300{transition-duration:.3s}.ease-in-out{transition-timing-function:cubic-bezier(.4,0,.2,1)}.varspacing-10{--tw-varspacing:var(--sd-spacing-10,2.5rem)}.varspacing-12{--tw-varspacing:var(--sd-spacing-12,3rem)}.varspacing-8{--tw-varspacing:var(--sd-spacing-8,2rem)}:host{--tw-gradient-from-position:0%;--tw-gradient-to-position:100%;box-sizing:border-box}:host *,:host :after,:host :before{box-sizing:inherit}[hidden]{display:none!important}.focus-within\\:focus-outline:focus-within{outline-color:rgb(var(--sd-color-primary,0 53 142)/1);outline-offset:2px;outline-style:solid;outline-width:2px}.focus-within\\:focus-outline-inverted:focus-within{outline-color:rgb(var(--sd-color-white,255 255 255)/1);outline-offset:2px;outline-style:solid;outline-width:2px}.focus-visible\\:focus-outline:focus-visible{outline-color:rgb(var(--sd-color-primary,0 53 142)/1);outline-offset:2px;outline-style:solid;outline-width:2px}.focus-visible\\:focus-outline-inverted:focus-visible{outline-color:rgb(var(--sd-color-white,255 255 255)/1);outline-offset:2px;outline-style:solid;outline-width:2px}.focus\\:outline-none:focus{outline:2px solid transparent;outline-offset:2px}.focus\\:outline:focus{outline-style:solid}.focus\\:outline-2:focus{outline-width:2px}.focus\\:outline-offset-2:focus{outline-offset:2px}.focus\\:outline-primary:focus{outline-color:rgb(var(--sd-color-primary,0 53 142)/1)}.focus-visible\\:outline-none:focus-visible{outline:2px solid transparent;outline-offset:2px}.disabled\\:border-neutral-500:disabled{--tw-border-opacity:1;border-color:rgb(var(--sd-color-neutral-500,174 174 174)/var(--tw-border-opacity,1))}.disabled\\:border-neutral-600:disabled{--tw-border-opacity:1;border-color:rgb(var(--sd-color-neutral-600,136 136 136)/var(--tw-border-opacity,1))}.disabled\\:bg-neutral-500:disabled{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-500,174 174 174)/var(--tw-bg-opacity,1))}.disabled\\:bg-neutral-600:disabled{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-600,136 136 136)/var(--tw-bg-opacity,1))}.disabled\\:text-neutral-500:disabled{--tw-text-opacity:1;color:rgb(var(--sd-color-neutral-500,174 174 174)/var(--tw-text-opacity,1))}.disabled\\:text-neutral-600:disabled{--tw-text-opacity:1;color:rgb(var(--sd-color-neutral-600,136 136 136)/var(--tw-text-opacity,1))}.disabled\\:text-white:disabled{--tw-text-opacity:1;color:rgb(var(--sd-color-white,255 255 255)/var(--tw-text-opacity,1))}.group:hover .group-hover\\:visible{visibility:visible}.group:hover .group-hover\\:top-0{top:var(--sd-spacing-0,0)}.group:hover .group-hover\\:h-full{height:100%}.group:hover .group-hover\\:w-full{width:100%}.group:hover .group-hover\\:cursor-pointer{cursor:pointer}.group:hover .group-hover\\:border-accent-550{--tw-border-opacity:1;border-color:rgb(var(--sd-color-accent-550,54 123 40)/var(--tw-border-opacity,1))}.group:hover .group-hover\\:border-error-400{--tw-border-opacity:1;border-color:rgb(var(--sd-color-error-400,172 25 56)/var(--tw-border-opacity,1))}.group:hover .group-hover\\:border-primary-500{--tw-border-opacity:1;border-color:rgb(var(--sd-color-primary-500,70 109 175)/var(--tw-border-opacity,1))}.group:hover .group-hover\\:bg-accent-550{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-accent-550,54 123 40)/var(--tw-bg-opacity,1))}.group:hover .group-hover\\:bg-error-400{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-error-400,172 25 56)/var(--tw-bg-opacity,1))}.group:hover .group-hover\\:bg-neutral-100\\/90{background-color:rgb(var(--sd-color-neutral-100,246 246 246)/var(--sd-opacity-90,.9))}.group:hover .group-hover\\:bg-neutral-200{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-200,233 233 233)/var(--tw-bg-opacity,1))}.group:hover .group-hover\\:bg-primary-100{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-100,236 240 249)/var(--tw-bg-opacity,1))}.group:hover .group-hover\\:bg-primary-100\\/90{background-color:rgb(var(--sd-color-primary-100,236 240 249)/var(--sd-opacity-90,.9))}.group:hover .group-hover\\:bg-primary\\/90{background-color:rgb(var(--sd-color-primary,0 53 142)/var(--sd-opacity-90,.9))}.group:hover .group-hover\\:bg-white\\/90{background-color:rgb(var(--sd-color-white,255 255 255)/var(--sd-opacity-90,.9))}.group:hover .group-hover\\:fill-primary-500{fill:rgb(var(--sd-color-primary-500,70 109 175)/1)}.group:hover .group-hover\\:\\!text-primary-500{--tw-text-opacity:1!important;color:rgb(var(--sd-color-primary-500,70 109 175)/var(--tw-text-opacity,1))!important}.group:hover .group-hover\\:text-primary-500{--tw-text-opacity:1;color:rgb(var(--sd-color-primary-500,70 109 175)/var(--tw-text-opacity,1))}.group:focus-visible .group-focus-visible\\:outline{outline-style:solid}.peer:focus-visible~.peer-focus-visible\\:outline{outline-style:solid}.peer:focus-visible~.peer-focus-visible\\:outline-2{outline-width:2px}.peer:focus-visible~.peer-focus-visible\\:outline-offset-2{outline-offset:2px}.peer:focus-visible~.peer-focus-visible\\:outline-primary{outline-color:rgb(var(--sd-color-primary,0 53 142)/1)}.hover\\:scale-110:hover:not([disabled]){--tw-scale-x:1.1;--tw-scale-y:1.1;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.hover\\:cursor-not-allowed:hover:not([disabled]){cursor:not-allowed}.hover\\:cursor-pointer:hover:not([disabled]){cursor:pointer}.hover\\:border-accent-550:hover:not([disabled]){--tw-border-opacity:1;border-color:rgb(var(--sd-color-accent-550,54 123 40)/var(--tw-border-opacity,1))}.hover\\:border-error-400:hover:not([disabled]){--tw-border-opacity:1;border-color:rgb(var(--sd-color-error-400,172 25 56)/var(--tw-border-opacity,1))}.hover\\:border-primary-100:hover:not([disabled]){--tw-border-opacity:1;border-color:rgb(var(--sd-color-primary-100,236 240 249)/var(--tw-border-opacity,1))}.hover\\:border-primary-500:hover:not([disabled]){--tw-border-opacity:1;border-color:rgb(var(--sd-color-primary-500,70 109 175)/var(--tw-border-opacity,1))}.hover\\:bg-accent-300:hover:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-accent-300,108 194 84)/var(--tw-bg-opacity,1))}.hover\\:bg-accent-550:hover:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-accent-550,54 123 40)/var(--tw-bg-opacity,1))}.hover\\:bg-error-400:hover:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-error-400,172 25 56)/var(--tw-bg-opacity,1))}.hover\\:bg-neutral-100:hover:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-100,246 246 246)/var(--tw-bg-opacity,1))}.hover\\:bg-neutral-200:hover:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-neutral-200,233 233 233)/var(--tw-bg-opacity,1))}.hover\\:bg-primary-100:hover:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-100,236 240 249)/var(--tw-bg-opacity,1))}.hover\\:bg-primary-500:hover:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-500,70 109 175)/var(--tw-bg-opacity,1))}.hover\\:bg-transparent:hover:not([disabled]){background-color:transparent}.hover\\:fill-accent-550:hover:not([disabled]){fill:rgb(var(--sd-color-accent-550,54 123 40)/1)}.hover\\:fill-primary-100:hover:not([disabled]){fill:rgb(var(--sd-color-primary-100,236 240 249)/1)}.hover\\:fill-primary-500:hover:not([disabled]){fill:rgb(var(--sd-color-primary-500,70 109 175)/1)}.hover\\:text-primary-100:hover:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-100,236 240 249)/var(--tw-text-opacity,1))}.hover\\:text-primary-200:hover:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-200,224 233 243)/var(--tw-text-opacity,1))}.hover\\:text-primary-500:hover:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-500,70 109 175)/var(--tw-text-opacity,1))}.active\\:border-primary-200:active:not([disabled]){--tw-border-opacity:1;border-color:rgb(var(--sd-color-primary-200,224 233 243)/var(--tw-border-opacity,1))}.active\\:border-primary-800:active:not([disabled]){--tw-border-opacity:1;border-color:rgb(var(--sd-color-primary-800,5 21 48)/var(--tw-border-opacity,1))}.active\\:bg-accent-700:active:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-accent-700,33 87 37)/var(--tw-bg-opacity,1))}.active\\:bg-primary-200:active:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-200,224 233 243)/var(--tw-bg-opacity,1))}.active\\:bg-primary-800:active:not([disabled]){--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-800,5 21 48)/var(--tw-bg-opacity,1))}.active\\:fill-accent-700:active:not([disabled]){fill:rgb(var(--sd-color-accent-700,33 87 37)/1)}.active\\:text-primary-200:active:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-200,224 233 243)/var(--tw-text-opacity,1))}.active\\:text-primary-400:active:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-400,153 171 208)/var(--tw-text-opacity,1))}.active\\:text-primary-800:active:not([disabled]){--tw-text-opacity:1;color:rgb(var(--sd-color-primary-800,5 21 48)/var(--tw-text-opacity,1))}@media (min-width:640px){.sm\\:mt-2{margin-top:var(--sd-spacing-2,.5rem)}.sm\\:flex-col{flex-direction:column}.sm\\:gap-4{gap:var(--sd-spacing-4,1rem)}.sm\\:self-center{align-self:center}.sm\\:p-6{padding:var(--sd-spacing-6,1.5rem)}.sm\\:px-10{padding-left:var(--sd-spacing-10,2.5rem);padding-right:var(--sd-spacing-10,2.5rem)}.sm\\:py-8{padding-top:var(--sd-spacing-8,2rem)}.sm\\:pb-8,.sm\\:py-8{padding-bottom:var(--sd-spacing-8,2rem)}.sm\\:text-center{text-align:center}.sm\\:text-3xl{font-size:var(--sd-font-size-3xl,2rem)}.sm\\:text-4xl{font-size:var(--sd-font-size-4xl,2.5rem)}.sm\\:leading-tight{line-height:var(--sd-line-height-tight,120%)}}@media (min-width:768px){.md\\:block{display:block}.md\\:\\[transition\\:_height_0\\.2s_linear\\2c opacity_0\\.1s_linear_0\\.1s\\]{transition:height .2s linear,opacity .1s linear .1s}.group:hover .md\\:group-hover\\:visible{visibility:visible}.group:hover .md\\:group-hover\\:my-4{margin-bottom:var(--sd-spacing-4,1rem);margin-top:var(--sd-spacing-4,1rem)}.group:hover .md\\:group-hover\\:h-auto{height:var(--sd-spacing-auto,auto)}.group:hover .md\\:group-hover\\:opacity-\\[100\\%\\]{opacity:100%}}`
];
__decorateClass([
  property()
], SolidElement.prototype, "dir", 2);
__decorateClass([
  property()
], SolidElement.prototype, "lang", 2);

export {
  customElement,
  SolidElement
};
