import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/tag/tag.ts
import { css } from "lit";
import { html, literal } from "lit/static-html.js";
import { ifDefined } from "lit/directives/if-defined.js";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdTag = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.size = "lg";
    this.selected = false;
    this.toggleable = false;
    this.removable = false;
    this.disabled = false;
    this.href = "";
  }
  handleBlur() {
    this.emit("sd-blur");
  }
  handleFocus() {
    this.emit("sd-focus");
  }
  handleRemoveClick() {
    this.emit("sd-remove");
  }
  isLink() {
    return this.href ? true : false;
  }
  /** Simulates a click on the tag. */
  click() {
    this.tag.click();
  }
  /** Sets focus on the tag. */
  focus(options) {
    this.tag.focus(options);
  }
  /** Removes focus from the tag. */
  blur() {
    this.tag.blur();
  }
  render() {
    const isLink = this.isLink();
    const tag = isLink ? literal`a` : literal`button`;
    return html`<${tag} part="base" type="${ifDefined(isLink ? void 0 : "button")}" href="${ifDefined(isLink ? this.href : void 0)}" rel="${ifDefined(isLink && this.target ? "noreferrer noopener" : void 0)}" target="${ifDefined(isLink ? this.target : void 0)}" download="${ifDefined(isLink ? this.download : void 0)}" ?disabled="${ifDefined(isLink ? void 0 : this.disabled)}" aria-disabled="${this.disabled ? "true" : "false"}" aria-pressed="${ifDefined(this.toggleable ? this.selected : void 0)}" tabindex="${this.disabled ? "-1" : "0"}" @blur="${this.handleBlur}" @focus="${this.handleFocus}" class="${cx(
      /* basic styles of the wrapper */
      "inline-flex border box-border rounded-full items-center leading-none whitespace-nowrap focus-visible:focus-outline",
      {
        /* sizes, fonts */
        lg: "h-8 text-base gap-2",
        sm: "h-6 text-sm gap-1"
      }[this.size],
      {
        /* padding */
        lg: !this.removable ? "px-4 py-2" : "pl-4 pr-3 py-2",
        sm: !this.removable ? "px-3 py-[5px]" : "pl-3 pr-2 py-2"
      }[this.size],
      /* colors */
      !this.selected ? "border-primary text-primary hover:border-primary-500 hover:bg-neutral-100 hover:text-primary-500  disabled:border-neutral-500 disabled:text-neutral-500" : "bg-primary border-primary text-white hover:bg-primary-500 hover:border-primary-500 disabled:bg-neutral-500 disabled:border-neutral-500",
      this.disabled && !isLink && "cursor-not-allowed"
    )}"><slot part="content"></slot>${this.removable ? html`<slot part="removable-indicator" name="removable-indicator" @click="${this.handleRemoveClick}" class="${cx(
      {
        /* sizes, fonts */
        lg: "text-base",
        sm: "text-[12px]"
      }[this.size]
    )}"><sd-icon library="system" name="close" label="remove"></sd-icon></slot>` : ""}</${tag}>`;
  }
};
SdTag.styles = [
  ...SolidElement.styles,
  css`:host{display:inline-block}`
];
__decorateClass([
  query("a, button")
], SdTag.prototype, "tag", 2);
__decorateClass([
  property({ reflect: true })
], SdTag.prototype, "size", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTag.prototype, "selected", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTag.prototype, "toggleable", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTag.prototype, "removable", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTag.prototype, "disabled", 2);
__decorateClass([
  property()
], SdTag.prototype, "href", 2);
__decorateClass([
  property()
], SdTag.prototype, "target", 2);
__decorateClass([
  property()
], SdTag.prototype, "download", 2);
SdTag = __decorateClass([
  customElement("sd-tag")
], SdTag);

export {
  SdTag
};
