import {
  getAnimation,
  setDefaultAnimation
} from "./chunk.N4LHE3QK.js";
import {
  animateTo,
  stopAnimations
} from "./chunk.EY4JPJJQ.js";
import {
  waitForEvent
} from "./chunk.B4BZKR24.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/notification/notification.ts
import { css, html } from "lit";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var toastStackDefault = Object.assign(document.createElement("div"), {
  className: "sd-toast-stack sd-toast-stack--top-right"
});
var toastStackBottomCenter = Object.assign(document.createElement("div"), {
  className: "sd-toast-stack sd-toast-stack--bottom-center"
});
var SdNotification = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.localize = new LocalizeController(this);
    this.variant = "info";
    this.open = false;
    this.closable = false;
    this.duration = Infinity;
    this.durationIndicator = false;
    this.toastStack = "top-right";
    this.remainingDuration = this.duration;
    this.startTime = Date.now();
  }
  firstUpdated() {
    this.base.hidden = !this.open;
  }
  startAutoHide() {
    clearTimeout(this.autoHideTimeout);
    this.startTime = Date.now();
    this.remainingDuration = this.duration;
    if (this.open && this.duration < Infinity) {
      this.autoHideTimeout = window.setTimeout(() => this.hide(), this.duration);
    }
  }
  onHover() {
    clearTimeout(this.autoHideTimeout);
    if (this.duration < Infinity) {
      this.remainingDuration -= Date.now() - this.startTime;
    }
  }
  onHoverEnd() {
    this.startTime = Date.now();
    clearTimeout(this.autoHideTimeout);
    if (this.open && this.duration < Infinity) {
      this.autoHideTimeout = window.setTimeout(() => {
        this.hide();
      }, this.remainingDuration);
    }
  }
  handleCloseClick() {
    this.hide();
  }
  async handleOpenChange() {
    if (this.open) {
      this.emit("sd-show");
      if (this.duration < Infinity) {
        this.startAutoHide();
      }
      await stopAnimations(this.base);
      this.base.hidden = false;
      const { keyframes, options } = getAnimation(this, "notification.show", { dir: this.localize.dir() });
      await animateTo(this.base, keyframes, options);
      this.emit("sd-after-show");
    } else {
      this.emit("sd-hide");
      clearTimeout(this.autoHideTimeout);
      await stopAnimations(this.base);
      const { keyframes, options } = getAnimation(this, "notification.hide", { dir: this.localize.dir() });
      await animateTo(this.base, keyframes, options);
      this.base.hidden = true;
      this.emit("sd-after-hide");
    }
  }
  handleDurationChange() {
    this.startAutoHide();
  }
  /** Shows the notification. */
  async show() {
    if (this.open) {
      return void 0;
    }
    this.open = true;
    return waitForEvent(this, "sd-after-show");
  }
  /** Hides the notification */
  async hide() {
    if (!this.open) {
      return void 0;
    }
    this.open = false;
    return waitForEvent(this, "sd-after-hide");
  }
  /**
   * Displays the notification as a toast notification. This will move the notification out of its position in the DOM and, when
   * dismissed, it will be removed from the DOM completely. By storing a reference to the notification, you can reuse it by
   * calling this method again. The returned promise will resolve after the notification is hidden.
   */
  async toast() {
    return new Promise((resolve) => {
      const toastStack = this.toastStack === "bottom-center" ? toastStackBottomCenter : toastStackDefault;
      if (toastStack.parentElement === null) {
        document.body.append(toastStack);
      }
      toastStack.appendChild(this);
      requestAnimationFrame(() => {
        this.clientWidth;
        this.show();
      });
      this.addEventListener(
        "sd-after-hide",
        () => {
          toastStack.removeChild(this);
          resolve();
          if (toastStack.querySelector("sd-notification") === null) {
            toastStack.remove();
          }
        },
        { once: true }
      );
    });
  }
  render() {
    return html`<div part="base" class="${cx("w-full overflow-hidden flex items-stretch relative m-2")}" role="alert" id="notification" aria-hidden="${this.open ? "false" : "true"}" @mouseenter="${this.onHover}" @mouseleave="${this.onHoverEnd}"><slot name="icon" part="icon" class="${cx(
      "min-w-min flex items-center px-3 justify-center",
      {
        info: "bg-info",
        success: "bg-success",
        warning: "bg-warning",
        error: "bg-error"
      }[this.variant]
    )}"><sd-icon name="${{
      info: "info-circle",
      success: "confirm-circle",
      warning: "exclamation-circle",
      error: "warning"
    }[this.variant] || ""}" library="system" class="h-6 w-6 text-white"></sd-icon></slot><div part="content" class="${cx(
      "h-full w-full p-1 gap-2 flex items-center justify-stretch bg-white",
      "border-solid border-[1px] border-l-0 border-neutral-400"
    )}"><slot part="message" class="block w-full pl-3 py-2" aria-live="polite"></slot>${this.closable ? html`<sd-button size="md" variant="tertiary" part="close-button" class="ml-auto flex flex-[0_0_auto] items-stretch" @click="${this.handleCloseClick}"><sd-icon label="${this.localize.term("close")}" name="close" library="system" color="currentColor"></sd-icon></sd-button>` : ""}</div>${this.durationIndicator ? html`<div part="duration-indicator__elapsed" id="duration-indicator__elapsed" style="${`animation-duration: ${this.duration}ms`}" class="${cx(`absolute w-0 h-[2px] bottom-0 bg-primary z-10 animate-grow`)}"></div><div part="duration-indicator__total" class="w-full h-[2px] bottom-0 absolute border border-neutral-400"></div>` : ""}</div>`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdNotification.styles = [
  ...SolidElement.styles,
  css`:host{display:contents}#notification:hover #duration-indicator__elapsed{animation-play-state:paused!important}`
];
__decorateClass([
  query('[part~="base"]')
], SdNotification.prototype, "base", 2);
__decorateClass([
  property({ reflect: true })
], SdNotification.prototype, "variant", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNotification.prototype, "open", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdNotification.prototype, "closable", 2);
__decorateClass([
  property({ type: Number })
], SdNotification.prototype, "duration", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "duration-indicator" })
], SdNotification.prototype, "durationIndicator", 2);
__decorateClass([
  property({ reflect: true, attribute: "toast-stack" })
], SdNotification.prototype, "toastStack", 2);
__decorateClass([
  watch("open", { waitUntilFirstUpdate: true })
], SdNotification.prototype, "handleOpenChange", 1);
__decorateClass([
  watch("duration")
], SdNotification.prototype, "handleDurationChange", 1);
SdNotification = __decorateClass([
  customElement("sd-notification")
], SdNotification);
setDefaultAnimation("notification.show", {
  keyframes: [
    { opacity: 0, scale: 0.8 },
    { opacity: 1, scale: 1 }
  ],
  options: { duration: 250, easing: "ease" }
});
setDefaultAnimation("notification.hide", {
  keyframes: [
    { opacity: 1, scale: 1 },
    { opacity: 0, scale: 0.8 }
  ],
  options: { duration: 250, easing: "ease" }
});

export {
  SdNotification
};
