import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/radio/radio.ts
import { css, html } from "lit";
import { property, state } from "lit/decorators.js";
import cx from "classix";
var SdRadio = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.checked = false;
    this.hasFocus = false;
    this.size = "lg";
    this.disabled = false;
    this.invalid = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.handleBlur = this.handleBlur.bind(this);
    this.handleClick = this.handleClick.bind(this);
    this.handleFocus = this.handleFocus.bind(this);
    this.setInitialAttributes();
    this.addEventListeners();
  }
  disconnectedCallback() {
    this.removeEventListeners();
  }
  addEventListeners() {
    this.addEventListener("blur", this.handleBlur);
    this.addEventListener("click", this.handleClick);
    this.addEventListener("focus", this.handleFocus);
  }
  removeEventListeners() {
    this.removeEventListener("blur", this.handleBlur);
    this.removeEventListener("click", this.handleClick);
    this.removeEventListener("focus", this.handleFocus);
  }
  handleBlur() {
    this.hasFocus = false;
    this.emit("sd-blur");
  }
  handleClick() {
    if (!this.disabled) {
      this.checked = true;
    }
  }
  handleFocus() {
    this.hasFocus = true;
    this.emit("sd-focus");
  }
  setInitialAttributes() {
    this.setAttribute("role", "radio");
    this.setAttribute("tabindex", "-1");
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
  }
  handleCheckedChange() {
    this.setAttribute("aria-checked", this.checked ? "true" : "false");
    this.setAttribute("tabindex", this.checked ? "0" : "-1");
  }
  handleDisabledChange() {
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
  }
  render() {
    return html`<span part="base" class="${cx(
      "sd-radio group inline-flex items-start items-center text-base leading-normal text-black cursor-pointer align-middle",
      this.disabled && "hover:cursor-not-allowed",
      {
        /* sizes, fonts */
        sm: "small-size text-sm",
        md: "text-base",
        lg: "text-base"
      }[this.size]
    )}"><span part="${`${this.checked ? "control--checked" : "control--unchecked"}`}" class="${cx(
      "flex-initial shrink-0 relative inline-flex items-center justify-center border rounded-full bg-white h-4 w-4",
      this.disabled ? "border-neutral-500" : this.invalid ? "border-error hover:border-error-400 group-hover:border-error-400" : this.checked ? "border-accent hover:border-accent-550 group-hover:border-accent-550" : "border-neutral-800 hover:bg-neutral-200 group-hover:bg-neutral-200"
    )}">${this.checked ? html`<span part="checked" class="${cx(
      "rounded-full inline-flex text-white border bg-accent h-2.5 w-2.5",
      this.disabled ? "bg-neutral-500" : this.invalid ? "bg-error hover:bg-error-400 group-hover:bg-error-400" : this.checked ? "bg-accent hover:bg-accent-550 group-hover:bg-accent-550" : "bg-neutral-800"
    )}"></span>` : ""}</span><slot part="label" class="${cx(
      "ml-2 select-none inline-block",
      this.disabled ? "text-neutral-500" : this.invalid ? "text-error" : "text-black"
    )}"></slot></span>`;
  }
};
/**
 * Inherits Tailwind classes and includes additional styling.
 */
SdRadio.styles = [
  ...SolidElement.styles,
  css`:host{display:block;width:-moz-max-content;width:max-content}:host(:focus-visible){outline:2px solid transparent;outline-offset:2px}:host(:focus-visible) [part=control--checked],:host(:focus-visible) [part=control--unchecked]{outline-color:rgb(var(--sd-color-primary,0 53 142)/1);outline-offset:2px;outline-style:solid;outline-width:2px}`
];
__decorateClass([
  state()
], SdRadio.prototype, "checked", 2);
__decorateClass([
  state()
], SdRadio.prototype, "hasFocus", 2);
__decorateClass([
  property({ reflect: true })
], SdRadio.prototype, "size", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdRadio.prototype, "disabled", 2);
__decorateClass([
  property()
], SdRadio.prototype, "value", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdRadio.prototype, "invalid", 2);
__decorateClass([
  watch("checked")
], SdRadio.prototype, "handleCheckedChange", 1);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdRadio.prototype, "handleDisabledChange", 1);
SdRadio = __decorateClass([
  customElement("sd-radio")
], SdRadio);

export {
  SdRadio
};
