import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/brandshape/brandshape.ts
import { css, html } from "lit";
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var SdBrandshape = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.variant = "primary";
    this.shapes = ["top", "middle", "bottom"];
    this.componentBreakpoint = 0;
  }
  getSvg(breakpoint, shape) {
    return {
      0: this.smallSvg(shape),
      414: this.mediumSvg(shape),
      640: this.largeSvg(shape)
    }[breakpoint];
  }
  largeSvg(shape) {
    return shape === "top" ? html`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 121"><path d="M610.777 1.393.001 120.146 0 123h700.001V74.79c0-4.797-.462-9.585-1.381-14.294-7.909-40.537-47.237-66.998-87.843-59.103Z"/></svg>` : html`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 123"><path d="M89.224 121.607 700 2.854 700.001 0h-700L0 48.21c0 4.797.463 9.584 1.381 14.294 7.909 40.537 47.237 66.998 87.843 59.103Z"/></svg>`;
  }
  mediumSvg(shape) {
    return shape === "top" ? html`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 119"><path d="M597.75 1.6 0 118.046V121h700V85.872c0-5.509-.53-11.006-1.583-16.413-9.063-46.543-54.133-76.924-100.667-67.86Z"/></svg>` : html`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 121"><path d="M102.25 119.4 700 2.954V0H0v35.128c0 5.509.53 11.006 1.583 16.413 9.063 46.543 54.134 76.924 100.667 67.859Z"/></svg>`;
  }
  smallSvg(shape) {
    return shape === "top" ? html`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 113"><path d="M566.951 2.08 0 112.466v2.934h700v-3.672c0-7.166-.689-14.314-2.059-21.348-11.789-60.557-70.436-100.09-130.99-88.3Z"/></svg>` : html`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 116"><path d="M133.049 113.32 700 2.934V0H0v3.672c0 7.165.69 14.314 2.059 21.348 11.79 60.557 70.436 100.09 130.99 88.3Z"/></svg>`;
  }
  setBreakpoint() {
    switch (true) {
      case this.containerElem.clientWidth <= 414:
        this.componentBreakpoint = 0;
        break;
      case this.containerElem.clientWidth < 640:
        this.componentBreakpoint = 414;
        break;
      default:
        this.componentBreakpoint = 640;
    }
  }
  connectedCallback() {
    super.connectedCallback();
    this.resizeObserver = new ResizeObserver(() => this.setBreakpoint());
    this.updateComplete.then(() => {
      this.setBreakpoint();
      this.resizeObserver.observe(this.containerElem);
    });
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    this.resizeObserver.unobserve(this.containerElem);
  }
  renderTopBrandshape() {
    return html`<div class="relative" part="shape-top">${this.getSvg(this.componentBreakpoint, "top")} ${this.renderWhitespaceFix("top")}</div>`;
  }
  renderMiddleBrandshape() {
    return html`<div class="${cx(
      { 0: "px-6 py-4", 414: "px-10 py-8", 640: "px-10 py-8" }[this.componentBreakpoint],
      "w-full block relative"
    )}"><div part="shape-middle" class="${cx(
      {
        "neutral-100": "bg-neutral-100",
        primary: "bg-primary",
        white: "bg-white",
        "border-white": "bg-transparent",
        "border-primary": "bg-transparent",
        image: "bg-transparent"
      }[this.variant],
      "w-full block absolute h-full top-0 left-0 z-0"
    )}"></div><div class="${cx("z-10 relative", this.variant === "image" && "invisible opacity-0")}" part="content"><slot>${this.variant === "image" ? "" : html`<div class="h-8"></div>`}</slot></div></div>`;
  }
  renderBottomBrandshape() {
    return html`<div class="relative" part="shape-bottom">${this.getSvg(this.componentBreakpoint, "bottom")}${this.renderWhitespaceFix("bottom")}</div>`;
  }
  /**
   * Renders a small line to prevent whitespace between the svg and the div of the middle brandshape.
   */
  renderWhitespaceFix(position) {
    return html`<div class="${cx(
      {
        "neutral-100": "bg-neutral-100",
        primary: "bg-primary",
        white: "bg-white",
        "border-white": "bg-transparent",
        "border-primary": "bg-transparent",
        image: "bg-transparent"
      }[this.variant],
      { top: "bottom-0", bottom: "top-0" }[position],
      "block absolute left-0 w-full h-[1px]"
    )}"></div>`;
  }
  renderStylizedVariant() {
    return html`<div part="stylized-container" class="w-full overflow-hidden"><slot class="${cx(this.variant !== "image" && "hidden")}" name="image"></slot></div>`;
  }
  renderShapes() {
    return html`${this.shapes.includes("top") ? this.renderTopBrandshape() : ""} ${this.shapes.includes("middle") ? this.renderMiddleBrandshape() : ""} ${this.shapes.includes("bottom") ? this.renderBottomBrandshape() : ""}`;
  }
  render() {
    const isStylizedVariant = this.variant.startsWith("border-") || this.variant === "image";
    return html`<div class="${cx(
      {
        "neutral-100": "fill-neutral-100",
        primary: "fill-primary",
        white: "fill-white",
        "border-white": "fill-transparent",
        "border-primary": "fill-transparent",
        image: "fill-transparent"
      }[this.variant],
      "relative"
    )}" part="base">${isStylizedVariant ? this.renderStylizedVariant() : ""} ${this.renderShapes()}</div>`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdBrandshape.styles = [
  ...SolidElement.styles,
  css`:host{container-type:inline-size;display:block;--angle:11deg;--radius:60px;--tan:tan(var(--angle));--adjacent:100cqw;--opposite:calc(var(--tan)*var(--adjacent));--curve:calc((var(--opposite) - (var(--radius)/3))*0.5)}@supports not (transform:skewY(11deg)){:host{--tan:0.1943803091}}@media (min-width:415px){:host{--radius:72px}}@media (min-width:640px){:host{--radius:84px}}:host([variant=image]) [part=stylized-container],:host([variant^=border-]) [part=stylized-container]:before{border-radius:0 var(--radius);height:calc(100% - var(--curve)*2);left:var(--sd-spacing-0,0);margin-top:calc(var(--curve));position:absolute;top:var(--sd-spacing-0,0);transform:skewY(calc(var(--angle)*-1))}slot[name=image]::slotted(img),slot[name=image]::slotted(video){height:calc(100% + var(--curve)*2)!important;-o-object-fit:cover;object-fit:cover;position:absolute!important;transform:translateY(calc(var(--curve)*-1)) skewY(var(--angle));width:100%}@supports not (height:100cqw){:host([variant=image]) [part=stylized-container],:host([variant^=border-]) [part=stylized-container]:before{height:100%;margin-top:0;transform:unset}slot[name=image]::slotted(img),slot[name=image]::slotted(video){height:100%!important;transform:unset}}:host([variant=border-primary]){--internal-border-color:rgb(var(--sd-color-primary,0 53 142))}:host([variant=border-white]){--internal-border-color:var(--sd-color-white,#fff)}:host([variant^=border-]) [part=stylized-container]:before{border-color:var(--internal-border-color,#000);border-style:solid;border-width:2px;content:"";right:var(--sd-spacing-0,0)}`
];
__decorateClass([
  query("[part=base]")
], SdBrandshape.prototype, "containerElem", 2);
__decorateClass([
  property({ type: String })
], SdBrandshape.prototype, "variant", 2);
__decorateClass([
  property({ type: Array })
], SdBrandshape.prototype, "shapes", 2);
__decorateClass([
  state()
], SdBrandshape.prototype, "componentBreakpoint", 2);
SdBrandshape = __decorateClass([
  customElement("sd-brandshape")
], SdBrandshape);

export {
  SdBrandshape
};
