import {
  debounce
} from "./chunk.NOWCQZBS.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/header/header.ts
import { css, html } from "lit";
import { property } from "lit/decorators.js";
var SdHeader = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.fixed = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.setCalculatedHeightProperty = this.setCalculatedHeightProperty.bind(this);
    this.addResizeObserver = this.addResizeObserver.bind(this);
  }
  firstUpdated() {
    this.toggleHeightCalculation();
  }
  toggleHeightCalculation() {
    var _a;
    if (this.fixed) {
      this.setCalculatedHeightProperty();
      this.addResizeObserver();
    } else {
      this.setCalculatedHeightProperty();
      (_a = this.resizeObserver) == null ? void 0 : _a.disconnect();
      this.resizeObserver = void 0;
    }
  }
  disconnectedCallback() {
    super.disconnectedCallback();
  }
  updated(changedProperties) {
    super.updated(changedProperties);
    if (changedProperties.has("fixed")) {
      this.toggleHeightCalculation();
    }
  }
  onResize() {
    if (this.fixed) {
      this.setCalculatedHeightProperty();
    }
  }
  addResizeObserver() {
    this.resizeObserver = new ResizeObserver(() => {
      this.onResize();
    });
    if (this.refHeaderElement) {
      this.resizeObserver.observe(this.refHeaderElement);
    }
  }
  setCalculatedHeightProperty() {
    if (this.fixed && this.refHeaderElement) {
      document.documentElement.style.setProperty(
        "--sd-header-calculated-height",
        `${this.refHeaderElement.clientHeight}px`
      );
    } else {
      document.documentElement.style.removeProperty("--sd-header-calculated-height");
    }
  }
  render() {
    return html`<header class="w-full bg-white relative" role="banner" @slotchange="${this.handleSlotChange}"><div part="main" class="relative mx-auto my-0 box-border"><slot></slot></div></header>`;
  }
  handleSlotChange(event) {
    const slot = event.target;
    if (slot.assignedElements().length > 0) {
      this.refHeaderElement = event.currentTarget;
      this.setCalculatedHeightProperty();
    }
  }
};
SdHeader.styles = [
  ...SolidElement.styles,
  css`:host{display:block}:host([fixed]){left:var(--sd-spacing-0,0);position:fixed;top:var(--sd-spacing-0,0);width:100%}:host([fixed]) header:after{background:var(--gradient-vertical-black-40-transparent,linear-gradient(0deg,#18181800 50%,#18181866 100%));content:"";height:var(--sd-spacing-2,.5rem);left:var(--sd-spacing-0,0);position:absolute;right:var(--sd-spacing-0,0);top:100%}[part=main]{max-width:var(--sd-header-inner-max-width);padding:var(--sd-header-padding,12px 16px);width:var(--sd-header-inner-width)}`
];
__decorateClass([
  property({ reflect: true, type: Boolean })
], SdHeader.prototype, "fixed", 2);
__decorateClass([
  debounce(100)
], SdHeader.prototype, "onResize", 1);
SdHeader = __decorateClass([
  customElement("sd-header")
], SdHeader);

export {
  SdHeader
};
