import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/step-group/step-group.ts
import { css, html } from "lit";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdStepGroup = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.steps = [];
    this.size = "lg";
    this.orientation = "horizontal";
    this.activeStep = 0;
    this.notInteractive = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.updateComplete.then(() => {
      this.steps = this.getAllSteps();
      this.steps[this.steps.length - 1].noTail = true;
      let activeStep;
      this.steps.forEach((step, index) => {
        step.index = index + 1;
        step.size = this.size;
        step.orientation = this.orientation;
        if (this.notInteractive) {
          step.current = false;
          step.disabled = false;
          step.notInteractive = true;
        } else if (step.current) {
          activeStep = index;
        }
      });
      this.setActiveStep(activeStep || this.activeStep);
    });
  }
  updateSize() {
    this.steps.forEach((step) => {
      step.size = this.size;
    });
  }
  updateOrientation() {
    this.steps.forEach((step) => {
      step.orientation = this.orientation;
    });
  }
  getAllSteps() {
    return [...this.body.assignedElements()].filter((el) => el.tagName.toLowerCase() === "sd-step");
  }
  /**
   * Sets the active step.
   * @param index The index of the step to set as active.
   */
  setActiveStep(index) {
    if (index >= 0 && index < this.steps.length && !this.notInteractive) {
      this.activeStep = index;
      this.steps.forEach((step, i) => {
        if (i === index) {
          step.current = true;
        } else if (i > index) {
          step.disabled = true;
        } else {
          step.current = false;
        }
      });
    }
  }
  handleInteractivityChange() {
    if (this.notInteractive) {
      this.steps.forEach((step) => {
        step.current = false;
        step.disabled = false;
        step.notInteractive = true;
      });
    }
  }
  render() {
    return html`<div role="${!this.notInteractive ? "navigation" : "group"}" class="h-full"><div role="list" part="base" class="${cx("flex", this.orientation === "vertical" && "flex-col h-full")}"><slot part="body"></slot></div></div>`;
  }
};
SdStepGroup.styles = [
  ...SolidElement.styles,
  css`:host{width:-moz-max-content;width:max-content}`
];
__decorateClass([
  query("[part=body]")
], SdStepGroup.prototype, "body", 2);
__decorateClass([
  property({ reflect: true })
], SdStepGroup.prototype, "size", 2);
__decorateClass([
  property({ reflect: true })
], SdStepGroup.prototype, "orientation", 2);
__decorateClass([
  property({ type: Number, reflect: true, attribute: "active-step" })
], SdStepGroup.prototype, "activeStep", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "not-interactive" })
], SdStepGroup.prototype, "notInteractive", 2);
__decorateClass([
  watch("size", { waitUntilFirstUpdate: true })
], SdStepGroup.prototype, "updateSize", 1);
__decorateClass([
  watch("orientation", { waitUntilFirstUpdate: true })
], SdStepGroup.prototype, "updateOrientation", 1);
__decorateClass([
  watch("notInteractive")
], SdStepGroup.prototype, "handleInteractivityChange", 1);
SdStepGroup = __decorateClass([
  customElement("sd-step-group")
], SdStepGroup);

export {
  SdStepGroup
};
