import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/badge/badge.ts
import { css, html } from "lit";
import { property } from "lit/decorators.js";
import cx from "classix";
var SdBadge = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.size = "lg";
    this.variant = "blue";
    this.inverted = false;
  }
  render() {
    return html`<span role="status" part="base" aria-labelledby="content" class="${cx(
      "inline-flex items-center justify-center gap-x-[1px] text-center font-bold whitespace-nowrap border rounded-full select-none cursor-[inherit]",
      {
        /* variants */
        blue: !this.inverted ? "text-white bg-primary-500 border-white" : "text-primary bg-primary-100 border-primary",
        green: !this.inverted ? "text-white bg-success border-white" : "text-white bg-success border-primary",
        red: !this.inverted ? "text-white bg-error border-white" : "text-white bg-error border-primary"
      }[this.variant],
      {
        /* size and fonts*/
        sm: "h-2 min-w-2",
        md: "h-4 px-1 min-w-4",
        lg: "h-5 min-w-5"
      }[this.size]
    )}"><span id="content" part="content" class="${cx(this.size === "sm" && "sr-only")}"><slot></slot></span></span>`;
  }
};
SdBadge.styles = [
  ...SolidElement.styles,
  css`:host{align-items:center;display:inline-flex;justify-content:center}:host([size=md]){font-size:.625rem}:host([size=lg]){font-size:.75rem}:host([size=lg])::part(base){padding-left:.313rem;padding-right:.313rem}`
];
__decorateClass([
  property({ reflect: true })
], SdBadge.prototype, "size", 2);
__decorateClass([
  property({ reflect: true })
], SdBadge.prototype, "variant", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdBadge.prototype, "inverted", 2);
SdBadge = __decorateClass([
  customElement("sd-badge")
], SdBadge);

export {
  SdBadge
};
