// src/components/combobox/utils.ts
var getAssignedElementsForSlot = (slot) => Array.from(slot.assignedElements({ flatten: true }));
var getOptionOrNestedOptions = (item) => item.tagName.toLocaleLowerCase() === "sd-option" ? item : Array.from(item.querySelectorAll(":scope > sd-option"));
var isOptgroup = (item) => item.tagName.toLocaleLowerCase() === "sd-optgroup";
var getAllOptions = (items) => items.map(getOptionOrNestedOptions);
var filterOnlyOptgroups = (items) => items.filter(isOptgroup);
var normalizeString = (str) => str.normalize("NFD").replace(/[\u0300-\u036f]/g, "").toLowerCase();

export {
  getAssignedElementsForSlot,
  getOptionOrNestedOptions,
  isOptgroup,
  getAllOptions,
  filterOnlyOptgroups,
  normalizeString
};
