// src/components/combobox/option-renderer.ts
var defaultOptionRenderer = (option) => option;
var highlightOptionRenderer = (option, query) => {
  if (!query) {
    return option;
  }
  const clonedOption = option.cloneNode(true);
  clonedOption.selected = option.selected;
  const optionLabel = clonedOption.getTextLabel();
  const queryIndex = optionLabel.toLowerCase().indexOf(query.toLowerCase());
  const indexLabel = clonedOption.innerHTML.indexOf(optionLabel);
  const mark = document.createElement("mark");
  mark.textContent = optionLabel.slice(queryIndex, queryIndex + query.length);
  const exchangedText = optionLabel.replace(new RegExp(query, "i"), mark.outerHTML);
  const previousContent = clonedOption.innerHTML.slice(0, indexLabel);
  const followingContent = clonedOption.innerHTML.slice(indexLabel + optionLabel.length);
  clonedOption.innerHTML = previousContent.concat(exchangedText, followingContent);
  return clonedOption;
};

export {
  defaultOptionRenderer,
  highlightOptionRenderer
};
