import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/tab/tab.ts
import { css, html } from "lit";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var id = 0;
var SdTab = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.attrId = ++id;
    this.componentId = `sd-tab-${this.attrId}`;
    this.hasSlotController = new HasSlotController(this, "left");
    this.variant = "default";
    this.active = false;
    this.disabled = false;
    this.panel = "";
  }
  connectedCallback() {
    super.connectedCallback();
    this.setAttribute("role", "tab");
  }
  handleActiveChange() {
    this.setAttribute("aria-selected", this.active ? "true" : "false");
  }
  handleDisabledChange() {
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
  }
  /** Sets focus to the tab. */
  focus(options) {
    this.tab.focus(options);
  }
  /** Removes focus from the tab. */
  blur() {
    this.tab.blur();
  }
  render() {
    this.id = this.id.length > 0 ? this.id : this.componentId;
    const slots = {
      left: this.hasSlotController.test("left")
    };
    return html`<div part="base" class="${cx(
      "inline-flex min-w-max h-12 px-3 leading-none items-center justify-center whitespace-nowrap select-none cursor-pointer group relative focus-visible:focus-outline outline-2 !-outline-offset-2",
      this.variant === "container" && " rounded-[4px_4px_0_0]",
      this.variant === "container" && this.active && "tab--active-container-border bg-white",
      this.disabled ? "opacity-50 !cursor-not-allowed" : "hover:bg-neutral-200"
    )}" tabindex="${!this.active || this.disabled ? "-1" : "0"}"><slot name="left" class="${cx(slots.left && "block pr-2", this.disabled ? "text-neutral-500" : "text-primary")}"></slot><slot class="${cx(this.disabled ? "text-neutral-500" : "text-primary")}"></slot><div part="active-tab-indicator" class="${cx(
      (!this.active || this.disabled) && "hidden",
      "absolute bottom-0 h-1 bg-accent",
      this.variant === "default" ? "w-full" : "w-3/4 group-hover:w-full transition-all duration-200 ease-in-out"
    )}"></div><div part="hover-bottom-border" class="${cx(
      !this.active && !this.disabled && "absolute w-full h-0.25 bottom-0 border-b border-neutral-400 invisible group-hover:visible"
    )}"></div></div>`;
  }
};
SdTab.styles = [
  ...SolidElement.styles,
  css`:host{box-sizing:border-box;display:block}.tab--active-container-border:after{border-width:1px;content:"";height:100%;position:absolute;width:100%;--tw-border-opacity:1;border-color:rgb(var(--sd-color-neutral-400,195 195 195)/var(--tw-border-opacity,1));border-bottom:none;border-radius:4px 4px 0 0}`
];
__decorateClass([
  query("[part=base]")
], SdTab.prototype, "tab", 2);
__decorateClass([
  property({ type: String, reflect: true })
], SdTab.prototype, "variant", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTab.prototype, "active", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTab.prototype, "disabled", 2);
__decorateClass([
  property({ reflect: true })
], SdTab.prototype, "panel", 2);
__decorateClass([
  watch("active")
], SdTab.prototype, "handleActiveChange", 1);
__decorateClass([
  watch("disabled")
], SdTab.prototype, "handleDisabledChange", 1);
SdTab = __decorateClass([
  customElement("sd-tab")
], SdTab);

export {
  SdTab
};
