import {
  SdTag
} from "./chunk.KH4M6HPE.js";
import {
  SdPopup
} from "./chunk.VTUCPGYW.js";
import {
  defaultValue
} from "./chunk.GI7VDIWX.js";
import {
  scrollIntoView
} from "./chunk.WDWV53JP.js";
import {
  FormControlController
} from "./chunk.KVKRZJS7.js";
import {
  getAnimation,
  setDefaultAnimation
} from "./chunk.N4LHE3QK.js";
import {
  SdIcon
} from "./chunk.X2PI2F35.js";
import {
  animateTo,
  stopAnimations
} from "./chunk.EY4JPJJQ.js";
import {
  waitForEvent
} from "./chunk.B4BZKR24.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/select/select.ts
import { css, html } from "lit";
import { property, query, queryAssignedElements, state } from "lit/decorators.js";
import { unsafeHTML } from "lit-html/directives/unsafe-html.js";
import cx from "classix";
var SdSelect = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.formControlController = new FormControlController(this, {
      assumeInteractionOn: ["sd-blur", "sd-input"]
    });
    this.hasSlotController = new HasSlotController(this, "help-text", "label");
    this.localize = new LocalizeController(this);
    this.typeToSelectString = "";
    this.hasHover = false;
    this.displayLabel = "";
    this.deletedTagLabel = "";
    this.hasFocus = false;
    this.selectedOptions = [];
    this.showValidStyle = false;
    this.showInvalidStyle = false;
    this.defaultValue = "";
    this.open = false;
    this.size = "lg";
    this.placement = "bottom";
    this.label = "";
    this.placeholder = "";
    this.maxOptionsTagLabel = "";
    this.disabled = false;
    this.helpText = "";
    this.currentPlacement = this.placement;
    this.clearable = false;
    this.multiple = false;
    this.useTags = false;
    this.maxOptionsVisible = 3;
    this.form = "";
    this.name = "";
    this.value = "";
    this.required = false;
    this.styleOnValid = false;
    this.hoist = false;
    this.getTag = (option) => {
      return html`<sd-tag ?disabled="${this.disabled}" part="tag" exportparts="
              base:tag__base,
              content:tag__content,
              removable-indicator:tag__removable-indicator,
            " size="${this.size === "sm" ? "sm" : "lg"}" removable @keydown="${(event) => this.handleTagKeyDown(event, option)}" @sd-remove="${(event) => this.handleTagRemove(event, option)}">${option.getTextLabel()}</sd-tag>`;
    };
    this.handleDocumentFocusIn = (event) => {
      const path = event.composedPath();
      if (this && !path.includes(this)) {
        this.hide();
      }
    };
    this.handleDocumentKeyDown = (event) => {
      const target = event.target;
      const isClearButton = target.closest(".select__clear") !== null;
      const isIconButton = target.closest("sd-icon-button") !== null;
      if (isClearButton || isIconButton) {
        return;
      }
      if (event.key === "Escape" && this.open) {
        event.preventDefault();
        event.stopPropagation();
        this.hide();
        this.displayInput.focus({ preventScroll: true });
      }
      if (event.key === "Enter" || event.key === " " && this.typeToSelectString === "") {
        event.preventDefault();
        event.stopImmediatePropagation();
        if (!this.open) {
          this.show();
          return;
        }
        if (this.currentOption && !this.currentOption.disabled) {
          if (this.multiple) {
            this.toggleOptionSelection(this.currentOption);
          } else {
            this.setSelectedOptions(this.currentOption);
          }
          this.updateComplete.then(() => {
            this.emit("sd-input");
            this.emit("sd-change");
          });
          if (!this.multiple) {
            this.hide();
            this.displayInput.focus({ preventScroll: true });
          }
        }
        return;
      }
      if (["ArrowUp", "ArrowDown", "Home", "End"].includes(event.key)) {
        const allOptions = this.getAllOptions();
        const currentIndex = allOptions.indexOf(this.currentOption);
        let newIndex = Math.max(0, currentIndex);
        event.preventDefault();
        if (!this.open) {
          this.show();
          if (this.currentOption) {
            return;
          }
        }
        if (event.key === "ArrowDown") {
          newIndex = currentIndex + 1;
          if (newIndex > allOptions.length - 1) newIndex = 0;
        } else if (event.key === "ArrowUp") {
          newIndex = currentIndex - 1;
          if (newIndex < 0) newIndex = allOptions.length - 1;
        } else if (event.key === "Home") {
          newIndex = 0;
        } else if (event.key === "End") {
          newIndex = allOptions.length - 1;
        }
        this.setCurrentOption(allOptions[newIndex]);
      }
      if (event.key.length === 1 || event.key === "Backspace") {
        const allOptions = this.getAllOptions();
        if (event.metaKey || event.ctrlKey || event.altKey) {
          return;
        }
        if (!this.open) {
          if (event.key === "Backspace") {
            return;
          }
          this.show();
        }
        event.stopPropagation();
        event.preventDefault();
        clearTimeout(this.typeToSelectTimeout);
        this.typeToSelectTimeout = window.setTimeout(() => this.typeToSelectString = "", 1e3);
        if (event.key === "Backspace") {
          this.typeToSelectString = this.typeToSelectString.slice(0, -1);
        } else {
          this.typeToSelectString += event.key.toLowerCase();
        }
        for (const option of allOptions) {
          const label = option.getTextLabel().toLowerCase();
          if (label.startsWith(this.typeToSelectString)) {
            this.setCurrentOption(option);
            break;
          }
        }
      }
    };
    this.handleDocumentMouseDown = (event) => {
      const path = event.composedPath();
      if (this && !path.includes(this)) {
        this.hide();
      }
    };
  }
  /** Gets the validity state object */
  get validity() {
    return this.valueInput.validity;
  }
  /** Gets the validation message */
  get validationMessage() {
    return this.valueInput.validationMessage;
  }
  connectedCallback() {
    super.connectedCallback();
    this.open = false;
  }
  firstUpdated() {
    this.applySizeToOptions();
  }
  addOpenListeners() {
    document.addEventListener("focusin", this.handleDocumentFocusIn);
    document.addEventListener("keydown", this.handleDocumentKeyDown);
    document.addEventListener("mousedown", this.handleDocumentMouseDown);
  }
  removeOpenListeners() {
    document.removeEventListener("focusin", this.handleDocumentFocusIn);
    document.removeEventListener("keydown", this.handleDocumentKeyDown);
    document.removeEventListener("mousedown", this.handleDocumentMouseDown);
  }
  handleFocus() {
    this.hasFocus = true;
    this.displayInput.setSelectionRange(0, 0);
    this.emit("sd-focus");
  }
  handleBlur() {
    this.hasFocus = false;
    this.emit("sd-blur");
  }
  handleTagKeyDown(event, option) {
    var _a, _b, _c;
    if (event.key === "Backspace" && this.multiple) {
      event.preventDefault();
      event.stopPropagation();
      const tagParent = (_a = event.currentTarget) == null ? void 0 : _a.parentElement;
      const previousTag = (_b = tagParent == null ? void 0 : tagParent.previousElementSibling) == null ? void 0 : _b.querySelector("sd-tag");
      const nextTag = (_c = tagParent == null ? void 0 : tagParent.nextElementSibling) == null ? void 0 : _c.querySelector("sd-tag");
      this.handleTagRemove(new CustomEvent("sd-remove"), option);
      this.updateComplete.then(() => {
        if (nextTag) {
          nextTag.focus();
        } else if (previousTag) {
          previousTag.focus();
        } else {
          this.focus({ preventScroll: true });
        }
      });
    }
  }
  handleTagMaxOptionsKeyDown(event) {
    if (event.key === "Backspace" && this.multiple) {
      event.preventDefault();
      event.stopPropagation();
      this.handleTagRemove(new CustomEvent("sd-remove"), this.selectedOptions[this.selectedOptions.length - 1]);
      this.updateComplete.then(() => {
        var _a;
        const tags = (_a = this.shadowRoot) == null ? void 0 : _a.querySelectorAll("sd-tag");
        if (tags && tags.length > 0) {
          tags == null ? void 0 : tags[(tags == null ? void 0 : tags.length) - 1].focus();
        } else {
          this.focus({ preventScroll: true });
        }
      });
    }
  }
  handleLabelClick() {
    this.displayInput.focus();
  }
  handleComboboxMouseDown(event) {
    const path = event.composedPath();
    const isRemovableIndicator = path.some((el) => el instanceof HTMLSlotElement && el.name === "removable-indicator");
    if (this.disabled || isRemovableIndicator) {
      return;
    }
    event.preventDefault();
    this.displayInput.focus({ preventScroll: true });
    this.open = !this.open;
  }
  handleComboboxKeyDown(event) {
    event.stopPropagation();
    this.handleDocumentKeyDown(event);
  }
  handleClearClick(event) {
    event.stopPropagation();
    this.clearSelect();
  }
  clearSelect() {
    this.setSelectedOptions([]);
    this.displayInput.focus({ preventScroll: true });
    this.updateComplete.then(() => {
      this.emit("sd-clear");
      this.emit("sd-input");
      this.emit("sd-change");
    });
  }
  handleClearMouseDown(event) {
    event.stopPropagation();
    event.preventDefault();
  }
  handleOptionClick(event) {
    const target = event.target;
    const option = target.closest("sd-option");
    const oldValue = this.value;
    if (option && !option.disabled) {
      if (this.multiple) {
        this.toggleOptionSelection(option);
      } else {
        this.setSelectedOptions(option);
      }
      this.updateComplete.then(() => this.displayInput.focus({ preventScroll: true }));
      if (this.value !== oldValue) {
        this.updateComplete.then(() => {
          this.emit("sd-input");
          this.emit("sd-change");
        });
      }
      if (!this.multiple) {
        this.hide();
        this.displayInput.focus({ preventScroll: true });
      }
    }
  }
  handleDefaultSlotChange() {
    const allOptions = this.getAllOptions();
    const value = Array.isArray(this.value) ? this.value : [this.value];
    const values = [];
    if (customElements.get("sd-option")) {
      allOptions.forEach((option) => {
        if (this.multiple) {
          option.checkbox = true;
        }
        values.push(option.value);
      });
      this.setSelectedOptions(allOptions.filter((el) => value.includes(el.value)));
    } else {
      customElements.whenDefined("sd-option").then(() => this.handleDefaultSlotChange());
    }
  }
  handleTagRemove(event, option) {
    event.stopPropagation();
    if (!option) {
      this.clearSelect();
    }
    if (option && !this.disabled) {
      this.toggleOptionSelection(option, false);
      this.deletedTagLabel = this.localize.term("removed", option.textContent);
      this.updateComplete.then(() => {
        this.emit("sd-input");
        this.emit("sd-change");
      });
    }
  }
  // Gets an array of all <sd-option> elements
  getAllOptions() {
    return [...this.querySelectorAll("sd-option")];
  }
  // Gets the first <sd-option> element
  getFirstOption() {
    return this.querySelector("sd-option");
  }
  // Sets the current option, which is the option the user is currently interacting with (e.g. via keyboard). Only one
  // option may be "current" at a time.
  setCurrentOption(option) {
    const allOptions = this.getAllOptions();
    allOptions.forEach((el) => {
      el.current = false;
      el.tabIndex = -1;
    });
    if (option) {
      this.currentOption = option;
      option.current = true;
      option.tabIndex = 0;
      option.focus();
    }
  }
  // Sets the selected option(s)
  setSelectedOptions(option) {
    const allOptions = this.getAllOptions();
    const newSelectedOptions = Array.isArray(option) ? option : [option];
    allOptions.forEach((el) => el.selected = false);
    if (newSelectedOptions.length) {
      newSelectedOptions.forEach((el) => el.selected = true);
    }
    if (Array.isArray(option)) {
      this.selectionChanged();
    } else {
      this.selectionChanged(option);
    }
  }
  // Toggles an option's selected state
  toggleOptionSelection(option, force) {
    if (force === true || force === false) {
      option.selected = force;
    } else {
      option.selected = !option.selected;
    }
    if (Array.isArray(option)) {
      this.selectionChanged();
    } else {
      this.selectionChanged(option);
    }
  }
  // This method must be called whenever the selection changes. It will update the selected options cache, the current
  // value, and the display value
  selectionChanged(option) {
    var _a, _b, _c, _d;
    if (option && this.multiple) {
      if (this.selectedOptions.find((el) => el.value === option.value)) {
        this.selectedOptions = this.selectedOptions.filter((el) => el.value !== option.value);
      } else {
        this.selectedOptions = [...this.selectedOptions, option];
      }
    } else {
      this.selectedOptions = this.getAllOptions().filter((el) => el.selected);
    }
    if (this.multiple) {
      this.value = this.selectedOptions.map((el) => el.value);
      if (this.useTags || this.value.length === 0) {
        this.displayLabel = "";
      } else {
        this.displayLabel = this.localize.term("numOptionsSelected", this.selectedOptions.length);
      }
    } else {
      this.value = (_b = (_a = this.selectedOptions[0]) == null ? void 0 : _a.value) != null ? _b : "";
      this.displayLabel = (_d = (_c = this.selectedOptions[0]) == null ? void 0 : _c.getTextLabel()) != null ? _d : "";
    }
    this.updateComplete.then(() => {
      this.formControlController.updateValidity();
    });
  }
  get tags() {
    if (this.selectedOptions.length <= this.maxOptionsVisible) {
      return this.selectedOptions.map((option, index) => {
        if (index < this.maxOptionsVisible || this.maxOptionsVisible <= 0) {
          const tag = this.getTag(option, index);
          return html`<div @sd-remove="${(e) => this.handleTagRemove(e, option)}">${typeof tag === "string" ? unsafeHTML(tag) : tag}</div>`;
        }
        return [html``];
      });
    } else {
      return [
        html`<sd-tag ?disabled="${this.disabled}" part="tag" exportparts="
              base:tag__base,
              content:tag__content,
              removable-indicator:tag__removable-indicator,
            " size="${this.size === "sm" ? "sm" : "lg"}" removable @keydown="${(event) => this.handleTagMaxOptionsKeyDown(event)}" @sd-remove="${(event) => this.handleTagRemove(event)}">${this.selectedOptions.length} ${this.localize.term("tagsSelected")}</sd-tag>`
      ];
    }
  }
  handleInvalid(event) {
    this.formControlController.setValidity(false);
    this.formControlController.emitInvalidEvent(event);
    this.invalidMessage.textContent = event.target.validationMessage;
  }
  handleMouseEnter() {
    this.hasHover = true;
  }
  handleMouseLeave() {
    this.hasHover = false;
  }
  /** Receives incoming event detail from sd-popup and updates local state for conditional styling. */
  handleCurrentPlacement(e) {
    const incomingPlacement = e.detail;
    if (incomingPlacement) {
      this.currentPlacement = incomingPlacement;
    }
  }
  handleUseTagsChange() {
    const allOptions = this.getAllOptions();
    if (customElements.get("sd-option")) {
      allOptions.forEach((option) => {
        option.checkbox = this.multiple;
      });
    }
  }
  handleDisabledChange() {
    if (this.disabled) {
      this.open = false;
      this.handleOpenChange();
    }
  }
  async handleOpenChange() {
    if (this.open && !this.disabled) {
      if (!this.multiple) this.setCurrentOption(this.selectedOptions[0] || this.getFirstOption());
      this.emit("sd-show");
      this.addOpenListeners();
      await stopAnimations(this);
      this.listbox.hidden = false;
      this.popup.active = true;
      requestAnimationFrame(() => {
        this.setCurrentOption(this.currentOption);
      });
      const { keyframes, options } = getAnimation(this, "select.show", { dir: this.localize.dir() });
      await animateTo(this.popup.popup, keyframes, options);
      if (this.currentOption) {
        scrollIntoView(this.currentOption, this.listbox, "vertical", "auto");
      }
      this.emit("sd-after-show");
    } else {
      this.emit("sd-hide");
      this.removeOpenListeners();
      await stopAnimations(this);
      const { keyframes, options } = getAnimation(this, "select.hide", { dir: this.localize.dir() });
      await animateTo(this.popup.popup, keyframes, options);
      this.listbox.hidden = true;
      this.popup.active = false;
      this.emit("sd-after-hide");
    }
  }
  applySizeToOptions() {
    this._optionsInDefaultSlot.forEach((option) => {
      option.size = this.size;
    });
  }
  handleValueChange() {
    if (this.selectedOptions.length === (Array.isArray(this.value) ? this.value.length : 1)) return;
    const allOptions = this.getAllOptions();
    const value = Array.isArray(this.value) ? this.value : [this.value];
    this.setSelectedOptions(allOptions.filter((el) => value.includes(el.value)));
  }
  /** Shows the listbox. */
  async show() {
    if (this.open || this.disabled) {
      this.open = false;
      return void 0;
    }
    this.open = true;
    return waitForEvent(this, "sd-after-show");
  }
  /** Hides the listbox. */
  async hide() {
    if (!this.open || this.disabled) {
      this.open = false;
      return void 0;
    }
    this.open = false;
    return waitForEvent(this, "sd-after-hide");
  }
  /** Checks for validity but does not show a validation message. Returns `true` when valid and `false` when invalid. */
  checkValidity() {
    var _a;
    return (_a = this.valueInput) == null ? void 0 : _a.checkValidity();
  }
  /** Gets the associated form, if one exists. */
  getForm() {
    return this.formControlController.getForm();
  }
  /** Checks for validity and shows the browser's validation message if the control is invalid. */
  reportValidity() {
    this.formControlController.fakeUserInteraction();
    return this.valueInput.reportValidity();
  }
  /** Sets a custom validation message. Pass an empty string to restore validity. */
  setCustomValidity(message) {
    this.valueInput.setCustomValidity(message);
    this.formControlController.updateValidity();
  }
  /** Sets focus on the control. */
  focus(options) {
    this.displayInput.focus(options);
  }
  /** Removes focus from the control. */
  blur() {
    this.displayInput.blur();
  }
  render() {
    const slots = {
      default: this.hasSlotController.test("[default]"),
      label: this.hasSlotController.test("label"),
      clearIcon: this.hasSlotController.test("clear-icon"),
      expandIcon: this.hasSlotController.test("expand-icon"),
      helpText: this.hasSlotController.test("help-text")
    };
    const hasLabel = this.label ? true : !!slots["label"];
    const hasHelpText = this.helpText ? true : !!slots["helpText"];
    const hasClearIcon = this.clearable && !this.disabled;
    const selectState = this.disabled ? "disabled" : this.hasFocus && this.showInvalidStyle ? "activeInvalid" : this.hasFocus && this.styleOnValid && this.showValidStyle ? "activeValid" : this.hasFocus || this.open ? "active" : this.showInvalidStyle ? "invalid" : this.styleOnValid && this.showValidStyle ? "valid" : "default";
    const cursorStyles = this.disabled ? "cursor-not-allowed" : "cursor-pointer";
    const iconMarginLeft = { sm: "ml-1", md: "ml-2", lg: "ml-2" }[this.size];
    const iconSize = {
      sm: "text-base",
      md: "text-lg",
      lg: "text-xl"
    }[this.size];
    return html`<div part="form-control" class="${cx(
      "relative text-left",
      cursorStyles,
      this.size === "sm" ? "text-sm" : "text-base",
      this.open && "z-50"
    )}"><span class="sr-only" role="alert" aria-live="assertive">${this.deletedTagLabel}</span><div class="flex items-center gap-1 mb-2"><label id="label" part="form-control-label" class="${hasLabel && "inline-block"}" aria-hidden="${hasLabel ? "false" : "true"}" @click="${this.handleLabelClick}"><slot name="label">${this.label}</slot></label><slot name="tooltip"></slot></div><div part="form-control-input" class="${cx("relative w-full bg-white", selectState === "disabled" ? "text-neutral-500" : "text-black")}"><div part="border" class="${cx(
      "absolute top-0 w-full h-full pointer-events-none border rounded-default",
      this.hasHover && "bg-neutral-200",
      {
        disabled: "border-neutral-500",
        readonly: "border-neutral-800",
        activeInvalid: "border-error border-2",
        activeValid: "border-success border-2",
        active: "border-primary border-2",
        invalid: "border-error",
        valid: "border-success",
        default: "border-neutral-800"
      }[selectState],
      this.open && (this.currentPlacement === "bottom" ? "rounded-bl-none rounded-br-none" : "rounded-tl-none rounded-tr-none")
    )}"></div><sd-popup @sd-current-placement="${this.handleCurrentPlacement}" class="${cx(
      "inline-flex relative w-full",
      this.currentPlacement === "bottom" ? "origin-top" : "origin-bottom"
    )}" placement="${this.placement}" strategy="${this.hoist ? "fixed" : "absolute"}" flip shift sync="width" auto-size="vertical" auto-size-padding="10" exportparts="
              popup:popup__content,
            "><div part="combobox" class="${cx(
      "relative w-full px-4 flex flex-row items-center rounded-default",
      this.open && "shadow",
      {
        sm: "py-1 min-h-[32px]",
        md: "py-1 min-h-[40px]",
        lg: "py-2 min-h-[48px]"
      }[this.size]
    )}" slot="anchor" @keydown="${this.handleComboboxKeyDown}" @mousedown="${this.handleComboboxMouseDown}" @mouseenter="${this.handleMouseEnter}" @mouseleave="${this.handleMouseLeave}"><input name="${this.name}" form="${this.form}" part="display-input" class="${cx(
      "appearance-none outline-none flex-grow bg-transparent w-full placeholder-neutral-700",
      cursorStyles,
      this.multiple && this.useTags && this.value.length > 0 ? "hidden" : ""
    )}" type="text" .disabled="${this.disabled}" placeholder="${this.placeholder || this.localize.term("selectDefaultPlaceholder")}" .value="${this.displayLabel}" autocomplete="off" spellcheck="false" autocapitalize="off" readonly="readonly" aria-controls="listbox" aria-expanded="${this.open ? "true" : "false"}" aria-haspopup="listbox" aria-labelledby="label" aria-disabled="${this.disabled ? "true" : "false"}" aria-invalid="${this.showInvalidStyle}" aria-describedby="help-text invalid-message" role="combobox" tabindex="0" @focus="${this.handleFocus}" @blur="${this.handleBlur}"> ${this.multiple && this.useTags ? html`<div part="tags" class="flex-grow flex flex-wrap items-center gap-1">${this.tags}</div>` : ""}<div aria-live="polite" id="control-value" class="absolute top-0 left-0 opacity-0 -z-10">${this.selectedOptions.map((option) => option == null ? void 0 : option.getTextLabel()).join(", ")}</div><input class="${cx("value-input absolute top-0 left-0 w-full h-full opacity-0 -z-10", cursorStyles)}" type="text" ?disabled="${this.disabled}" ?required="${this.required}" .value="${Array.isArray(this.value) ? this.value.join(", ") : this.value}" tabindex="-1" aria-controls="control-value" aria-hidden="true" @focus="${() => this.focus()}" @invalid="${this.handleInvalid}"> ${hasClearIcon ? html`<button part="clear-button" class="${cx(
      "select__clear flex justify-center",
      iconMarginLeft,
      this.value.length > 0 ? "visible" : "invisible"
    )}" type="button" aria-label="${this.localize.term("clearEntry")}" @mousedown="${this.handleClearMouseDown}" @click="${this.handleClearClick}" tabindex="-1"><slot name="clear-icon"><sd-icon class="${cx("text-icon-fill-neutral-800", iconSize)}" library="system" name="closing-round"></sd-icon></slot></button>` : ""} ${this.showInvalidStyle ? html`<sd-icon part="invalid-icon" class="${cx(iconMarginLeft, iconSize, "text-error")}" library="system" name="risk"></sd-icon>` : ""} ${this.styleOnValid && this.showValidStyle ? html`<sd-icon part="valid-icon" class="${cx("flex-shrink-0 text-success", iconMarginLeft, iconSize)}" library="system" name="status-check"></sd-icon>` : ""}<slot name="expand-icon" part="expand-icon" class="${cx(
      "inline-flex ml-2 transition-all",
      this.open ? "rotate-180" : "rotate-0",
      this.disabled ? "text-neutral-500" : "text-primary",
      iconSize
    )}"><sd-icon name="chevron-down" part="chevron" library="system" color="currentColor"></sd-icon></slot></div><div id="listbox" role="listbox" aria-expanded="${this.open ? "true" : "false"}" aria-multiselectable="${this.multiple ? "true" : "false"}" aria-labelledby="label" part="listbox" class="${cx(
      "bg-white px-2 py-3 relative border-primary overflow-y-auto",
      this.open && "shadow",
      this.currentPlacement === "bottom" ? "border-r-2 border-b-2 border-l-2 rounded-br-default rounded-bl-default" : "border-r-2 border-t-2 border-l-2 rounded-tr-default rounded-tl-default"
    )}" tabindex="-1" @mouseup="${this.handleOptionClick}" @slotchange="${this.handleDefaultSlotChange}"><slot></slot></div></sd-popup></div><div class="text-sm text-neutral-700" part="form-control-help-text" id="help-text" aria-hidden="${hasHelpText ? "false" : "true"}"><slot name="help-text">${this.helpText}</slot></div></div>${this.formControlController.renderInvalidMessage()}`;
  }
};
SdSelect.dependencies = {
  "sd-icon": SdIcon,
  "sd-popup": SdPopup,
  "sd-tag": SdTag
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdSelect.styles = [
  ...SolidElement.styles,
  css`:host{display:block;position:relative;width:100%}:host([required]) #label:after{content:" *"}[part=listbox]{max-height:var(--auto-size-available-height,auto)}sd-popup::part(popup){z-index:var(--sd-z-index-dropdown,900)}sd-tag::part(base){border-radius:var(--sd-border-radius-default,.25rem);padding-left:var(--sd-spacing-1,.25rem);padding-right:var(--sd-spacing-1,.25rem)}sd-tag::part(content){display:inline-block;max-width:var(--tag-max-width,15ch);overflow:hidden;text-overflow:ellipsis;white-space:nowrap}sd-tag[size=lg]::part(base){padding-left:var(--sd-spacing-2,.5rem);padding-right:var(--sd-spacing-2,.5rem)}sd-tag[disabled=false]::part(base):hover{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-100,236 240 249)/var(--tw-bg-opacity,1))}`
];
__decorateClass([
  queryAssignedElements({ selector: "sd-option" })
], SdSelect.prototype, "_optionsInDefaultSlot", 2);
__decorateClass([
  query("sd-popup")
], SdSelect.prototype, "popup", 2);
__decorateClass([
  query('[part="combobox"]')
], SdSelect.prototype, "combobox", 2);
__decorateClass([
  query('[part="display-input"]')
], SdSelect.prototype, "displayInput", 2);
__decorateClass([
  query(".value-input")
], SdSelect.prototype, "valueInput", 2);
__decorateClass([
  query('[part="listbox"]')
], SdSelect.prototype, "listbox", 2);
__decorateClass([
  query("#invalid-message")
], SdSelect.prototype, "invalidMessage", 2);
__decorateClass([
  state()
], SdSelect.prototype, "hasHover", 2);
__decorateClass([
  state()
], SdSelect.prototype, "displayLabel", 2);
__decorateClass([
  state()
], SdSelect.prototype, "deletedTagLabel", 2);
__decorateClass([
  state()
], SdSelect.prototype, "hasFocus", 2);
__decorateClass([
  state()
], SdSelect.prototype, "currentOption", 2);
__decorateClass([
  state()
], SdSelect.prototype, "selectedOptions", 2);
__decorateClass([
  state()
], SdSelect.prototype, "showValidStyle", 2);
__decorateClass([
  state()
], SdSelect.prototype, "showInvalidStyle", 2);
__decorateClass([
  defaultValue()
], SdSelect.prototype, "defaultValue", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdSelect.prototype, "open", 2);
__decorateClass([
  property({ reflect: true })
], SdSelect.prototype, "size", 2);
__decorateClass([
  property({ reflect: true })
], SdSelect.prototype, "placement", 2);
__decorateClass([
  property()
], SdSelect.prototype, "label", 2);
__decorateClass([
  property()
], SdSelect.prototype, "placeholder", 2);
__decorateClass([
  property({ attribute: "max-options-tag-label" })
], SdSelect.prototype, "maxOptionsTagLabel", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdSelect.prototype, "disabled", 2);
__decorateClass([
  property({ attribute: "help-text" })
], SdSelect.prototype, "helpText", 2);
__decorateClass([
  state()
], SdSelect.prototype, "currentPlacement", 2);
__decorateClass([
  property({ type: Boolean })
], SdSelect.prototype, "clearable", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdSelect.prototype, "multiple", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdSelect.prototype, "useTags", 2);
__decorateClass([
  property({ attribute: "max-options-visible", type: Number })
], SdSelect.prototype, "maxOptionsVisible", 2);
__decorateClass([
  property({ reflect: true })
], SdSelect.prototype, "form", 2);
__decorateClass([
  property()
], SdSelect.prototype, "name", 2);
__decorateClass([
  property({
    converter: {
      fromAttribute: (value) => value.split(" "),
      toAttribute: (value) => value.join(" ")
    }
  })
], SdSelect.prototype, "value", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdSelect.prototype, "required", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "style-on-valid" })
], SdSelect.prototype, "styleOnValid", 2);
__decorateClass([
  property({ type: Boolean })
], SdSelect.prototype, "hoist", 2);
__decorateClass([
  property()
], SdSelect.prototype, "getTag", 2);
__decorateClass([
  watch("useTags", { waitUntilFirstUpdate: true })
], SdSelect.prototype, "handleUseTagsChange", 1);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdSelect.prototype, "handleDisabledChange", 1);
__decorateClass([
  watch("open", { waitUntilFirstUpdate: true })
], SdSelect.prototype, "handleOpenChange", 1);
__decorateClass([
  watch("size", { waitUntilFirstUpdate: true })
], SdSelect.prototype, "applySizeToOptions", 1);
__decorateClass([
  watch("value", { waitUntilFirstUpdate: true })
], SdSelect.prototype, "handleValueChange", 1);
SdSelect = __decorateClass([
  customElement("sd-select")
], SdSelect);
setDefaultAnimation("select.show", {
  keyframes: [
    { opacity: 0, scale: 0.9 },
    { opacity: 1, scale: 1 }
  ],
  options: { duration: 100, easing: "ease" }
});
setDefaultAnimation("select.hide", {
  keyframes: [
    { opacity: 1, scale: 1 },
    { opacity: 0, scale: 0.9 }
  ],
  options: { duration: 100, easing: "ease" }
});

export {
  SdSelect
};
