import {
  defaultValue
} from "./chunk.GI7VDIWX.js";
import {
  FormControlController
} from "./chunk.KVKRZJS7.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/textarea/textarea.ts
import { css, html } from "lit";
import { ifDefined } from "lit/directives/if-defined.js";
import { live } from "lit/directives/live.js";
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var SdTextarea = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.formControlController = new FormControlController(this);
    this.hasSlotController = new HasSlotController(this, "help-text", "label");
    this.hasFocus = false;
    this.showValidStyle = false;
    this.showInvalidStyle = false;
    this.title = "";
    this.name = "";
    this.value = "";
    this.size = "lg";
    this.label = "";
    this.helpText = "";
    this.placeholder = "";
    this.rows = 4;
    this.disabled = false;
    this.readonly = false;
    this.form = "";
    this.required = false;
    this.styleOnValid = false;
    this.spellcheck = true;
    this.defaultValue = "";
  }
  /** Gets the validity state object */
  get validity() {
    return this.textarea.validity;
  }
  /** Gets the validation message */
  get validationMessage() {
    return this.textarea.validationMessage;
  }
  connectedCallback() {
    super.connectedCallback();
    this.updateComplete.then(() => {
      this.setTextareaHeight();
    });
  }
  firstUpdated() {
    this.formControlController.updateValidity();
  }
  disconnectedCallback() {
    super.disconnectedCallback();
  }
  handleBlur() {
    this.hasFocus = false;
    this.emit("sd-blur");
  }
  handleChange() {
    this.value = this.textarea.value;
    this.setTextareaHeight();
    this.emit("sd-change");
  }
  handleFocus() {
    this.hasFocus = true;
    this.emit("sd-focus");
  }
  handleInput() {
    this.value = this.textarea.value;
    this.formControlController.updateValidity();
    this.emit("sd-input");
  }
  handleInvalid(event) {
    this.formControlController.setValidity(false);
    this.formControlController.emitInvalidEvent(event);
    this.invalidMessage.textContent = event.target.validationMessage;
  }
  setTextareaHeight() {
    this.textarea.style.height = void 0;
  }
  handleDisabledChange() {
    this.formControlController.setValidity(this.disabled);
  }
  handleRowsChange() {
    this.setTextareaHeight();
  }
  async handleValueChange() {
    await this.updateComplete;
    this.formControlController.updateValidity();
    this.setTextareaHeight();
  }
  /** Sets focus on the textarea. */
  focus(options) {
    this.textarea.focus(options);
  }
  /** Removes focus from the textarea. */
  blur() {
    this.textarea.blur();
  }
  /** Selects all the text in the textarea. */
  select() {
    this.textarea.select();
  }
  /** Gets or sets the textarea's scroll position. */
  scrollPosition(position) {
    if (position) {
      if (typeof position.top === "number") this.textarea.scrollTop = position.top;
      if (typeof position.left === "number") this.textarea.scrollLeft = position.left;
      return void 0;
    }
    return {
      top: this.textarea.scrollTop,
      left: this.textarea.scrollTop
    };
  }
  /** Sets the start and end positions of the text selection (0-based). */
  setSelectionRange(selectionStart, selectionEnd, selectionDirection = "none") {
    this.textarea.setSelectionRange(selectionStart, selectionEnd, selectionDirection);
  }
  /** Replaces a range of text with a new string. */
  setRangeText(replacement, start, end, selectMode) {
    this.textarea.setRangeText(replacement, start, end, selectMode);
    if (this.value !== this.textarea.value) {
      this.value = this.textarea.value;
    }
    if (this.value !== this.textarea.value) {
      this.value = this.textarea.value;
      this.setTextareaHeight();
    }
  }
  /** Checks for validity but does not show a validation message. Returns `true` when valid and `false` when invalid. */
  checkValidity() {
    var _a;
    return (_a = this.textarea) == null ? void 0 : _a.checkValidity();
  }
  /** Gets the associated form, if one exists. */
  getForm() {
    return this.formControlController.getForm();
  }
  /** Checks for validity and shows the browser's validation message if the control is invalid. */
  reportValidity() {
    this.formControlController.fakeUserInteraction();
    return this.textarea.reportValidity();
  }
  /** Sets a custom validation message. Pass an empty string to restore validity. */
  setCustomValidity(message) {
    this.textarea.setCustomValidity(message);
    this.formControlController.updateValidity();
  }
  render() {
    const slots = {
      label: this.hasSlotController.test("label"),
      helpText: this.hasSlotController.test("help-text")
    };
    const hasLabel = this.label ? true : !!slots["label"];
    const hasHelpText = this.helpText ? true : !!slots["helpText"];
    const textareaState = this.disabled ? "disabled" : this.readonly ? "readonly" : this.hasFocus && this.showInvalidStyle ? "activeInvalid" : this.hasFocus && this.styleOnValid && this.showValidStyle ? "activeValid" : this.hasFocus ? "active" : this.showInvalidStyle ? "invalid" : this.styleOnValid && this.showValidStyle ? "valid" : "default";
    const textSize = this.size === "sm" ? "text-sm" : "text-base";
    const iconSizeMarginLeft = {
      sm: "text-base ml-1",
      md: "text-lg ml-2",
      lg: "text-xl ml-2"
    }[this.size];
    return html`<div part="form-control" class="flex flex-col h-full text-left"><div class="flex items-center gap-1 mb-2"><label part="form-control-label" id="label" class="${cx(hasLabel ? "inline-block" : "hidden", textSize)}" for="input" aria-hidden="${hasLabel ? "false" : "true"}"><slot name="label">${this.label}</slot></label><slot name="tooltip"></slot></div><div part="form-control-input" class="${cx("relative h-full w-full", this.disabled && "cursor-not-allowed")}"><div part="border" class="${cx(
      "absolute w-full h-full pointer-events-none border rounded-default",
      {
        disabled: "border-neutral-500",
        readonly: "border-neutral-800",
        activeInvalid: "border-error border-2",
        activeValid: "border-success border-2",
        active: "border-primary border-2",
        invalid: "border-error",
        valid: "border-success",
        default: "border-neutral-800"
      }[textareaState]
    )}"></div><div part="base" class="${cx(
      "textarea h-full px-4 flex items-top rounded-default group",
      {
        sm: "textarea-sm py-1",
        md: "textarea-md py-1",
        lg: "textarea-lg py-2"
      }[this.size],
      !this.disabled && !this.readonly ? "hover:bg-neutral-200" : "",
      this.readonly ? "bg-neutral-100" : "bg-white",
      textareaState === "disabled" ? "text-neutral-500" : "text-black"
    )}"><textarea part="textarea" id="input" class="${cx(
      "flex-grow focus:outline-none bg-transparent placeholder-neutral-700 resize-none",
      this.disabled && "cursor-not-allowed",
      textSize
    )}" title="${this.title}" name="${ifDefined(this.name)}" .value="${live(this.value)}" ?disabled="${this.disabled}" ?readonly="${this.readonly}" ?required="${this.required}" placeholder="${ifDefined(this.placeholder)}" minlength="${ifDefined(this.minlength)}" maxlength="${ifDefined(this.maxlength)}" rows="${ifDefined(this.rows)}" autocapitalize="${ifDefined(this.autocapitalize)}" autocorrect="${ifDefined(this.autocorrect)}" ?autofocus="${this.autofocus}" spellcheck="${ifDefined(this.spellcheck)}" enterkeyhint="${ifDefined(this.enterkeyhint)}" inputmode="${ifDefined(this.inputmode)}" aria-describedby="help-text invalid-message" aria-invalid="${this.showInvalidStyle}" @change="${this.handleChange}" @input="${this.handleInput}" @invalid="${this.handleInvalid}" @focus="${this.handleFocus}" @blur="${this.handleBlur}"></textarea> ${this.showInvalidStyle ? html`<sd-icon class="${cx("text-error absolute right-4 bg-white group-hover:bg-neutral-200", iconSizeMarginLeft)}" library="system" name="risk" part="invalid-icon"></sd-icon>` : ""} ${this.styleOnValid && this.showValidStyle ? html`<sd-icon class="${cx("text-success absolute right-4 bg-white group-hover:bg-neutral-200", iconSizeMarginLeft)}" library="system" name="status-check" part="valid-icon"></sd-icon>` : ""}</div></div><slot name="help-text" part="form-control-help-text" id="help-text" class="${cx("text-sm text-neutral-700", hasHelpText ? "block" : "hidden")}" aria-hidden="${hasHelpText ? "false" : "true"}">${this.helpText}</slot></div>${this.formControlController.renderInvalidMessage()}`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdTextarea.styles = [
  ...SolidElement.styles,
  css`:host{display:block;height:100%}:host([required]) #label:after{content:" *"}.no-scrollbar::-webkit-scrollbar{display:none}`
];
__decorateClass([
  query("#input")
], SdTextarea.prototype, "textarea", 2);
__decorateClass([
  query("#invalid-message")
], SdTextarea.prototype, "invalidMessage", 2);
__decorateClass([
  state()
], SdTextarea.prototype, "hasFocus", 2);
__decorateClass([
  state()
], SdTextarea.prototype, "showValidStyle", 2);
__decorateClass([
  state()
], SdTextarea.prototype, "showInvalidStyle", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "title", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "name", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "value", 2);
__decorateClass([
  property({ reflect: true })
], SdTextarea.prototype, "size", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "label", 2);
__decorateClass([
  property({ attribute: "help-text" })
], SdTextarea.prototype, "helpText", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "placeholder", 2);
__decorateClass([
  property({ type: Number })
], SdTextarea.prototype, "rows", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTextarea.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTextarea.prototype, "readonly", 2);
__decorateClass([
  property({ reflect: true })
], SdTextarea.prototype, "form", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdTextarea.prototype, "required", 2);
__decorateClass([
  property({ type: Number })
], SdTextarea.prototype, "minlength", 2);
__decorateClass([
  property({ type: Number })
], SdTextarea.prototype, "maxlength", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "autocapitalize", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "autocorrect", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "autocomplete", 2);
__decorateClass([
  property({ type: Boolean })
], SdTextarea.prototype, "autofocus", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "enterkeyhint", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "style-on-valid" })
], SdTextarea.prototype, "styleOnValid", 2);
__decorateClass([
  property({
    type: Boolean,
    converter: {
      // Allow "true|false" attribute values but keep the property boolean
      fromAttribute: (value) => !value || value === "false" ? false : true,
      toAttribute: (value) => value ? "true" : "false"
    }
  })
], SdTextarea.prototype, "spellcheck", 2);
__decorateClass([
  property()
], SdTextarea.prototype, "inputmode", 2);
__decorateClass([
  defaultValue()
], SdTextarea.prototype, "defaultValue", 2);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdTextarea.prototype, "handleDisabledChange", 1);
__decorateClass([
  watch("rows", { waitUntilFirstUpdate: true })
], SdTextarea.prototype, "handleRowsChange", 1);
__decorateClass([
  watch("value", { waitUntilFirstUpdate: true })
], SdTextarea.prototype, "handleValueChange", 1);
SdTextarea = __decorateClass([
  customElement("sd-textarea")
], SdTextarea);

export {
  SdTextarea
};
