import {
  __spreadValues
} from "./chunk.S3NI7NKU.js";

// src/utilities/localize.ts
import { LocalizeController as DefaultLocalizationController } from "@shoelace-style/localize";
var LocalizeController = class extends DefaultLocalizationController {
  constructor(host) {
    super(host);
    this._instanceTranslations = null;
  }
  get instanceTranslations() {
    return this._instanceTranslations;
  }
  set instanceTranslations(value) {
    this._instanceTranslations = value;
    this.host.requestUpdate();
  }
  hostConnected() {
    super.hostConnected();
    this.setCustomLocalizationFromData();
    new MutationObserver(() => this.setCustomLocalizationFromData()).observe(this.host, {
      attributes: true,
      attributeFilter: ["data-custom-localization"]
    });
  }
  hostDisconnected() {
    super.hostDisconnected();
  }
  setCustomLocalizationFromData() {
    const dataCustomLocalization = this.host.dataset.customLocalization;
    if (dataCustomLocalization) {
      try {
        this.setCustomLocalization(JSON.parse(dataCustomLocalization));
      } catch (error) {
        console.error("Error parsing custom-localization attribute:", error);
      }
    }
  }
  term(key, ...args) {
    const term = this.instanceTranslations && this.instanceTranslations[key];
    if (term) {
      if (typeof term === "function") {
        return term(...args);
      }
      return term;
    }
    return super.term(key, ...args);
  }
  setCustomLocalization(customLocalization) {
    this.instanceTranslations = __spreadValues(__spreadValues({}, this.instanceTranslations), customLocalization);
  }
};

export {
  LocalizeController
};
