import { Wave } from './wave';
import SolidElement from '../../internal/solid-element';
import type SdDrawer from '../drawer/drawer';
export default class SdAudio extends SolidElement {
    private readonly localize;
    private readonly hasSlotController;
    reversedLayout: boolean;
    hideTimestamps: boolean;
    animated: boolean;
    inverted: boolean;
    speed: number;
    currentTime: string;
    duration: string;
    isPlaying: boolean;
    isMuted: boolean;
    progress: number;
    progressSlider: HTMLInputElement;
    audioPlayerContainer: HTMLElement;
    drawer: SdDrawer;
    canvas: HTMLCanvasElement;
    context: CanvasRenderingContext2D;
    waveList: Wave[];
    constructor();
    firstUpdated(): void;
    updated(changedProperties: Map<string | number | symbol, unknown>): void;
    private get audioElement();
    private setAudioProgress;
    private updateCurrentTime;
    private updateAudioDuration;
    playAudio(): void;
    pauseAudio(): void;
    handleAudioEnd(): void;
    private toggleMute;
    private toggleMuteKeydown;
    togglePlaybackSpeed(): void;
    private togglePlaybackSpeedKeydown;
    private formatTime;
    private handleAudioProgress;
    private handleAudioProgressKeydown;
    private showTranscript;
    private showTranscriptKeydown;
    private rgbToHex;
    private initAnimation;
    private drawStillWaves;
    private stopAnimation;
    private clear;
    draw(): Promise<void>;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-audio': SdAudio;
    }
}
