import '../popup/popup';
import { LocalizeController } from '../../utilities/localize';
import SolidElement from '../../internal/solid-element';
import type SdMenu from '../../_components/menu/menu';
import type SdPopup from '../popup/popup';
export default class SdDropdown extends SolidElement {
    popup: SdPopup;
    trigger: HTMLSlotElement;
    panel: HTMLSlotElement;
    localize: LocalizeController;
    open: boolean;
    rounded: boolean;
    placement: 'top' | 'top-start' | 'top-end' | 'bottom' | 'bottom-start' | 'bottom-end' | 'right' | 'right-start' | 'right-end' | 'left' | 'left-start' | 'left-end';
    disabled: boolean;
    stayOpenOnSelect: boolean;
    containingElement?: HTMLElement;
    distance: number;
    skidding: number;
    noAutoSize: boolean;
    noFlip: boolean;
    hoist: boolean;
    connectedCallback(): void;
    firstUpdated(): void;
    disconnectedCallback(): void;
    getAccessibleTrigger(): HTMLElement | null;
    updateAccessibleTrigger(): void;
    focusOnTrigger(): void;
    getMenu(): SdMenu | undefined;
    handleKeyDown(event: KeyboardEvent): void;
    handleDocumentKeyDown(event: KeyboardEvent): void;
    handleDocumentMouseDown(event: MouseEvent): void;
    handleMenuItemActivate(event: CustomEvent): void;
    handlePanelSelect(event: CustomEvent): void;
    handleTriggerClick(): void;
    handleTriggerKeyDown(event: KeyboardEvent): void;
    handleTriggerKeyUp(event: KeyboardEvent): void;
    handleTriggerSlotChange(): void;
    show(): Promise<void>;
    hide(): Promise<void>;
    reposition(): void;
    addOpenListeners(): void;
    removeOpenListeners(): void;
    handleOpenChange(): Promise<void>;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-dropdown': SdDropdown;
    }
}
