import '../icon/icon';
import { FormControlController } from '../../internal/form';
import { LocalizeController } from '../../utilities/localize';
import SolidElement from '../../internal/solid-element';
import type { SolidFormControl } from '../../internal/solid-element';
export default class SdInput extends SolidElement implements SolidFormControl {
    protected readonly formControlController: FormControlController;
    private readonly hasSlotController;
    localize: LocalizeController;
    input: HTMLInputElement;
    invalidMessage: HTMLDivElement;
    hasFocus: boolean;
    showValidStyle: boolean;
    showInvalidStyle: boolean;
    type: 'date' | 'datetime-local' | 'email' | 'number' | 'password' | 'search' | 'tel' | 'text' | 'time' | 'url';
    size: 'lg' | 'md' | 'sm';
    inputmode: 'none' | 'text' | 'decimal' | 'numeric' | 'tel' | 'search' | 'email' | 'url';
    value: string;
    defaultValue: string;
    placeholder: string;
    label: string;
    helpText: string;
    clearable: boolean;
    disabled: boolean;
    readonly: boolean;
    passwordToggle: boolean;
    passwordVisible: boolean;
    spinButtons: boolean;
    minlength: number;
    maxlength: number;
    min: number | string;
    max: number | string;
    form: string;
    name: string;
    title: string;
    required: boolean;
    pattern: string;
    step: number | 'any';
    autocapitalize: 'off' | 'none' | 'on' | 'sentences' | 'words' | 'characters';
    autocorrect: 'off' | 'on';
    autocomplete: string;
    autofocus: boolean;
    enterkeyhint: 'enter' | 'done' | 'go' | 'next' | 'previous' | 'search' | 'send';
    styleOnValid: boolean;
    spellcheck: boolean;
    get valueAsDate(): Date | null;
    set valueAsDate(newValue: Date | null);
    get valueAsNumber(): number;
    set valueAsNumber(newValue: number);
    get validity(): ValidityState;
    firstUpdated(): void;
    private handleBlur;
    private handleChange;
    private handleClearClick;
    private handleFocus;
    private handleInput;
    private handleInvalid;
    private handleKeyDown;
    private handlePasswordToggle;
    private isDecrementDisabled;
    private isIncrementDisabled;
    private handleStep;
    private handleStepUp;
    private handleStepDown;
    handleDisabledChange(): void;
    handleStepChange(): void;
    handleValueChange(): Promise<void>;
    focus(options?: FocusOptions): void;
    blur(): void;
    select(): void;
    setSelectionRange(selectionStart: number, selectionEnd: number, selectionDirection?: 'forward' | 'backward' | 'none'): void;
    setRangeText(replacement: string, start?: number, end?: number, selectMode?: 'select' | 'start' | 'end' | 'preserve'): void;
    showPicker(): void;
    stepUp(): void;
    stepDown(): void;
    checkValidity(): boolean;
    reportValidity(): boolean;
    setCustomValidity(message: string): void;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-input': SdInput;
    }
}
