import SolidElement from '../../internal/solid-element';
export default class SdLink extends SolidElement {
    private readonly hasSlotController;
    button: HTMLButtonElement | HTMLLinkElement;
    standalone: boolean;
    size: 'inherit' | 'lg' | 'sm';
    inverted: boolean;
    href: string;
    target: '_blank' | '_parent' | '_self' | '_top';
    download?: string;
    private handleBlur;
    private handleFocus;
    focus(options?: FocusOptions): void;
    blur(): void;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-link': SdLink;
    }
}
