import { LocalizeController } from '../../utilities/localize.js';
import SdIcon from '../icon/icon';
import SdPopup from '../popup/popup';
import SdTag from '../tag/tag';
import SolidElement from '../../internal/solid-element';
import type { SolidFormControl } from '../../internal/solid-element';
import type { TemplateResult } from 'lit';
import type SdOption from '../option/option';
export default class SdSelect extends SolidElement implements SolidFormControl {
    static dependencies: {
        'sd-icon': typeof SdIcon;
        'sd-popup': typeof SdPopup;
        'sd-tag': typeof SdTag;
    };
    private readonly formControlController;
    private readonly hasSlotController;
    localize: LocalizeController;
    private typeToSelectString;
    private typeToSelectTimeout;
    _optionsInDefaultSlot: SdOption[];
    popup: SdPopup;
    combobox: HTMLSlotElement;
    displayInput: HTMLInputElement;
    valueInput: HTMLInputElement;
    listbox: HTMLSlotElement;
    invalidMessage: HTMLDivElement;
    hasHover: boolean;
    private displayLabel;
    private deletedTagLabel;
    hasFocus: boolean;
    currentOption: SdOption;
    selectedOptions: SdOption[];
    showValidStyle: boolean;
    showInvalidStyle: boolean;
    defaultValue: string | string[];
    open: boolean;
    size: 'lg' | 'md' | 'sm';
    placement: 'top' | 'bottom';
    label: string;
    placeholder: string;
    maxOptionsTagLabel: string;
    disabled: boolean;
    helpText: string;
    currentPlacement: "top" | "bottom";
    clearable: boolean;
    multiple: boolean;
    useTags: boolean;
    maxOptionsVisible: number;
    form: string;
    name: string;
    value: string | string[];
    required: boolean;
    styleOnValid: boolean;
    hoist: boolean;
    getTag: (option: SdOption, index: number) => TemplateResult | string | HTMLElement;
    get validity(): ValidityState;
    get validationMessage(): string;
    connectedCallback(): void;
    firstUpdated(): void;
    private addOpenListeners;
    private removeOpenListeners;
    private handleFocus;
    private handleBlur;
    private handleDocumentFocusIn;
    private handleDocumentKeyDown;
    private handleDocumentMouseDown;
    private handleTagKeyDown;
    private handleTagMaxOptionsKeyDown;
    private handleLabelClick;
    private handleComboboxMouseDown;
    private handleComboboxKeyDown;
    private handleClearClick;
    private clearSelect;
    private handleClearMouseDown;
    private handleOptionClick;
    private handleDefaultSlotChange;
    private handleTagRemove;
    private getAllOptions;
    private getFirstOption;
    private setCurrentOption;
    private setSelectedOptions;
    private toggleOptionSelection;
    private selectionChanged;
    protected get tags(): (TemplateResult<1> | TemplateResult<1>[])[];
    private handleInvalid;
    private handleMouseEnter;
    private handleMouseLeave;
    private handleCurrentPlacement;
    handleUseTagsChange(): void;
    handleDisabledChange(): void;
    handleOpenChange(): Promise<void>;
    applySizeToOptions(): void;
    handleValueChange(): void;
    show(): Promise<void>;
    hide(): Promise<void>;
    checkValidity(): boolean;
    getForm(): HTMLFormElement | null;
    reportValidity(): boolean;
    setCustomValidity(message: string): void;
    focus(options?: FocusOptions): void;
    blur(): void;
    render(): TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-select': SdSelect;
    }
}
