import { LocalizeController } from '../../utilities/localize';
import SolidElement from '../../internal/solid-element';
export default class SdTabGroup extends SolidElement {
    localize: LocalizeController;
    private activeTab?;
    private mutationObserver;
    private resizeObserver;
    private tabs;
    private panels;
    tabGroup: HTMLElement;
    body: HTMLSlotElement;
    nav: HTMLElement;
    hasScrollControls: boolean;
    variant: string;
    activation: 'auto' | 'manual';
    connectedCallback(): void;
    disconnectedCallback(): void;
    private getAllTabs;
    private getAllPanels;
    private getActiveTab;
    private handleClick;
    private handleKeyDown;
    private handleScrollToStart;
    private handleScrollToEnd;
    private setActiveTab;
    private setAriaLabels;
    private syncTabsAndPanels;
    private updateScrollControls;
    show(panel: string): void;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-tab-group': SdTabGroup;
    }
}
