const legacyCustomElement = (tagName, clazz) => {
    if (window.customElements.get(tagName)) {
        console.warn(`Custom element ${tagName} already defined. Registration skipped.`);
        return clazz;
    }
    window.customElements.define(tagName, clazz);
    return clazz;
};
const standardCustomElement = (tagName, descriptor) => {
    const { kind, elements } = descriptor;
    return {
        kind,
        elements,
        finisher(clazz) {
            if (window.customElements.get(tagName)) {
                console.warn(`Custom element ${tagName} already defined. Registration skipped.`);
                return;
            }
            window.customElements.define(tagName, clazz);
        }
    };
};
export const customElement = (tagName) => (classOrDescriptor) => typeof classOrDescriptor === 'function'
    ? legacyCustomElement(tagName, classOrDescriptor)
    : standardCustomElement(tagName, classOrDescriptor);
