import { LitElement } from 'lit';
export default class SolidElement extends LitElement {
    dir: 'ltr' | 'rtl' | 'auto';
    lang: string;
    static styles: import("lit").CSSResult[];
    emit(name: string, options?: CustomEventInit): CustomEvent<any>;
}
export interface SolidFormControl extends SolidElement {
    name: string;
    value: unknown;
    disabled?: boolean;
    defaultValue?: unknown;
    defaultChecked?: boolean;
    form?: string;
    pattern?: string;
    min?: number | Date | string;
    max?: number | Date | string;
    step?: number | 'any';
    required?: boolean;
    minlength?: number;
    maxlength?: number;
    readonly validity?: ValidityState;
    readonly validationMessage?: string;
    checkValidity: () => boolean;
    reportValidity: () => boolean;
    setCustomValidity: (message: string) => void;
    showValidStyle?: boolean;
    showInvalidStyle?: boolean;
}
