"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _solidAuthClient = _interopRequireDefault(require("solid-auth-client"));

var _v = _interopRequireDefault(require("uuid/v4"));

var _context = _interopRequireDefault(require("./context.json"));

var _ldflex = require("ldflex");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _awaitAsyncGenerator(value) { return new _AwaitValue(value); }

function _wrapAsyncGenerator(fn) { return function () { return new _AsyncGenerator(fn.apply(this, arguments)); }; }

function _AsyncGenerator(gen) { var front, back; function send(key, arg) { return new Promise(function (resolve, reject) { var request = { key: key, arg: arg, resolve: resolve, reject: reject, next: null }; if (back) { back = back.next = request; } else { front = back = request; resume(key, arg); } }); } function resume(key, arg) { try { var result = gen[key](arg); var value = result.value; var wrappedAwait = value instanceof _AwaitValue; Promise.resolve(wrappedAwait ? value.wrapped : value).then(function (arg) { if (wrappedAwait) { resume("next", arg); return; } settle(result.done ? "return" : "normal", arg); }, function (err) { resume("throw", err); }); } catch (err) { settle("throw", err); } } function settle(type, value) { switch (type) { case "return": front.resolve({ value: value, done: true }); break; case "throw": front.reject(value); break; default: front.resolve({ value: value, done: false }); break; } front = front.next; if (front) { resume(front.key, front.arg); } else { back = null; } } this._invoke = send; if (typeof gen.return !== "function") { this.return = undefined; } }

if (typeof Symbol === "function" && Symbol.asyncIterator) { _AsyncGenerator.prototype[Symbol.asyncIterator] = function () { return this; }; }

_AsyncGenerator.prototype.next = function (arg) { return this._invoke("next", arg); };

_AsyncGenerator.prototype.throw = function (arg) { return this._invoke("throw", arg); };

_AsyncGenerator.prototype.return = function (arg) { return this._invoke("return", arg); };

function _AwaitValue(value) { this.wrapped = value; }

function _asyncIterator(iterable) { var method; if (typeof Symbol === "function") { if (Symbol.asyncIterator) { method = iterable[Symbol.asyncIterator]; if (method != null) return method.call(iterable); } if (Symbol.iterator) { method = iterable[Symbol.iterator]; if (method != null) return method.call(iterable); } } throw new TypeError("Object is not async iterable"); }

/* babel-plugin-inline-import './activity.ttl' */
const activityTemplate = "_:activity a _:type;\n    <https://www.w3.org/ns/activitystreams#actor> _:actor;\n    <https://www.w3.org/ns/activitystreams#object> _:object;\n    <https://www.w3.org/ns/activitystreams#published> _:published.\n";
const _context$Context = _context.default['@context'],
      as = _context$Context.as,
      xsd = _context$Context.xsd;
/**
 * Handler that creates an activity in the user's data pod
 */

class ActivityCreator {
  constructor({
    type = `${as}#Like`,
    path = '/public/activities'
  } = {}) {
    this._type = type;
    this._path = path;
  }

  execute(path, proxy) {
    const self = this;
    const root = proxy.root;
    const user = root.user; // Return an iterator over the new activity URLs

    return () => (0, _ldflex.iterablePromise)(_wrapAsyncGenerator(function* () {
      // Create an activity for each object on the path
      const activities = [];
      const inserts = [];
      const type = self._type;
      const actor = yield _awaitAsyncGenerator(user);
      const time = new Date().toISOString();
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;

      var _iteratorError;

      try {
        for (var _iterator = _asyncIterator(proxy), _step, _value; _step = yield _awaitAsyncGenerator(_iterator.next()), _iteratorNormalCompletion = _step.done, _value = yield _awaitAsyncGenerator(_step.value), !_iteratorNormalCompletion; _iteratorNormalCompletion = true) {
          const object = _value;

          if (typeof object === 'string' || object.termType === 'NamedNode') {
            const id = `#${(0, _v.default)()}`;
            const props = {
              id,
              type,
              actor,
              object,
              time
            };
            activities.push(id);
            inserts.push(self._createActivity(props));
          }
        } // Send the activity as a patch

      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            yield _awaitAsyncGenerator(_iterator.return());
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      const location = new URL(self._path, (yield _awaitAsyncGenerator(user.pim_storage)));
      yield _awaitAsyncGenerator(self._sendPatch(location, {
        insert: inserts.join('')
      })); // Return the URLs of the new activities

      for (const id of activities) yield root[new URL(id, location)];
    })());
  } // Creates a Turtle snippet representing the activity


  _createActivity({
    id,
    type,
    actor,
    object,
    time
  }) {
    return activityTemplate.replace(/_:activity/, `<${id}>`).replace(/_:type/, `<${type}>`).replace(/_:actor/g, `<${actor}>`).replace(/_:object/g, `<${object}>`).replace(/_:published/g, `"${time}"^^<${xsd}dateTime>`);
  } // Sends a PATCH request to create the activity


  _sendPatch(resource, {
    insert
  }) {
    const patch = `INSERT {\n${insert}\n}`;
    return _solidAuthClient.default.fetch(resource, {
      method: 'PATCH',
      headers: {
        'Content-Type': 'application/sparql-update'
      },
      body: patch
    });
  }

}

exports.default = ActivityCreator;